/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax.javacc.lib;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.modules.xml.text.syntax.javacc.lib.CharStream;
import org.netbeans.modules.xml.text.syntax.javacc.lib.SimpleCharStream;

public class StringParserInput
extends SimpleCharStream
implements CharStream {
    private char[] buffer;
    private int pos;
    private int begin;
    private int len;
    private int end;

    public void setString(String s) {
        this.buffer = s.toCharArray();
        this.pos = 0;
        this.begin = 0;
        this.end = this.len = s.length();
    }

    public void setBuffer(char[] buf, int offset, int len) {
        this.buffer = buf;
        this.begin = this.pos = offset;
        this.len = len;
        this.end = offset + len;
    }

    @Override
    public char readChar() throws IOException {
        if (this.pos >= this.end) {
            throw new EOFException();
        }
        return this.buffer[this.pos++];
    }

    @Override
    public int getColumn() {
        return 0;
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public int getEndColumn() {
        return 0;
    }

    @Override
    public int getEndLine() {
        return 0;
    }

    @Override
    public int getBeginColumn() {
        return 0;
    }

    @Override
    public int getBeginLine() {
        return 0;
    }

    @Override
    public void backup(int amount) {
        if (this.pos > 1) {
            this.pos -= amount;
        }
    }

    @Override
    public char BeginToken() throws IOException {
        this.begin = this.pos;
        return this.readChar();
    }

    @Override
    public String GetImage() {
        return new String(this.buffer, this.begin, this.pos - this.begin);
    }

    public int getLength() {
        return this.pos - this.begin;
    }

    @Override
    public char[] GetSuffix(int l) {
        char[] ret = new char[l];
        System.arraycopy(this.buffer, this.pos - l, ret, 0, l);
        return ret;
    }

    @Override
    public void Done() {
    }

    public String toString() {
        return "StringParserInput\n Pos:" + this.pos + " len:" + this.len + " #################\n" + this.buffer;
    }
}

