/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.phpmodule.PhpModuleGenerator;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.ui.ProjectConvertor;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public final class PhpProjectConvertor
implements ProjectConvertor {
    private static final Logger LOGGER = Logger.getLogger(PhpProjectConvertor.class.getName());
    static final String COMPOSER_JSON_FILENAME = "composer.json";
    private static final String PROJECT_ICON = "org/netbeans/modules/php/composer/ui/resources/phpProject.png";

    public ProjectConvertor.Result isProject(FileObject projectDirectory) {
        assert (projectDirectory != null);
        FileObject file = projectDirectory.getFileObject(COMPOSER_JSON_FILENAME);
        assert (file != null) : projectDirectory;
        JSONObject content = this.getContent(file);
        if (content == null) {
            return null;
        }
        String displayName = this.getDisplayName(content);
        if (!StringUtils.hasText((String)displayName)) {
            displayName = projectDirectory.getNameExt();
        }
        Lookup transientLkp = ProjectConvertors.createProjectConvertorLookup((Object[])new Object[]{new ConvertorClassPathProvider(), ProjectConvertors.createFileEncodingQuery()});
        return new ProjectConvertor.Result(transientLkp, (Callable)new Factory(projectDirectory, displayName, (Closeable)transientLkp), displayName, ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)PROJECT_ICON)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private JSONObject getContent(FileObject jsonFile) {
        assert (jsonFile != null);
        JSONParser parser = new JSONParser();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(jsonFile.getInputStream(), StandardCharsets.UTF_8));){
            Object content = parser.parse((Reader)reader);
            if (content instanceof JSONObject) {
                JSONObject jSONObject2 = (JSONObject)content;
                return jSONObject2;
            }
            LOGGER.log(Level.FINE, "Unexpected content of composer.json: {0}", FileUtil.toFile((FileObject)jsonFile));
            JSONObject jSONObject = null;
            return jSONObject;
        }
        catch (IOException | ParseException ex) {
            LOGGER.log(Level.FINE, jsonFile.getPath(), ex);
            return null;
        }
    }

    @CheckForNull
    private String getDisplayName(JSONObject content) {
        assert (content != null);
        Object name = content.get((Object)"name");
        if (name instanceof String) {
            String fullName = (String)name;
            String[] parts = fullName.split("/", 2);
            if (parts.length == 2) {
                return parts[1];
            }
            return fullName;
        }
        return null;
    }

    private static class ConvertorClassPathProvider
    implements ClassPathProvider {
        private ConvertorClassPathProvider() {
        }

        @CheckForNull
        public ClassPath findClassPath(@NonNull FileObject file, @NonNull String type) {
            Project project;
            if (("classpath/php-boot".equals(type) || "classpath/php-project-boot".equals(type) || "classpath/php-source".equals(type)) && (project = ProjectConvertors.getNonConvertorOwner((FileObject)file)) != null) {
                return ((ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class)).findClassPath(file, type);
            }
            return null;
        }
    }

    private static final class Factory
    implements Callable<Project> {
        private static final UsageLogger PROJECT_CONVERTOR_USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.php.composer").message(PhpProjectConvertor.class, "USG_PROJECT_CONVERTOR").create();
        private static final String[] KNOWN_SOURCE_ROOTS = new String[]{"src", "lib"};
        private final FileObject projectDirectory;
        private final String displayName;
        private final Closeable transientLkp;

        Factory(FileObject projectDirectory, String displayName, Closeable transientLkp) {
            assert (projectDirectory != null);
            assert (displayName != null) : projectDirectory;
            assert (transientLkp != null) : projectDirectory;
            this.projectDirectory = projectDirectory;
            this.displayName = displayName;
            this.transientLkp = transientLkp;
        }

        @Override
        public Project call() throws Exception {
            this.transientLkp.close();
            PROJECT_CONVERTOR_USAGE_LOGGER.log(new Object[]{PhpProjectConvertor.COMPOSER_JSON_FILENAME});
            PhpModuleGenerator phpModuleGenerator = (PhpModuleGenerator)Lookup.getDefault().lookup(PhpModuleGenerator.class);
            assert (phpModuleGenerator != null);
            phpModuleGenerator.createModule(new PhpModuleGenerator.CreateProperties().setName(this.displayName).setProjectDirectory(FileUtil.toFile((FileObject)this.projectDirectory)).setSourcesDirectory(FileUtil.toFile((FileObject)this.detectSourceRoot())).setPhpVersion(PhpVersion.getDefault()).setCharset(StandardCharsets.UTF_8).setAutoconfigured(true));
            Project project = FileOwnerQuery.getOwner((FileObject)this.projectDirectory);
            assert (project != null) : this.projectDirectory;
            return project;
        }

        private FileObject detectSourceRoot() {
            for (FileObject fileObject : this.projectDirectory.getChildren()) {
                if (!FileUtils.isPhpFile((FileObject)fileObject)) continue;
                return this.projectDirectory;
            }
            for (String string : KNOWN_SOURCE_ROOTS) {
                FileObject srcDir = this.projectDirectory.getFileObject(string);
                if (srcDir == null) continue;
                return srcDir;
            }
            return this.projectDirectory;
        }
    }
}

