/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.spi.intern.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.modules.project.spi.intern.ProjectIDEServicesImplementation;
import org.netbeans.modules.project.spi.intern.impl.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakListeners;

public class IDEServicesImpl
implements ProjectIDEServicesImplementation {
    public Icon loadIcon(String resource, boolean localized) {
        return ImageUtilities.loadImageIcon((String)resource, (boolean)localized);
    }

    public ProjectIDEServicesImplementation.FileBuiltQuerySource createFileBuiltQuerySource(FileObject file) {
        try {
            DataObject source = DataObject.find((FileObject)file);
            return new DataObjectSource(source);
        }
        catch (DataObjectNotFoundException e) {
            Logger.getLogger(IDEServicesImpl.class.getName()).log(Level.FINE, null, e);
            return null;
        }
    }

    public boolean isEventDispatchThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public boolean isUserQuestionException(IOException ioe) {
        return ioe instanceof UserQuestionException;
    }

    public void handleUserQuestionException(IOException ioe, final ProjectIDEServicesImplementation.UserQuestionExceptionCallback callback) {
        if (ioe instanceof UserQuestionException) {
            final UserQuestionException e = (UserQuestionException)ioe;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)e.getLocalizedMessage(), Bundle.TITLE_CannotWriteFile(), 2);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc).equals(NotifyDescriptor.OK_OPTION)) {
                        try {
                            e.confirmed();
                            callback.accepted();
                        }
                        catch (IOException x) {
                            callback.error(x);
                        }
                    } else {
                        callback.denied();
                    }
                }
            });
        }
    }

    public void notifyWarning(String message) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 2));
    }

    private static class DataObjectSource
    implements ProjectIDEServicesImplementation.FileBuiltQuerySource {
        private final DataObject data;
        private final PropertyChangeSupport support;
        private PropertyChangeListener propertyChangeListener;

        public DataObjectSource(DataObject data) {
            this.data = data;
            this.support = new PropertyChangeSupport(this);
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("modified".equals(evt.getPropertyName())) {
                        DataObjectSource.this.support.firePropertyChange("modified", evt.getOldValue(), evt.getNewValue());
                    }
                }
            };
            data.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyChangeListener, (Object)this.data));
        }

        public boolean isModified() {
            return this.data.isModified();
        }

        public boolean isValid() {
            return this.data.isValid();
        }

        public FileObject getFileObject() {
            return this.data.getPrimaryFile();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
        }
    }
}

