/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.standard;

import java.util.Arrays;
import java.util.List;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.handler.BeanCreatingHandlerProvider;

public class EndpointConnectionManager
extends ConnectionManagerSupport
implements BeanFactoryAware {
    private final Endpoint endpoint;
    private final BeanCreatingHandlerProvider<Endpoint> endpointProvider;
    private final ClientEndpointConfig.Builder configBuilder = ClientEndpointConfig.Builder.create();
    private WebSocketContainer webSocketContainer = ContainerProvider.getWebSocketContainer();
    private Session session;
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor("EndpointConnectionManager-");

    public EndpointConnectionManager(Endpoint endpoint, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        Assert.notNull((Object)endpoint, (String)"endpoint must not be null");
        this.endpointProvider = null;
        this.endpoint = endpoint;
    }

    public EndpointConnectionManager(Class<? extends Endpoint> endpointClass, String uriTemplate, Object ... uriVars) {
        super(uriTemplate, uriVars);
        Assert.notNull(endpointClass, (String)"endpointClass must not be null");
        this.endpointProvider = new BeanCreatingHandlerProvider<Endpoint>(endpointClass);
        this.endpoint = null;
    }

    public void setSupportedProtocols(String ... protocols) {
        this.configBuilder.preferredSubprotocols(Arrays.asList(protocols));
    }

    public void setExtensions(Extension ... extensions) {
        this.configBuilder.extensions(Arrays.asList(extensions));
    }

    public void setEncoders(List<Class<? extends Encoder>> encoders) {
        this.configBuilder.encoders(encoders);
    }

    public void setDecoders(List<Class<? extends Decoder>> decoders) {
        this.configBuilder.decoders(decoders);
    }

    public void setConfigurator(ClientEndpointConfig.Configurator configurator) {
        this.configBuilder.configurator(configurator);
    }

    public void setWebSocketContainer(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    public WebSocketContainer getWebSocketContainer() {
        return this.webSocketContainer;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.endpointProvider != null) {
            this.endpointProvider.setBeanFactory(beanFactory);
        }
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"TaskExecutor must not be null");
        this.taskExecutor = taskExecutor;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    protected void openConnection() {
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EndpointConnectionManager.this.logger.info((Object)("Connecting to WebSocket at " + EndpointConnectionManager.this.getUri()));
                    Endpoint endpointToUse = EndpointConnectionManager.this.endpoint != null ? EndpointConnectionManager.this.endpoint : (Endpoint)EndpointConnectionManager.this.endpointProvider.getHandler();
                    ClientEndpointConfig endpointConfig = EndpointConnectionManager.this.configBuilder.build();
                    EndpointConnectionManager.this.session = EndpointConnectionManager.this.getWebSocketContainer().connectToServer(endpointToUse, endpointConfig, EndpointConnectionManager.this.getUri());
                    EndpointConnectionManager.this.logger.info((Object)"Successfully connected");
                }
                catch (Throwable ex) {
                    EndpointConnectionManager.this.logger.error((Object)"Failed to connect", ex);
                }
            }
        });
    }

    @Override
    protected void closeConnection() throws Exception {
        try {
            if (this.isConnected()) {
                this.session.close();
            }
        }
        finally {
            this.session = null;
        }
    }

    @Override
    protected boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }
}

