/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.jsf.core.ActionListenerHandlerBase;
import com.sun.faces.facelets.util.ReflectionUtil;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.view.ActionSource2AttachedObjectHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;

public final class ActionListenerHandler
extends ActionListenerHandlerBase
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private String listenerType;
    private final TagAttribute typeAttribute = this.getAttribute("type");

    public ActionListenerHandler(TagConfig config) {
        super(config);
        if (null != this.typeAttribute) {
            String stringType = null;
            if (!this.typeAttribute.isLiteral()) {
                FacesContext context = FacesContext.getCurrentInstance();
                FaceletContext ctx = (FaceletContext)((Object)context.getAttributes().get("javax.faces.FACELET_CONTEXT"));
                stringType = (String)this.typeAttribute.getValueExpression(ctx, String.class).getValue((ELContext)ctx);
            } else {
                stringType = this.typeAttribute.getValue();
            }
            this.checkType(stringType);
            this.listenerType = stringType;
        } else {
            this.listenerType = null;
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)((Object)context.getAttributes().get("javax.faces.FACELET_CONTEXT"));
        ActionSource as = (ActionSource)((Object)parent);
        ValueExpression b = null;
        if (this.binding != null) {
            b = this.binding.getValueExpression(ctx, ActionListener.class);
        }
        LazyActionListener listener = new LazyActionListener(this.listenerType, b);
        as.addActionListener(listener);
    }

    private void checkType(String type) {
        try {
            ReflectionUtil.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new TagAttributeException(this.typeAttribute, "Couldn't qualify ActionListener", (Throwable)e);
        }
    }

    private static final class LazyActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -9202120013153262119L;
        private final String type;
        private final ValueExpression binding;

        public LazyActionListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            ActionListener instance = null;
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            if (this.binding != null) {
                instance = (ActionListener)this.binding.getValue(faces.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (ActionListener)ReflectionUtil.forName(this.type).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", e);
                }
                if (this.binding != null) {
                    this.binding.setValue(faces.getELContext(), (Object)instance);
                }
            }
            if (instance != null) {
                instance.processAction(event);
            }
        }
    }
}

