/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout.javascript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.knockout.javascript.KnockoutCodeCompletionItem;
import org.netbeans.modules.html.knockout.javascript.KnockoutContext;
import org.netbeans.modules.html.knockout.javascript.KnockoutJsElement;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.javascript2.knockout.index.KnockoutCustomElement;
import org.netbeans.modules.javascript2.knockout.index.KnockoutIndex;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class KnockoutJsCodeCompletion
implements CompletionProvider {
    private static final String MIMETYPE = "text/html/text/javascript";
    private static final String PROP_NAME = "name";
    private static final String PROP_PARAMS = "params";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletionProposal> complete(CodeCompletionContext ccContext, CompletionContext jsCompletionContext, String prefix) {
        if (!MIMETYPE.equals(ccContext.getParserResult().getSnapshot().getMimePath().getPath())) {
            return Collections.emptyList();
        }
        Document document = ccContext.getParserResult().getSnapshot().getSource().getDocument(true);
        int dOffset = ccContext.getCaretOffset();
        ((AbstractDocument)document).readLock();
        try {
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            KnockoutContext koContext = KnockoutContext.findContext(document, dOffset);
            switch (koContext) {
                case COMPONENT_EMPTY: 
                case COMPONENT_CONF_NAME: {
                    result.addAll(this.findComponentNames(ccContext));
                    break;
                }
                case COMPONENT_CONF_EMPTY: {
                    if (prefix.isEmpty() || PROP_NAME.startsWith(prefix)) {
                        result.add(new KnockoutCodeCompletionItem.KOComponentOptionItem((ElementHandle)new KnockoutJsElement(PROP_NAME, ElementKind.PROPERTY), ccContext));
                    }
                    if (!prefix.isEmpty() && !PROP_PARAMS.startsWith(prefix)) break;
                    result.add(new KnockoutCodeCompletionItem.KOComponentOptionConfigItem((ElementHandle)new KnockoutJsElement(PROP_PARAMS, ElementKind.PROPERTY), ccContext));
                    break;
                }
                case COMPONENT_CONF_PARAMS: {
                    if (!prefix.isEmpty() && !PROP_PARAMS.startsWith(prefix)) break;
                    result.add(new KnockoutCodeCompletionItem.KOComponentOptionConfigItem((ElementHandle)new KnockoutJsElement(PROP_PARAMS, ElementKind.PROPERTY), ccContext));
                    break;
                }
                case COMPONENT_CONF_PARAMS_VALUE: {
                    String componentName = this.findComponentName(document, dOffset);
                    if (componentName == null) break;
                    result.addAll(this.findComponentParameters(ccContext, componentName));
                }
            }
            ArrayList<CompletionProposal> arrayList = result;
            return arrayList;
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        return null;
    }

    private Collection<? extends CompletionProposal> findComponentNames(CodeCompletionContext ccContext) {
        FileObject fo = ccContext.getParserResult().getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<KnockoutCodeCompletionItem.KOComponentItem> result = new ArrayList<KnockoutCodeCompletionItem.KOComponentItem>();
        KnockoutIndex knockoutIndex = null;
        try {
            knockoutIndex = KnockoutIndex.get((Project)project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (knockoutIndex != null) {
            Collection customElements = knockoutIndex.getCustomElements(ccContext.getPrefix(), false);
            ArrayList<String> componentNames = new ArrayList<String>();
            if (customElements != null) {
                for (KnockoutCustomElement kce : customElements) {
                    String name = kce.getName();
                    KnockoutJsElement element = new KnockoutJsElement(name, ElementKind.CLASS);
                    if (!ccContext.getPrefix().isEmpty() && !name.startsWith(ccContext.getPrefix()) || componentNames.contains(name)) continue;
                    result.add(new KnockoutCodeCompletionItem.KOComponentItem((ElementHandle)element, ccContext));
                    componentNames.add(name);
                }
            }
        }
        return result;
    }

    private Collection<? extends CompletionProposal> findComponentParameters(CodeCompletionContext ccContext, String componentName) {
        FileObject fo = ccContext.getParserResult().getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<KnockoutCodeCompletionItem.KOComponentOptionItem> result = new ArrayList<KnockoutCodeCompletionItem.KOComponentOptionItem>();
        KnockoutIndex knockoutIndex = null;
        try {
            knockoutIndex = KnockoutIndex.get((Project)project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (knockoutIndex != null) {
            Collection parameters = knockoutIndex.getCustomElementParameters(componentName);
            for (String param : parameters) {
                if (!param.startsWith(ccContext.getPrefix())) continue;
                KnockoutJsElement element = new KnockoutJsElement(param, ElementKind.PROPERTY);
                result.add(new KnockoutCodeCompletionItem.KOComponentOptionItem((ElementHandle)element, ccContext));
            }
        }
        return result;
    }

    private String findComponentName(Document document, int offset) {
        Token jsToken;
        int diff;
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        TokenSequence jsTs = LexerUtils.getTokenSequence((TokenHierarchy)th, (int)offset, (Language)JsTokenId.javascriptLanguage(), (boolean)false);
        if (jsTs != null && ((diff = jsTs.move(offset)) == 0 && jsTs.movePrevious() || jsTs.moveNext()) && (jsToken = LexerUtils.followsToken((TokenSequence)jsTs, Arrays.asList(JsTokenId.BRACKET_LEFT_CURLY), (boolean)true, (boolean)false, (boolean)true, (TokenId[])new TokenId[]{JsTokenId.WHITESPACE, JsTokenId.STRING, JsTokenId.STRING_BEGIN, JsTokenId.STRING_END, JsTokenId.NUMBER, JsTokenId.IDENTIFIER, JsTokenId.OPERATOR_COLON, JsTokenId.OPERATOR_COMMA})) != null && jsToken.id() == JsTokenId.BRACKET_LEFT_CURLY && (jsToken = LexerUtils.followsToken((TokenSequence)jsTs, (TokenId)JsTokenId.IDENTIFIER, (boolean)true, (boolean)false, (TokenId[])new TokenId[]{JsTokenId.WHITESPACE, JsTokenId.STRING, JsTokenId.STRING_BEGIN, JsTokenId.STRING_END, JsTokenId.OPERATOR_COLON})) != null && jsToken.id() == JsTokenId.IDENTIFIER && jsToken.text().toString().equals(PROP_PARAMS) && (jsToken = LexerUtils.followsToken((TokenSequence)jsTs, (TokenId)JsTokenId.IDENTIFIER, (boolean)true, (boolean)false, (TokenId[])new TokenId[]{JsTokenId.WHITESPACE, JsTokenId.STRING, JsTokenId.STRING_BEGIN, JsTokenId.STRING_END, JsTokenId.OPERATOR_COLON, JsTokenId.OPERATOR_COMMA})) != null && jsToken.id() == JsTokenId.IDENTIFIER && jsToken.text().toString().equals(PROP_NAME)) {
            jsToken = LexerUtils.followsToken((TokenSequence)jsTs, (TokenId)JsTokenId.STRING, (boolean)false, (boolean)false, (TokenId[])new TokenId[]{JsTokenId.WHITESPACE, JsTokenId.STRING_BEGIN, JsTokenId.OPERATOR_COLON});
            return jsToken.text().toString();
        }
        return null;
    }
}

