/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.project;

import java.util.List;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileObject;

public interface NativeFileItem {
    public NativeProject getNativeProject();

    public String getAbsolutePath();

    public String getName();

    public FileObject getFileObject();

    public List<FSPath> getSystemIncludePaths();

    public List<FSPath> getUserIncludePaths();

    public List<String> getIncludeFiles();

    public List<String> getSystemMacroDefinitions();

    public List<String> getUserMacroDefinitions();

    public Language getLanguage();

    public LanguageFlavor getLanguageFlavor();

    public boolean isExcluded();

    public static enum LanguageFlavor {
        UNKNOWN(0),
        C(1),
        C89(2),
        C99(3),
        CPP(4),
        CPP11(8),
        F77(5),
        F90(6),
        F95(7),
        DEFAULT(9),
        C11(10),
        CPP14(11);

        private final int flavor;

        private LanguageFlavor(int flavor) {
            this.flavor = flavor;
        }

        public int toExternal() {
            return this.flavor;
        }

        public static LanguageFlavor fromExternal(int i) {
            switch (i) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return C;
                }
                case 2: {
                    return C89;
                }
                case 3: {
                    return C99;
                }
                case 4: {
                    return CPP;
                }
                case 5: {
                    return F77;
                }
                case 6: {
                    return F90;
                }
                case 7: {
                    return F95;
                }
                case 8: {
                    return CPP11;
                }
                case 9: {
                    return DEFAULT;
                }
                case 10: {
                    return C11;
                }
                case 11: {
                    return CPP14;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Language {
        C,
        CPP,
        FORTRAN,
        C_HEADER,
        OTHER;

    }
}

