/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import com.dd.plist.Base64;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.XMLPropertyListParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.netbeans.modules.cordova.platforms.api.WebKitDebuggingSupport;
import org.netbeans.modules.cordova.platforms.spi.MobileDebugTransport;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public abstract class IOSDebugTransport
extends MobileDebugTransport
implements TransportImplementation {
    private final RequestProcessor RP = new RequestProcessor(IOSDebugTransport.class);
    private RequestProcessor.Task socketListener;
    protected volatile boolean keepGoing = true;
    private Tabs tabs = new Tabs();
    private final Object init = new Object();
    private static final Logger LOGGER = Logger.getLogger(IOSDebugTransport.class.getName());
    private final AtomicBoolean flush = new AtomicBoolean();

    public IOSDebugTransport() {
        this.setBundleIdentifier("com.apple.mobilesafari");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach() {
        try {
            this.init();
            this.socketListener = this.RP.post(new Runnable(){

                @Override
                public void run() {
                    while (IOSDebugTransport.this.keepGoing) {
                        try {
                            IOSDebugTransport.this.process();
                        }
                        catch (SocketException e) {
                            Logger.getLogger(IOSDebugTransport.class.getName()).log(Level.FINE, "Debugging Connection Closed", e);
                            return;
                        }
                        catch (Exception exception) {
                            Exceptions.printStackTrace((Throwable)exception);
                        }
                    }
                }
            });
            this.sendInitCommands();
            return true;
        }
        catch (IllegalStateException ise) {
            Object object = this.tabs.monitor;
            synchronized (object) {
                if (!this.flush.get()) {
                    throw ise;
                }
            }
            return false;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.tabs.monitor;
        synchronized (object) {
            this.flush.set(true);
            this.tabs.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws Exception {
        JSONObject jmessage;
        NSString selector;
        NSObject object = this.readData();
        if (object == null) {
            return;
        }
        if (object instanceof NSDictionary && (selector = (NSString)((NSDictionary)object).objectForKey("__selector")) != null && selector.toString().equals("_rpc_applicationConnected:")) {
            Object object2 = this.init;
            synchronized (object2) {
                this.init.notify();
            }
        }
        if ((jmessage = this.extractResponse(object)) != null) {
            if (this.callBack == null) {
                LOGGER.info("callBack is null. Ignoring response: " + jmessage.toString());
            } else {
                this.callBack.handleResponse(new Response(jmessage));
            }
        } else if (!this.tabs.update(object)) {
            this.checkClose(object);
        }
    }

    protected abstract NSObject readData() throws Exception;

    private String getCommand(String name, boolean replace) {
        try {
            Properties props = new Properties();
            props.load(IOSDebugTransport.class.getResourceAsStream("Command.properties"));
            String cmd = props.getProperty(name).replace("$bundleId", this.getBundleIdentifier());
            if (!replace) {
                return cmd;
            }
            return cmd.replace("$tabIdentifier", this.getBundleIdentifier().equals("com.apple.mobilesafari") ? this.tabs.getActive() : "1");
        }
        catch (NoSuchElementException nse) {
            LOGGER.log(Level.INFO, nse.getMessage(), nse);
            throw new IllegalStateException(nse);
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final String createJSONCommand(JSONObject command) throws IOException {
        String json = this.translate(command.toString());
        String s = Base64.encodeBytes((byte[])json.getBytes());
        String res = this.getCommand("sendJSONCommand", true).replace("$json_encoded", s);
        return res;
    }

    protected final byte[] plistXmlToBinary(String msg) throws Exception {
        NSObject object = XMLPropertyListParser.parse((byte[])msg.getBytes());
        return BinaryPropertyListWriter.writeToArray((NSObject)object);
    }

    private void checkClose(NSObject r) throws Exception {
        if (r == null) {
            return;
        }
        if (!(r instanceof NSDictionary)) {
            return;
        }
        NSDictionary root = (NSDictionary)r;
        NSString selector = (NSString)root.objectForKey("__selector");
        if (selector != null) {
            if ("_rpc_reportConnectedApplicationList:".equals(selector.toString())) {
                NSDictionary argument = (NSDictionary)root.objectForKey("__argument");
                if (argument == null) {
                    return;
                }
                NSDictionary applications = (NSDictionary)argument.objectForKey("WIRApplicationDictionaryKey");
                if (applications.count() == 0) {
                    WebKitDebuggingSupport.getDefault().stopDebugging(false);
                }
            } else if ("rpc_applicationDisconnected:".equals(selector.toString())) {
                NSDictionary argument = (NSDictionary)root.objectForKey("__argument");
                if (argument == null) {
                    return;
                }
                NSDictionary applications = (NSDictionary)argument.objectForKey("WIRApplicationIdentifierKey");
                if (applications.objectForKey("WIRApplicationIdentifierKey").toString().equals("com.apple.mobilesafari")) {
                    WebKitDebuggingSupport.getDefault().stopDebugging(false);
                }
            }
        }
    }

    private JSONObject extractResponse(NSObject r) throws Exception {
        if (r == null) {
            return null;
        }
        if (!(r instanceof NSDictionary)) {
            return null;
        }
        NSDictionary root = (NSDictionary)r;
        NSDictionary argument = (NSDictionary)root.objectForKey("__argument");
        if (argument == null) {
            return null;
        }
        NSData data = (NSData)argument.objectForKey("WIRMessageDataKey");
        if (data == null) {
            return null;
        }
        byte[] bytes = data.bytes();
        String s = new String(bytes);
        JSONObject o = (JSONObject)JSONValue.parseWithException((String)s);
        return o;
    }

    protected static InputStream fromString(String str) {
        try {
            byte[] bytes = str.getBytes("UTF-8");
            return new ByteArrayInputStream(bytes);
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        this.keepGoing = false;
        Object object = this.init;
        synchronized (object) {
            this.init.notifyAll();
        }
        if (this.socketListener != null) {
            this.socketListener.cancel();
        }
    }

    public boolean detach() {
        this.stop();
        return true;
    }

    public final void sendCommandImpl(Command command) {
        block2: {
            try {
                this.sendCommand(command.getCommand());
            }
            catch (Exception ex) {
                boolean s = this.keepGoing;
                this.stop();
                if (!s) break block2;
                WebKitDebuggingSupport.getDefault().stopDebugging(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendInitCommands() throws Exception {
        this.sendCommand(this.getCommand("setConnectionKey", false));
        if (this.getConnectionURL() == null && "iOS Simulator".equals(this.getConnectionName())) {
            Object object = this.init;
            synchronized (object) {
                this.init.wait();
            }
        }
        this.sendCommand(this.getCommand("connectToApp", false));
        this.sendCommand(this.getCommand("setSenderKey", true));
    }

    protected abstract void sendCommand(String var1) throws Exception;

    protected abstract void sendCommand(JSONObject var1) throws Exception;

    protected abstract void init() throws Exception;

    private class Tabs {
        private HashMap<String, TabDescriptor> map = new HashMap();
        private Object monitor = new Object();
        private boolean inited = false;
        private String lastTab = null;

        private Tabs() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean update(NSObject r) throws Exception {
            if (r == null) {
                return false;
            }
            if (!(r instanceof NSDictionary)) {
                return false;
            }
            NSDictionary root = (NSDictionary)r;
            NSDictionary argument = (NSDictionary)root.objectForKey("__argument");
            if (argument == null) {
                return false;
            }
            NSDictionary listing = (NSDictionary)argument.objectForKey("WIRListingKey");
            if (listing == null) {
                return false;
            }
            this.map.clear();
            for (String s : listing.allKeys()) {
                NSDictionary o = (NSDictionary)listing.objectForKey(s);
                NSObject identifier = o.objectForKey("WIRPageIdentifierKey");
                NSObject url = o.objectForKey("WIRURLKey");
                NSObject title = o.objectForKey("WIRTitleKey");
                if (IOSDebugTransport.this.getConnectionURL() == null) {
                    IOSDebugTransport.this.setBaseUrl(url.toString());
                }
                this.map.put(s, new TabDescriptor(url.toString(), title.toString(), identifier.toString()));
            }
            Object object = this.monitor;
            synchronized (object) {
                this.inited = true;
                this.monitor.notifyAll();
            }
            if (this.getTabForUrl() == null) {
                WebKitDebuggingSupport.getDefault().stopDebugging(false);
            }
            return true;
        }

        public TabDescriptor get(String key) {
            return this.map.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getActive() throws InterruptedException {
            Object object = this.monitor;
            synchronized (object) {
                if (!this.inited) {
                    this.monitor.wait(120000L);
                }
            }
            String tabForUrl = this.getTabForUrl();
            if (tabForUrl != null) {
                return tabForUrl;
            }
            return this.map.entrySet().iterator().next().getKey();
        }

        private String getTabForUrl() {
            for (Map.Entry<String, TabDescriptor> entry : this.map.entrySet()) {
                String urlFromBrowser = entry.getValue().getUrl();
                if (urlFromBrowser.startsWith("file:/")) {
                    this.lastTab = "1";
                    return "1";
                }
                int hash = urlFromBrowser.indexOf("#");
                if (hash != -1) {
                    urlFromBrowser = urlFromBrowser.substring(0, hash);
                }
                if (urlFromBrowser.endsWith("/")) {
                    urlFromBrowser = urlFromBrowser.substring(0, urlFromBrowser.length() - 1);
                }
                if (!IOSDebugTransport.this.getConnectionURL().toString().equals(urlFromBrowser.replaceAll("file:///", "file:/"))) continue;
                this.lastTab = entry.getKey();
                return this.lastTab;
            }
            for (Map.Entry<String, TabDescriptor> entry : this.map.entrySet()) {
                if (!entry.getValue().getIdentifier().equals(this.lastTab)) continue;
                return this.lastTab;
            }
            return null;
        }

        private class TabDescriptor {
            String url;
            String title;
            String identifier;

            public TabDescriptor(String url, String title, String identifier) {
                this.url = url;
                this.title = title;
                this.identifier = identifier;
            }

            public String getUrl() {
                return this.url;
            }

            public String getTitle() {
                return this.title;
            }

            public String getIdentifier() {
                return this.identifier;
            }

            public String toString() {
                return "TabDescriptor{url=" + this.url + ", title=" + this.title + ", identifier=" + this.identifier + '}';
            }
        }
    }
}

