/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import java.util.logging.Logger;

public class WebInspectorJNIBinding {
    private static final Logger LOG = Logger.getLogger(WebInspectorJNIBinding.class.getName());
    private boolean started = false;
    private final Object readLock;
    private final Object writeLock = new Object();
    private static WebInspectorJNIBinding instance;

    private native void nstart();

    private native void nstop();

    private native String nreceiveMessage(Integer var1);

    private native void nsendMessage(String var1);

    private native boolean nisDeviceConnected();

    private WebInspectorJNIBinding() {
        this.readLock = new Object();
        System.loadLibrary("iDeviceNativeBinding");
    }

    public static synchronized WebInspectorJNIBinding getDefault() {
        if (instance == null) {
            instance = new WebInspectorJNIBinding();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.readLock;
            synchronized (object2) {
                if (!this.started) {
                    this.nstart();
                    this.started = true;
                } else {
                    LOG.info("WebKit Debugging Service already started");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.readLock;
            synchronized (object2) {
                if (this.started) {
                    this.nstop();
                    this.started = false;
                } else {
                    LOG.info("WebKit Debugging Service not started");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveMessage() {
        Object object = this.readLock;
        synchronized (object) {
            if (!this.started) {
                LOG.info("WebKit Debugging Service not started");
                return null;
            }
            String receiveMessage = this.nreceiveMessage(100);
            return receiveMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String message) {
        Object object = this.writeLock;
        synchronized (object) {
            if (!this.started) {
                LOG.info("WebKit Debugging Service not started");
                return;
            }
            this.nsendMessage(message);
        }
    }

    public boolean isDeviceConnected() {
        return this.nisDeviceConnected();
    }
}

