/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.stackanalyzer;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class StackLineAnalyser {
    private static final RequestProcessor RP = new RequestProcessor(StackLineAnalyser.class);
    private static final String IDENTIFIER = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern LINE_PATTERN = Pattern.compile("at\\s((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)\\.)?(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\.(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*|\\<init\\>|\\<clinit\\>)\\(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.java\\:([0-9]*)\\)");

    StackLineAnalyser() {
    }

    static boolean matches(String line) {
        Matcher matcher = LINE_PATTERN.matcher(line);
        return matcher.find();
    }

    static Link analyse(String line) {
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (matcher.find()) {
            int lineNumber = -1;
            try {
                lineNumber = Integer.parseInt(matcher.group(6));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            if (matcher.group(1) == null) {
                return new Link(matcher.group(4).split("\\$")[0], lineNumber, matcher.start(4), matcher.end(6) + 1);
            }
            return new Link(matcher.group(1) + matcher.group(4).split("\\$")[0], lineNumber, matcher.start(1), matcher.end(6) + 1);
        }
        return null;
    }

    @CheckForNull
    private static DataObject findDataObject(@NullAllowed FileObject file) {
        try {
            return file == null ? null : DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException donf) {
            return null;
        }
    }

    static class Link {
        private String className;
        private int lineNumber;
        private int startOffset;
        private int endOffset;

        private Link(String className, int lineNumber, int startOffset, int endOffset) {
            this.className = className;
            this.lineNumber = lineNumber;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.endOffset;
        }

        void show() {
            final String resource = this.className.replace('.', '/') + ".java";
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(StackLineAnalyser.class, (String)"TXT_OpeningSource", (Object)resource));
            handle.start();
            RP.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataObject dataObject;
                    DataObject dobj = null;
                    try {
                        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])GlobalPathRegistry.getDefault().getSourceRoots().toArray(new FileObject[0]));
                        dataObject = dobj = StackLineAnalyser.findDataObject(classPath.findResource(resource));
                    }
                    catch (Throwable throwable) {
                        DataObject dataObject2 = dobj;
                        Mutex.EVENT.readAccess(new Runnable(dataObject2){
                            final /* synthetic */ DataObject val$dataObject;
                            {
                                this.val$dataObject = dataObject;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            @Override
                            public void run() {
                                block12: {
                                    block11: {
                                        block13: {
                                            block10: {
                                                block9: {
                                                    if (this.val$dataObject != null) break block9;
                                                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StackLineAnalyser.class, (String)"AnalyzeStackTopComponent.sourceNotFound", (Object[])new Object[]{resource}));
                                                    handle.finish();
                                                    return;
                                                }
                                                editorCookie = (EditorCookie)this.val$dataObject.getCookie(EditorCookie.class);
                                                lineCookie = (LineCookie)this.val$dataObject.getCookie(LineCookie.class);
                                                if (editorCookie == null || lineCookie == null || Link.access$200(Link.this) == -1 || (doc = editorCookie.openDocument()) == null || Link.access$200(Link.this) == -1) ** GOTO lbl24
                                                l = lineCookie.getLineSet().getCurrent(Link.access$200(Link.this) - 1);
                                                if (l == null) break block10;
                                                l.show(2);
                                                handle.finish();
                                                return;
                                            }
                                            break block13;
                                            {
                                                catch (IndexOutOfBoundsException oob) {
                                                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StackLineAnalyser.class, (String)"AnalyzeStackTopComponent.lineNotFound", (Object[])new Object[]{Link.access$200(Link.this)}));
                                                }
                                            }
                                        }
                                        if ((openCookie = (OpenCookie)this.val$dataObject.getCookie(OpenCookie.class)) == null) break block11;
                                        openCookie.open();
                                        handle.finish();
                                        return;
                                    }
                                    try {
                                        break block12;
                                        catch (IOException e) {
                                            Exceptions.printStackTrace((Throwable)e);
                                        }
                                    }
                                    finally {
                                        handle.finish();
                                    }
                                }
                            }
                        });
                        throw throwable;
                    }
                    Mutex.EVENT.readAccess(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }

        static /* synthetic */ int access$200(Link x0) {
            return x0.lineNumber;
        }
    }
}

