/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.utils;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CheckoutIndex {
    private final Repository repository;
    private final DirCache cache;
    private final File[] roots;
    private final FileListener listener;
    private final ProgressMonitor monitor;
    private final boolean checkContent;
    private final boolean recursively;
    private static final Logger LOG = Logger.getLogger(CheckoutIndex.class.getName());

    public CheckoutIndex(Repository repository, DirCache cache, File[] roots, boolean recursively, FileListener listener, ProgressMonitor monitor, boolean checkContent) {
        this.repository = repository;
        this.cache = cache;
        this.roots = roots;
        this.listener = listener;
        this.monitor = monitor;
        this.checkContent = checkContent;
        this.recursively = recursively;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout() throws IOException, GitException {
        TreeWalk treeWalk = new TreeWalk(this.repository);
        List<String> relativePaths = Utils.getRelativePaths(this.repository.getWorkTree(), this.roots);
        if (!relativePaths.isEmpty()) {
            treeWalk.setFilter(PathFilterGroup.createFromStrings(relativePaths));
        }
        treeWalk.setRecursive(true);
        treeWalk.reset();
        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(this.cache));
        treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(this.repository));
        String lastAddedPath = null;
        ObjectReader od = this.repository.newObjectReader();
        try {
            while (treeWalk.next() && !this.monitor.isCanceled()) {
                File path = new File(this.repository.getWorkTree(), treeWalk.getPathString());
                if (treeWalk.getPathString().equals(lastAddedPath)) continue;
                lastAddedPath = treeWalk.getPathString();
                DirCacheIterator dit = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
                FileTreeIterator fit = (FileTreeIterator)treeWalk.getTree(1, FileTreeIterator.class);
                if (dit == null || !this.recursively && !this.directChild(this.roots, this.repository.getWorkTree(), path) || fit != null && !fit.isModified(dit.getDirCacheEntry(), this.checkContent, od)) continue;
                this.listener.notifyFile(path, treeWalk.getPathString());
                this.checkoutEntry(this.repository, path, dit.getDirCacheEntry(), od);
            }
        }
        finally {
            od.release();
            treeWalk.release();
        }
    }

    public void checkoutEntry(Repository repository, File file, DirCacheEntry e, ObjectReader od) throws IOException, GitException {
        if (!this.ensureParentFolderExists(file.getParentFile())) {
            return;
        }
        boolean exists = file.exists();
        if (exists && e.getFileMode() == FileMode.SYMLINK) {
            this.monitor.notifyWarning(MessageFormat.format(Utils.getBundle(CheckoutIndex.class).getString("MSG_Warning_SymLink"), file.getAbsolutePath()));
            return;
        }
        if (Utils.isFromNested(e.getFileMode().getBits())) {
            if (!exists) {
                file.mkdirs();
            }
        } else {
            if (exists && file.isDirectory()) {
                this.monitor.notifyWarning(MessageFormat.format(Utils.getBundle(CheckoutIndex.class).getString("MSG_Warning_ReplacingDirectory"), file.getAbsolutePath()));
                Utils.deleteRecursively(file);
            }
            file.createNewFile();
            if (file.isFile()) {
                DirCacheCheckout.checkoutEntry((Repository)repository, (File)file, (DirCacheEntry)e, (ObjectReader)od);
            } else {
                this.monitor.notifyError(MessageFormat.format(Utils.getBundle(CheckoutIndex.class).getString("MSG_Warning_CannotCreateFile"), file.getAbsolutePath()));
            }
        }
    }

    private boolean ensureParentFolderExists(File parentFolder) {
        File predecessor = parentFolder;
        while (!predecessor.exists()) {
            predecessor = predecessor.getParentFile();
        }
        if (predecessor.isFile()) {
            if (!predecessor.delete()) {
                this.monitor.notifyError(MessageFormat.format(Utils.getBundle(CheckoutIndex.class).getString("MSG_Warning_CannotCreateFile"), predecessor.getAbsolutePath()));
                return false;
            }
            this.monitor.notifyWarning(MessageFormat.format(Utils.getBundle(CheckoutIndex.class).getString("MSG_Warning_ReplacingFile"), predecessor.getAbsolutePath()));
        }
        return parentFolder.mkdirs() || parentFolder.exists();
    }

    private boolean directChild(File[] roots, File workTree, File path) {
        if (roots.length == 0) {
            roots = new File[]{workTree};
        }
        for (File parent : roots) {
            if (!parent.equals(path) && !parent.equals(path.getParentFile())) continue;
            return true;
        }
        return false;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "").toLowerCase().contains("windows");
    }
}

