/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.GlassFishJvmMode;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassFishState;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.GlassFishStatus;
import org.netbeans.modules.glassfish.tooling.GlassFishStatusListener;
import org.netbeans.modules.glassfish.tooling.TaskEvent;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.TaskStateListener;
import org.netbeans.modules.glassfish.tooling.admin.CommandGetProperty;
import org.netbeans.modules.glassfish.tooling.admin.CommandRestartDAS;
import org.netbeans.modules.glassfish.tooling.admin.CommandSetProperty;
import org.netbeans.modules.glassfish.tooling.admin.CommandStopDAS;
import org.netbeans.modules.glassfish.tooling.admin.ResultMap;
import org.netbeans.modules.glassfish.tooling.admin.ResultString;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServerStatus;
import org.netbeans.modules.glassfish.tooling.utils.NetUtils;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;
import org.openide.util.NbBundle;

public class RestartTask
extends BasicTask<TaskState> {
    private static final Logger LOGGER = GlassFishLogger.get(RestartTask.class);
    private static final int RESTART_DELAY = 5000;
    private final CommonServerSupport support;

    public RestartTask(CommonServerSupport support, TaskStateListener ... stateListener) {
        super(support.getInstance(), stateListener);
        this.support = support;
    }

    private BasicTask.StateChange localOfflineStart() {
        Future<TaskState> startTask = this.support.startServer(null, GlassfishModule.ServerState.RUNNING);
        TaskState startResult = TaskState.FAILED;
        try {
            startResult = startTask.get(300000L, TIMEUNIT);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, ex.getLocalizedMessage(), ex);
        }
        if (startResult == TaskState.FAILED) {
            return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.CMD_FAILED, "RestartTask.localOfflineStart.failed", this.instanceName);
        }
        return new BasicTask.StateChange(this, TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "RestartTask.localOfflineStart.completed", this.instanceName);
    }

    private BasicTask.StateChange remoteOfflineStart() {
        return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "RestartTask.remoteOfflineStart.failed", this.instanceName);
    }

    private BasicTask.StateChange localShutdownStart() {
        BasicTask.StateChange stateChange = this.waitShutDown();
        if (stateChange != null) {
            return stateChange;
        }
        GlassFishServerStatus status = GlassFishState.getStatus(this.instance);
        switch (status.getStatus()) {
            case UNKNOWN: 
            case ONLINE: 
            case SHUTDOWN: 
            case STARTUP: {
                return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "RestartTask.localShutdownStart.notOffline", this.instanceName);
            }
        }
        if (!ServerUtils.isAdminPortListening((GlassFishServer)this.instance, (int)2000)) {
            return this.localOfflineStart();
        }
        return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "RestartTask.localShutdownStart.portOccupied", this.instanceName);
    }

    private BasicTask.StateChange remoteShutdownStart() {
        return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "RestartTask.remoteShutdownStart.failed", this.instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicTask.StateChange startupWait() {
        BasicTask.StartStateListener listener = this.prepareStartMonitoring(true);
        if (listener == null) {
            return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "RestartTask.startupWait.listenerError", this.instanceName);
        }
        long start = System.currentTimeMillis();
        try {
            BasicTask.StartStateListener startStateListener = listener;
            synchronized (startStateListener) {
                while (!listener.isWakeUp() && System.currentTimeMillis() - start < 300000L) {
                    listener.wait(System.currentTimeMillis() - start);
                }
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(RestartTask.class, (String)"RestartTask.startupWait.interruptedException", (Object[])new String[]{this.instance.getName(), ie.getLocalizedMessage()}));
        }
        finally {
            GlassFishStatus.removeListener((GlassFishServer)this.instance, (GlassFishStatusListener)listener);
        }
        if (GlassFishState.isOnline(this.instance)) {
            return new BasicTask.StateChange(this, TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "RestartTask.startupWait.completed", this.instanceName);
        }
        return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "RestartTask.startupWait.failed", this.instanceName);
    }

    private BasicTask.StateChange localRestart() {
        if (GlassFishStatus.shutdown((GlassFishServer)this.instance)) {
            ResultString result = CommandStopDAS.stopDAS((GlassFishServer)this.instance);
            if (result.getState() == TaskState.COMPLETED) {
                return this.localShutdownStart();
            }
            return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.CMD_FAILED, "RestartTask.localRestart.cmdFailed", this.instanceName);
        }
        return new BasicTask.StateChange(this, TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "RestartTask.localRestart.failed", this.instanceName);
    }

    private boolean updateDebugOptions(int debugPort) {
        boolean updateResult = false;
        try {
            Map values;
            ResultMap result = CommandGetProperty.getProperties((GlassFishServer)this.instance, (String)"configs.config.server-config.java-config.debug-options");
            if (result.getState() == TaskState.COMPLETED && (values = result.getValue()) != null && !values.isEmpty()) {
                CommandFactory commandFactory = this.instance.getInstanceProvider().getCommandFactory();
                String oldValue = (String)values.get("configs.config.server-config.java-config.debug-options");
                CommandSetProperty setCmd = commandFactory.getSetPropertyCommand("configs.config.server-config.java-config.debug-options", oldValue.replace("transport=dt_shmem", "transport=dt_socket").replace("address=[^,]+", "address=" + debugPort));
                try {
                    CommandSetProperty.setProperty((GlassFishServer)this.instance, (CommandSetProperty)setCmd);
                    updateResult = true;
                }
                catch (GlassFishIdeException gfie) {
                    LOGGER.log(Level.INFO, debugPort + "", gfie);
                }
            }
        }
        catch (GlassFishIdeException gfie) {
            LOGGER.log(Level.INFO, "Could not retrieve property from server.", gfie);
        }
        return updateResult;
    }

    private boolean vaitForDebugPort(String host, int port) {
        boolean result = NetUtils.isPortListeningRemote((String)host, (int)port, (int)2000);
        if (!result) {
            long tmStart = System.currentTimeMillis();
            while (!result && System.currentTimeMillis() - tmStart < 120000L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                result = NetUtils.isPortListeningRemote((String)host, (int)port, (int)2000);
            }
        }
        return result;
    }

    private BasicTask.StateChange remoteRestart() {
        boolean debugMode = this.instance.getJvmMode() == GlassFishJvmMode.DEBUG;
        boolean debugPortActive = true;
        int debugPort = -1;
        if (debugMode) {
            debugPort = this.instance.getDebugPort();
            debugMode = this.updateDebugOptions(debugPort);
            debugPortActive = NetUtils.isPortListeningRemote((String)this.instance.getHost(), (int)debugPort, (int)2000);
        }
        ResultString result = CommandRestartDAS.restartDAS((GlassFishServer)this.instance, (boolean)debugMode);
        LogViewMgr.removeLog(this.instance);
        LogViewMgr logger = LogViewMgr.getInstance(this.instance.getProperty("url"));
        logger.stopReaders();
        switch (result.getState()) {
            case COMPLETED: {
                if (debugMode && !debugPortActive) {
                    this.vaitForDebugPort(this.instance.getHost(), debugPort);
                    this.waitStartUp(true, false);
                }
                return new BasicTask.StateChange(this, result.getState(), TaskEvent.CMD_COMPLETED, "RestartTask.remoteRestart.completed", this.instanceName);
            }
        }
        return new BasicTask.StateChange(this, result.getState(), TaskEvent.CMD_COMPLETED, "RestartTask.remoteRestart.failed", this.instanceName, result.getValue());
    }

    @Override
    public TaskState call() {
        GlassFishStatus state = GlassFishState.getStatus(this.instance).getStatus();
        switch (state) {
            case UNKNOWN: {
                return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "RestartTask.call.unknownState", this.instanceName);
            }
            case OFFLINE: {
                BasicTask.StateChange change = this.instance.isRemote() ? this.remoteOfflineStart() : this.localOfflineStart();
                return change.fireOperationStateChanged();
            }
            case STARTUP: {
                BasicTask.StateChange change = this.startupWait();
                return change.fireOperationStateChanged();
            }
            case ONLINE: {
                BasicTask.StateChange change = this.instance.isRemote() ? this.remoteRestart() : this.localRestart();
                return change.fireOperationStateChanged();
            }
            case SHUTDOWN: {
                BasicTask.StateChange change = this.instance.isRemote() ? this.remoteShutdownStart() : this.localShutdownStart();
                return change.fireOperationStateChanged();
            }
        }
        return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "RestartTask.call.unknownState", this.instanceName);
    }

    public TaskState call2() {
        Logger.getLogger("glassfish").log(Level.FINEST, "RestartTask.call() called on thread \"{0}\"", Thread.currentThread().getName());
        this.fireOperationStateChanged(TaskState.RUNNING, TaskEvent.CMD_RUNNING, "MSG_RESTART_SERVER_IN_PROGRESS", this.instanceName);
        GlassFishStatus state = GlassFishState.getStatus(this.instance).getStatus();
        if (state == GlassFishStatus.STARTUP) {
            GlassFishStatus currentState = state;
            int steps = 1200;
            int count = 0;
            while (currentState == GlassFishStatus.STARTUP && count++ < steps) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger("glassfish").log(Level.FINER, ex.getLocalizedMessage(), ex);
                }
                currentState = GlassFishState.getStatus(this.instance).getStatus();
            }
            if (!GlassFishState.isOnline(this.instance)) {
                return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_RESTART_SERVER_FAILED_WONT_START", this.instanceName);
            }
        } else {
            String o;
            boolean postStopDelay = true;
            if (state == GlassFishStatus.ONLINE) {
                Future<TaskState> stopTask = this.support.stopServer(null);
                TaskState stopResult = TaskState.FAILED;
                try {
                    stopResult = stopTask.get(180000L, TIMEUNIT);
                }
                catch (Exception ex) {
                    Logger.getLogger("glassfish").log(Level.FINER, ex.getLocalizedMessage(), ex);
                }
                if (stopResult == TaskState.FAILED) {
                    return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_RESTART_SERVER_FAILED_WONT_STOP", this.instanceName);
                }
            } else if (state == GlassFishStatus.SHUTDOWN) {
                GlassFishStatus currentState = state;
                int steps = 720;
                int count = 0;
                while (currentState == GlassFishStatus.SHUTDOWN && count++ < steps) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger("glassfish").log(Level.FINER, ex.getLocalizedMessage(), ex);
                    }
                    currentState = GlassFishState.getStatus(this.instance).getStatus();
                }
                if (!GlassFishState.isOffline(this.instance)) {
                    return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_RESTART_SERVER_FAILED_WONT_STOP", this.instanceName);
                }
            } else {
                postStopDelay = false;
            }
            if (postStopDelay) {
                this.support.setServerState(GlassfishModule.ServerState.STARTING);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (GlassfishModule.PROFILE_MODE.equals(o = this.support.setEnvironmentProperty("jvmMode", GlassfishModule.NORMAL_MODE, false))) {
                this.support.setEnvironmentProperty("jvmMode", GlassfishModule.NORMAL_MODE, false);
            }
            Future<TaskState> startTask = this.support.startServer(null, GlassfishModule.ServerState.RUNNING);
            TaskState startResult = TaskState.FAILED;
            try {
                startResult = startTask.get(300000L, TIMEUNIT);
            }
            catch (Exception ex) {
                Logger.getLogger("glassfish").log(Level.FINER, ex.getLocalizedMessage(), ex);
            }
            if (startResult == TaskState.FAILED) {
                return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_RESTART_SERVER_FAILED_WONT_START", this.instanceName);
            }
            if (!this.support.isRemote() && this.support.getServerState() != GlassfishModule.ServerState.RUNNING) {
                return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_RESTART_SERVER_FAILED_REASON_UNKNOWN", this.instanceName);
            }
        }
        return this.fireOperationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "MSG_SERVER_RESTARTED", this.instanceName);
    }
}

