/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.actions;

import java.awt.event.ActionEvent;
import org.netbeans.modules.glassfish.common.GlassFishState;
import org.netbeans.modules.glassfish.common.actions.AbstractOutputAction;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RestartAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(RestartAction.class, (String)"CTL_RestartAction");
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            GlassfishModule commonSupport = (GlassfishModule)node.getLookup().lookup(GlassfishModule.class);
            if (commonSupport == null) continue;
            if (commonSupport.isRemote() && commonSupport.supportsRestartInDebug()) {
                commonSupport.setEnvironmentProperty("jvmMode", GlassfishModule.NORMAL_MODE, true);
            }
            RestartAction.performActionImpl(commonSupport);
        }
    }

    private static void performActionImpl(GlassfishModule commonSupport) {
        commonSupport.restartServer(null);
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        if (activatedNodes != null && activatedNodes.length > 0) {
            Node node;
            GlassfishModule commonSupport;
            Node[] arr$ = activatedNodes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (result = (commonSupport = (GlassfishModule)(node = arr$[i$]).getLookup().lookup(GlassfishModule.class)) != null ? RestartAction.enableImpl(commonSupport) : false); ++i$) {
            }
        }
        return result;
    }

    private static boolean enableImpl(GlassfishModule commonSupport) {
        return GlassFishState.isOnline(commonSupport.getInstance());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static class OutputAction
    extends AbstractOutputAction {
        private static final String ICON = "org/netbeans/modules/glassfish/common/resources/restart.png";

        public OutputAction(GlassfishModule commonSupport) {
            super(commonSupport, NbBundle.getMessage(RestartAction.class, (String)"LBL_RestartOutput"), NbBundle.getMessage(RestartAction.class, (String)"LBL_RestartOutputDesc"), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RestartAction.performActionImpl(this.commonSupport);
        }

        @Override
        public boolean isEnabled() {
            return RestartAction.enableImpl(this.commonSupport);
        }
    }
}

