/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;
import org.netbeans.modules.profiler.snaptracer.impl.swing.VerticalLayout;
import sun.swing.plaf.synth.SynthIcon;

public final class CategoryList
extends JPanel {
    private static final Icon expandedIcon;
    private static final Icon collapsedIcon;

    public CategoryList(String[] categories, String[] tooltips, boolean[] initialStates, Component[][] items) {
        this.setOpaque(false);
        this.setLayout(new VerticalLayout(false));
        int captionsCount = categories.length;
        for (int i = 0; i < captionsCount; ++i) {
            this.add(new Category(categories[i], tooltips[i], initialStates[i], items[i], i, captionsCount));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components;
        for (Component c : components = this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    private static Icon centeredIcon(final Icon icon, final int width, final int height) {
        Object centeredIcon = null;
        try {
            if (icon instanceof SynthIcon) {
                centeredIcon = new SynthIcon(){
                    private final SynthIcon sicon;
                    {
                        this.sicon = (SynthIcon)icon;
                    }

                    public void paintIcon(SynthContext sc, Graphics grphcs, int x, int y, int w, int h) {
                        try {
                            int dw = SynthIcon.getIconWidth((Icon)this.sicon, (SynthContext)sc);
                            int dh = SynthIcon.getIconHeight((Icon)this.sicon, (SynthContext)sc);
                            int dx = width - dw;
                            int dy = height - dh;
                            SynthIcon.paintIcon((Icon)this.sicon, (SynthContext)sc, (Graphics)grphcs, (int)(x + dx / 2), (int)(y + dy / 2), (int)(dw + 2), (int)(dh + 2));
                        }
                        catch (Throwable t) {
                            try {
                                this.sicon.paintIcon(sc, grphcs, x, y, w, h);
                            }
                            catch (Throwable th) {
                                // empty catch block
                            }
                        }
                    }

                    public int getIconWidth(SynthContext sc) {
                        return width;
                    }

                    public int getIconHeight(SynthContext sc) {
                        return height;
                    }
                };
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (centeredIcon == null) {
            centeredIcon = new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    int dx = width - icon.getIconWidth();
                    int dy = height - icon.getIconHeight();
                    icon.paintIcon(c, g, x + dx / 2, y + dy / 2);
                }

                @Override
                public int getIconWidth() {
                    return width;
                }

                @Override
                public int getIconHeight() {
                    return height;
                }
            };
        }
        return centeredIcon;
    }

    static {
        Icon expanded = UIManager.getIcon("Tree.expandedIcon");
        Icon collapsed = UIManager.getIcon("Tree.collapsedIcon");
        int width = Math.max(expanded.getIconWidth(), collapsed.getIconWidth());
        int height = Math.max(expanded.getIconHeight(), collapsed.getIconHeight());
        expandedIcon = CategoryList.centeredIcon(expanded, width, height);
        collapsedIcon = CategoryList.centeredIcon(collapsed, width, height);
    }

    private static class Category
    extends JPanel {
        private boolean expanded;
        private final JLabel headerLabel;
        private final JPanel itemsContainer;

        public Category(String caption, String tooltip, boolean initialState, Component[] items, int index, int categoriesCount) {
            this.expanded = initialState;
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.headerLabel = new JLabel(caption);
            this.headerLabel.setForeground(new JMenuItem().getForeground());
            this.headerLabel.setToolTipText(tooltip);
            this.headerLabel.setIconTextGap(5);
            this.headerLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.headerLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.headerLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Category.this.expanded = !Category.this.expanded;
                    Category.this.updateState();
                }
            });
            JMenuBar menuBar = new JMenuBar();
            menuBar.setBorder(BorderFactory.createEmptyBorder());
            menuBar.setBorderPainted(false);
            menuBar.setLayout(new BorderLayout());
            menuBar.add((Component)this.headerLabel, "Center");
            this.itemsContainer = new JPanel(){

                @Override
                public void setEnabled(boolean enabled) {
                    Component[] components;
                    for (Component c : components = this.getComponents()) {
                        c.setEnabled(enabled);
                    }
                }
            };
            this.itemsContainer.setOpaque(false);
            this.itemsContainer.setLayout(new VerticalLayout(false));
            for (int i = 0; i < items.length; ++i) {
                this.itemsContainer.add(items[i]);
            }
            this.add((Component)menuBar, "North");
            this.add((Component)this.itemsContainer, "Center");
            this.updateState();
        }

        @Override
        public void setEnabled(boolean enabled) {
            Component[] components;
            for (Component c : components = this.getComponents()) {
                if (c instanceof JMenuBar) continue;
                c.setEnabled(enabled);
            }
        }

        private void updateState() {
            this.headerLabel.setIcon(this.expanded ? expandedIcon : collapsedIcon);
            this.itemsContainer.setVisible(this.expanded);
        }
    }
}

