/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator;

import java.io.IOException;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.ApplicationManagedResourceTransactionInjectableInWeb;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.ApplicationManagedResourceTransactionNonInjectableInWeb;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.ContainerManagedJTAInjectableInEJB;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.ContainerManagedJTANonInjectableInWeb;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.EntityManagerGenerationStrategy;
import org.netbeans.modules.j2ee.persistence.spi.entitymanagergenerator.EntityManagerGenerationStrategyResolver;
import org.netbeans.modules.javaee.injection.api.InjectionTargetQuery;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class EntityManagerGenerationStrategyResolverFactory {
    private EntityManagerGenerationStrategyResolverFactory() {
    }

    public static EntityManagerGenerationStrategyResolver createInstance(Project project) {
        return new EMGenStrategyResolverImpl(project);
    }

    private static class EMGenStrategyResolverImpl
    implements EntityManagerGenerationStrategyResolver {
        private Project project;

        private EMGenStrategyResolverImpl(Project project) {
            this.project = project;
        }

        @Override
        public Class<? extends EntityManagerGenerationStrategy> resolveStrategy(FileObject target) {
            PersistenceUnit persistenceUnit = this.getPersistenceUnit(target);
            String jtaDataSource = persistenceUnit.getJtaDataSource();
            String transactionType = persistenceUnit.getTransactionType();
            boolean isInjectionTarget = this.isInjectionTarget(target);
            boolean isJTA = transactionType == null || transactionType.equals("JTA");
            boolean isContainerManaged = jtaDataSource != null && !jtaDataSource.equals("") && isJTA;
            ContainerClassPathModifier modifier = (ContainerClassPathModifier)this.project.getLookup().lookup(ContainerClassPathModifier.class);
            if (modifier != null) {
                modifier.extendClasspath(target, new String[]{"annotation", "persistence", "transaction"});
            }
            if (isContainerManaged) {
                if (isInjectionTarget) {
                    return ContainerManagedJTAInjectableInEJB.class;
                }
                return ContainerManagedJTANonInjectableInWeb.class;
            }
            if (!isJTA) {
                if (isInjectionTarget) {
                    return ApplicationManagedResourceTransactionInjectableInWeb.class;
                }
                return ApplicationManagedResourceTransactionNonInjectableInWeb.class;
            }
            return null;
        }

        private boolean isInjectionTarget(FileObject target) {
            final boolean[] result = new boolean[1];
            JavaSource source = JavaSource.forFileObject((FileObject)target);
            if (source == null) {
                return false;
            }
            try {
                source.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)parameter);
                        result[0] = InjectionTargetQuery.isInjectionTarget((CompilationController)parameter, (TypeElement)typeElement);
                    }
                });
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            return result[0];
        }

        private PersistenceUnit getPersistenceUnit(FileObject target) {
            PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)target);
            if (persistenceScope == null) {
                return null;
            }
            try {
                Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceScope.getPersistenceXml());
                if (persistence != null) {
                    return persistence.getPersistenceUnit(0);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
    }
}

