/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Attributes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Basic;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Embedded;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EmbeddedId;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Id;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.ManyToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.ManyToOne;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToOne;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedTypeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Mapping;
import org.netbeans.modules.j2ee.persistence.spi.jpql.support.JPAAttribute;

public abstract class ManagedType
implements IManagedType {
    private final PersistentObject element;
    private final IManagedTypeProvider provider;
    private Map<String, IMapping> mappings;
    private IType type;

    public ManagedType(PersistentObject element, IManagedTypeProvider provider) {
        this.element = element;
        this.provider = provider;
    }

    public IMapping getMappingNamed(String val) {
        if (this.mappings == null) {
            this.mappings = this.initMappings();
        }
        return this.mappings.get(val);
    }

    public IManagedTypeProvider getProvider() {
        return this.provider;
    }

    public IType getType() {
        if (this.type == null && ((ManagedTypeProvider)this.provider).isValid()) {
            this.type = this.provider.getTypeRepository().getType(this.element.getTypeElement().getQualifiedName().toString());
        }
        return this.type;
    }

    public Iterable<IMapping> mappings() {
        if (this.mappings == null) {
            this.mappings = this.initMappings();
        }
        return Collections.unmodifiableCollection(this.mappings.values());
    }

    public int compareTo(IManagedType o) {
        return this.getType().getName().compareTo(o.getType().getName());
    }

    PersistentObject getPersistentObject() {
        return this.element;
    }

    Map<String, IMapping> initMappings() {
        this.mappings = new HashMap<String, IMapping>();
        Attributes atrs = this.getAttributes();
        if (atrs != null) {
            Id[] ids;
            Basic[] bs;
            OneToMany[] oms;
            OneToOne[] oos;
            ManyToOne[] mos;
            ManyToMany[] mms = atrs.getManyToMany();
            if (mms != null) {
                for (ManyToMany mm1 : mms) {
                    this.mappings.put(mm1.getName(), new Mapping(this, new JPAAttribute(this.element, mm1)));
                }
            }
            if ((mos = atrs.getManyToOne()) != null) {
                for (ManyToOne mo1 : mos) {
                    this.mappings.put(mo1.getName(), new Mapping(this, new JPAAttribute(this.element, mo1)));
                }
            }
            if ((oos = atrs.getOneToOne()) != null) {
                for (OneToOne oo1 : oos) {
                    this.mappings.put(oo1.getName(), new Mapping(this, new JPAAttribute(this.element, oo1)));
                }
            }
            if ((oms = atrs.getOneToMany()) != null) {
                for (OneToMany om1 : oms) {
                    this.mappings.put(om1.getName(), new Mapping(this, new JPAAttribute(this.element, om1)));
                }
            }
            if ((bs = atrs.getBasic()) != null) {
                for (Basic b1 : bs) {
                    this.mappings.put(b1.getName(), new Mapping(this, new JPAAttribute(this.element, b1)));
                }
            }
            if ((ids = atrs.getId()) != null) {
                for (Id id1 : ids) {
                    this.mappings.put(id1.getName(), new Mapping(this, new JPAAttribute(this.element, id1)));
                }
            }
            try {
                Embedded[] es = atrs.getEmbedded();
                if (es != null) {
                    for (Embedded e1 : es) {
                        this.mappings.put(e1.getName(), new Mapping(this, new JPAAttribute(this.element, e1)));
                    }
                }
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            try {
                EmbeddedId eds = atrs.getEmbeddedId();
                if (eds != null) {
                    this.mappings.put(eds.getName(), new Mapping(this, new JPAAttribute(this.element, eds)));
                }
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
        }
        return this.mappings;
    }

    abstract Attributes getAttributes();
}

