/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.dbscript;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.api.PersistenceEnvironment;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.wizard.dbscript.DBScriptWizard;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupUISupport;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DBScriptPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(DBScriptPanel.class.getName());
    private static final String EXTENSION = "sql";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JTextComponent packageComboBoxEditor;
    private Project project;
    private JCheckBox createDropScriptCheckbox;
    private JLabel createScriptWarningLabel;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JLabel scriptNameLabel;
    private JTextField scriptNameTextField;

    private DBScriptPanel() {
        this.initComponents();
        this.packageComboBoxEditor = (JTextComponent)this.packageComboBox.getEditor().getEditorComponent();
        Document packageComboBoxDocument = this.packageComboBoxEditor.getDocument();
        packageComboBoxDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                DBScriptPanel.this.packageChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DBScriptPanel.this.packageChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DBScriptPanel.this.packageChanged();
            }
        });
        this.scriptNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DBScriptPanel.this.changeSupport.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DBScriptPanel.this.changeSupport.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DBScriptPanel.this.changeSupport.fireChange();
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void initialize(Project project, FileObject targetFolder) {
        SourceGroup targetSourceGroup;
        this.project = project;
        this.projectTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroups);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updatePackageComboBox();
        if (targetFolder != null && (targetSourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])sourceGroups, (FileObject)targetFolder)) != null) {
            this.locationComboBox.setSelectedItem(targetSourceGroup);
            String targetPackage = SourceGroups.getPackageForFolder((SourceGroup)targetSourceGroup, (FileObject)targetFolder);
            if (targetPackage != null) {
                this.packageComboBoxEditor.setText(targetPackage);
            }
        }
        this.createDropScriptCheckbox.setVisible(false);
        this.uniqueName();
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackageName() {
        return this.packageComboBoxEditor.getText();
    }

    public String getScriptName() {
        return this.scriptNameTextField.getText();
    }

    private void locationChanged() {
        this.updatePackageComboBox();
        this.changeSupport.fireChange();
    }

    private void packageChanged() {
        this.changeSupport.fireChange();
    }

    private void updatePackageComboBox() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
                model.setSelectedItem(model.getElementAt(1));
            }
            this.packageComboBox.setModel(model);
        }
    }

    private void initComponents() {
        this.scriptNameLabel = new JLabel();
        this.scriptNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.createScriptWarningLabel = new ShyLabel();
        this.createDropScriptCheckbox = new JCheckBox();
        this.setName(NbBundle.getMessage(DBScriptPanel.class, (String)"LBL_EntityClasses"));
        Mnemonics.setLocalizedText((JLabel)this.scriptNameLabel, (String)NbBundle.getMessage(DBScriptPanel.class, (String)"LBL_ScriptName"));
        this.scriptNameTextField.setColumns(40);
        this.scriptNameTextField.setText(NbBundle.getMessage(DBScriptPanel.class, (String)"TXT_NAMEBASE"));
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(DBScriptPanel.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(DBScriptPanel.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBScriptPanel.this.locationComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(DBScriptPanel.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        Mnemonics.setLocalizedText((JLabel)this.createScriptWarningLabel, (String)"  ");
        this.createScriptWarningLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createScriptWarningLabel.setMaximumSize(new Dimension(1000, 29));
        Mnemonics.setLocalizedText((AbstractButton)this.createDropScriptCheckbox, (String)NbBundle.getMessage(DBScriptPanel.class, (String)"LBL_CreateDropScript"));
        this.createDropScriptCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createDropScriptCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DBScriptPanel.this.createDropScriptCheckboxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectLabel).addComponent(this.locationLabel).addComponent(this.packageLabel)).addGap(54, 54, 54).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.locationComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.projectTextField).addComponent(this.packageComboBox, 0, -1, Short.MAX_VALUE))).addComponent(this.createScriptWarningLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.createDropScriptCheckbox).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scriptNameLabel).addGap(18, 18, 18).addComponent(this.scriptNameTextField, -2, 442, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scriptNameLabel).addComponent(this.scriptNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectTextField, -2, -1, -2).addComponent(this.projectLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationComboBox, -2, -1, -2).addComponent(this.locationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageComboBox, -2, -1, -2).addComponent(this.packageLabel)).addGap(18, 18, 18).addComponent(this.createDropScriptCheckbox).addGap(18, 18, 18).addComponent(this.createScriptWarningLabel, -2, 40, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void locationComboBoxActionPerformed(ActionEvent evt) {
        this.locationChanged();
    }

    private void createDropScriptCheckboxItemStateChanged(ItemEvent evt) {
        if (!this.createDropScriptCheckbox.isVisible() || this.createDropScriptCheckbox.isSelected()) {
            // empty if block
        }
    }

    private void uniqueName() {
        String base = NbBundle.getMessage(DBScriptPanel.class, (String)"TXT_NAMEBASE");
        SourceGroup sourceGroup = this.getLocationValue();
        if (sourceGroup == null) {
            return;
        }
        String packageName = this.getPackageName();
        if (packageName == null) {
            return;
        }
        try {
            FileObject packageFO = SourceGroups.getFolderForPackage((SourceGroup)sourceGroup, (String)packageName, (boolean)false);
            if (packageFO == null) {
                return;
            }
            String scriptName = base;
            int counter = 1;
            while (packageFO.getFileObject(scriptName, EXTENSION) != null) {
                scriptName = base + counter++;
            }
            this.scriptNameTextField.setText(scriptName);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private static final class ShyLabel
    extends JLabel {
        private ShyLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = 0;
            return size;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.width = 0;
            return size;
        }
    }

    public static final class WizardPanel
    implements WizardDescriptor.Panel,
    WizardDescriptor.FinishablePanel,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private boolean componentInitialized;
        private DBScriptPanel component;
        private WizardDescriptor wizardDescriptor;
        private Project project;
        private List<Provider> providers;
        private boolean deepVerify = true;

        public DBScriptPanel getComponent() {
            if (this.component == null) {
                this.component = new DBScriptPanel();
                this.component.addChangeListener(this);
            }
            return this.component;
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public HelpCtx getHelp() {
            return new HelpCtx("org.netbeans.modules.j2ee.persistence.wizard.dbscript.DBScriptPanel");
        }

        public void readSettings(Object settings) {
            this.wizardDescriptor = (WizardDescriptor)settings;
            if (!this.componentInitialized) {
                this.componentInitialized = true;
                this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
                this.getComponent().initialize(this.project, targetFolder);
            }
        }

        public boolean isValid() {
            String name;
            SourceGroup sourceGroup = this.getComponent().getLocationValue();
            if (sourceGroup == null) {
                this.setErrorMessage(NbBundle.getMessage(DBScriptPanel.class, (String)"ERR_JavaTargetChooser_SelectSourceGroup"));
                return false;
            }
            String packageName = this.getComponent().getPackageName();
            if (packageName.trim().equals("")) {
                this.setErrorMessage(NbBundle.getMessage(DBScriptPanel.class, (String)"ERR_JavaTargetChooser_CantUseDefaultPackage"));
                return false;
            }
            if (!JavaIdentifiers.isValidPackageName((String)packageName)) {
                this.setErrorMessage(NbBundle.getMessage(DBScriptPanel.class, (String)"ERR_JavaTargetChooser_InvalidPackage"));
                return false;
            }
            if (!SourceGroups.isFolderWritable((SourceGroup)sourceGroup, (String)packageName)) {
                this.setErrorMessage(NbBundle.getMessage(DBScriptPanel.class, (String)"ERR_JavaTargetChooser_UnwritablePackage"));
                return false;
            }
            ClassPath classPath = null;
            FileObject rPackageFO = null;
            try {
                FileObject packageFO;
                rPackageFO = packageFO = SourceGroups.getFolderForPackage((SourceGroup)sourceGroup, (String)packageName, (boolean)false);
                if (packageFO == null) {
                    packageFO = sourceGroup.getRootFolder();
                }
                classPath = ClassPath.getClassPath((FileObject)packageFO, (String)"classpath/compile");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            if (classPath != null) {
                if (classPath.findResource("javax/persistence/EntityManager.class") == null) {
                    if (this.providers == null) {
                        this.providers = PersistenceLibrarySupport.getProvidersFromLibraries();
                    }
                    if (this.providers.isEmpty()) {
                        this.setErrorMessage(NbBundle.getMessage(DBScriptPanel.class, (String)"ERR_NoJavaPersistenceAPI"));
                        return false;
                    }
                }
            } else {
                LOGGER.log(Level.WARNING, "Cannot get a classpath for package {0} in {1}", new Object[]{packageName, sourceGroup});
            }
            if ((name = this.getComponent().getScriptName().trim()).length() == 0) {
                this.setErrorMessage(NbBundle.getMessage(DBScriptPanel.class, (String)"ERR_JavaTargetChooser_InvalidNameLength0"));
                return false;
            }
            if (rPackageFO != null) {
                if (name.endsWith(".sql")) {
                    name = name.substring(0, name.length() - 4);
                }
                if (rPackageFO.getFileObject(name, DBScriptPanel.EXTENSION) != null) {
                    this.setErrorMessage(NbBundle.getMessage(DBScriptPanel.class, (String)"ERR_JavaTargetChooser_InvalidNameExists", (Object)name));
                    return false;
                }
            }
            if (this.deepVerify) {
                PersistenceEnvironment pe = (PersistenceEnvironment)this.project.getLookup().lookup(PersistenceEnvironment.class);
                List<String> problems = DBScriptWizard.run(this.project, null, pe, null, true);
                if (problems != null && !problems.isEmpty()) {
                    this.setErrorMessage(problems.get(0));
                    return false;
                }
                this.deepVerify = false;
            }
            this.setErrorMessage(" ");
            return true;
        }

        public void storeSettings(Object settings) {
            WizardDescriptor wizDescriptor = (WizardDescriptor)settings;
            SourceGroup sourceGroup = this.getComponent().getLocationValue();
            String packageName = this.getComponent().getPackageName().trim();
            FileObject packageFO = null;
            try {
                packageFO = SourceGroups.getFolderForPackage((SourceGroup)sourceGroup, (String)packageName, (boolean)true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            Templates.setTargetFolder((WizardDescriptor)wizDescriptor, (FileObject)packageFO);
            Templates.setTargetName((WizardDescriptor)wizDescriptor, (String)this.getComponent().getScriptName());
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.changeSupport.fireChange();
        }

        private void setErrorMessage(String errorMessage) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        }

        public boolean isFinishPanel() {
            return true;
        }
    }
}

