/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.sql.DataSource;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceSupport;
import org.netbeans.modules.j2ee.api.ejbjar.MessageDestinationReference;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.javaee.injection.api.InjectionTargetQuery;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.web.WebModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

@SuppressWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class EntRefContainerImpl
implements EnterpriseReferenceContainer {
    private Project project;
    private static final String SERVICE_LOCATOR_PROPERTY = "project.serviceLocator.class";
    private WebApp webApp;

    public EntRefContainerImpl(Project p) {
        this.project = p;
    }

    public String addEjbLocalReference(EjbReference localRef, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencingClass) throws IOException {
        return this.addReference(localRef, refType, ejbRefName, true, referencingFile, referencingClass);
    }

    public String addEjbReference(EjbReference ref, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencingClass) throws IOException {
        return this.addReference(ref, refType, ejbRefName, false, referencingFile, referencingClass);
    }

    private String addReference(final EjbReference ejbReference, EjbReference.EjbRefIType refType, String ejbRefName, boolean local, FileObject referencingFile, String referencingClass) throws IOException {
        EjbLocalRef newRef;
        boolean fromSameProject;
        String refName = null;
        MetadataModel ejbReferenceMetadataModel = ejbReference.getEjbModule().getMetadataModel();
        String ejbName = (String)ejbReferenceMetadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) throws Exception {
                return metadata.findByEjbClass(ejbReference.getEjbClass()).getEjbName();
            }
        });
        FileObject ejbReferenceEjbClassFO = SourceUtils.getFileObject((String)ejbReference.getComponentName(refType), (ClasspathInfo)ejbReference.getClasspathInfo());
        assert (ejbReferenceEjbClassFO != null) : "Reference FileObject not found: " + ejbReference.getComponentName(refType);
        Project otherPrj = FileOwnerQuery.getOwner((FileObject)ejbReferenceEjbClassFO);
        final NbMavenProject oprj = (NbMavenProject)otherPrj.getLookup().lookup(NbMavenProject.class);
        String jarName = "";
        boolean bl = fromSameProject = oprj != null && this.project.equals(otherPrj) || oprj == null;
        if (!fromSameProject && oprj != null) {
            jarName = oprj.getMavenProject().getBuild().getFinalName();
            final String grId = oprj.getMavenProject().getGroupId();
            final String artId = oprj.getMavenProject().getArtifactId();
            final String version = oprj.getMavenProject().getVersion();
            Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    Dependency d;
                    if (!ModelUtils.hasModelDependency((POMModel)model, (String)grId, (String)artId) && (d = ModelUtils.checkModelDependency((POMModel)model, (String)grId, (String)artId, (boolean)true)) != null) {
                        d.setVersion(version);
                        if ("ejb".equals(oprj.getPackagingType()) || "war".equals(oprj.getPackagingType())) {
                            d.setScope("provided");
                        }
                    }
                }
            }));
        }
        WebApp wApp = this.getWebApp();
        if (this.webApp == null) {
            return null;
        }
        jarName = jarName + "#";
        String ejbLink = jarName + ejbName;
        if (local) {
            refName = this.getUniqueName(this.getWebApp(), "EjbLocalRef", "EjbRefName", ejbRefName);
            try {
                newRef = (EjbLocalRef)wApp.createBean("EjbLocalRef");
                if (fromSameProject) {
                    newRef.setEjbLink(ejbLink);
                }
                newRef.setEjbRefName(refName);
                newRef.setEjbRefType(ejbReference.getEjbRefType());
                newRef.setLocal(ejbReference.getLocal());
                newRef.setLocalHome(ejbReference.getLocalHome());
                this.getWebApp().addEjbLocalRef(newRef);
            }
            catch (ClassNotFoundException ex) {}
        } else {
            refName = this.getUniqueName(this.getWebApp(), "EjbRef", "EjbRefName", ejbRefName);
            try {
                newRef = (EjbRef)wApp.createBean("EjbRef");
                newRef.setEjbRefName(refName);
                newRef.setEjbRefType(ejbReference.getEjbRefType());
                newRef.setHome(ejbReference.getRemoteHome());
                newRef.setRemote(ejbReference.getRemote());
                this.getWebApp().addEjbRef((EjbRef)newRef);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        this.writeDD(referencingFile, referencingClass);
        return refName;
    }

    public String getServiceLocatorName() {
        AuxiliaryProperties props = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        return props.get(SERVICE_LOCATOR_PROPERTY, true);
    }

    public void setServiceLocatorName(String serviceLocator) throws IOException {
        AuxiliaryProperties props = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        props.put(SERVICE_LOCATOR_PROPERTY, serviceLocator, true);
    }

    private WebApp getWebApp() throws IOException {
        WebModuleImpl jp;
        FileObject fo;
        if (this.webApp == null && (fo = (jp = ((WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class))).getModuleImpl()).getDeploymentDescriptor()) != null) {
            this.webApp = DDProvider.getDefault().getDDRoot(fo);
        }
        return this.webApp;
    }

    private void writeDD(FileObject referencingFile, final String referencingClass) throws IOException {
        boolean shouldWrite;
        WebModuleImpl jp = ((WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class))).getModuleImpl();
        final boolean[] isInjectionTarget = new boolean[]{false};
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                Elements elements = controller.getElements();
                TypeElement thisElement = elements.getTypeElement(referencingClass);
                if (thisElement != null) {
                    isInjectionTarget[0] = InjectionTargetQuery.isInjectionTarget((CompilationController)controller, (TypeElement)thisElement);
                }
            }

            public void cancel() {
            }
        };
        JavaSource refFile = JavaSource.forFileObject((FileObject)referencingFile);
        if (refFile != null) {
            refFile.runUserActionTask((Task)task, true);
        }
        boolean bl = shouldWrite = EntRefContainerImpl.isDescriptorMandatory(jp.getJ2eeProfile()) || !isInjectionTarget[0];
        if (shouldWrite) {
            FileObject fo = jp.getDeploymentDescriptor();
            this.getWebApp().write(fo);
        }
    }

    public String addResourceRef(ResourceReference ref, FileObject referencingFile, String referencingClass) throws IOException {
        WebModuleImpl jp;
        WebApp webApp = this.getWebApp();
        if (webApp == null && !EntRefContainerImpl.isDescriptorMandatory((jp = ((WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class))).getModuleImpl()).getJ2eeProfile())) {
            if (jp.getWebInf() == null) {
                jp.createWebInf();
            }
            DDHelper.createWebXml((Profile)jp.getJ2eeProfile(), (FileObject)jp.getWebInf());
            webApp = this.getWebApp();
        }
        String resourceRefName = ref.getResRefName();
        if (DataSource.class.getName().equals(ref.getResType())) {
            ResourceRef[] refs = webApp.getResourceRef();
            for (int i = 0; i < refs.length; ++i) {
                boolean canCompareDefDesc;
                String newDefaultDescription = ref.getDefaultDescription();
                String existingDefaultDescription = refs[i].getDefaultDescription();
                boolean bl = canCompareDefDesc = newDefaultDescription != null && existingDefaultDescription != null;
                if (!DataSource.class.getName().equals(refs[i].getResType()) || canCompareDefDesc && !newDefaultDescription.equals(existingDefaultDescription) || !ref.getResRefName().equals(refs[i].getResRefName())) continue;
                return refs[i].getResRefName();
            }
        }
        if (!EntRefContainerImpl.isResourceRefUsed(webApp, ref)) {
            resourceRefName = this.getUniqueName(webApp, "ResourceRef", "ResRefName", ref.getResRefName());
            ResourceRef resourceRef = this.createResourceRef();
            EnterpriseReferenceSupport.populate((ResourceReference)ref, (String)resourceRefName, (ResourceRef)resourceRef);
            webApp.addResourceRef(resourceRef);
            this.writeDD(referencingFile, referencingClass);
        }
        return resourceRefName;
    }

    public String addDestinationRef(MessageDestinationReference ref, FileObject referencingFile, String referencingClass) throws IOException {
        try {
            for (MessageDestinationRef mdRef : this.getWebApp().getMessageDestinationRef()) {
                if (!mdRef.getMessageDestinationRefName().equals(ref.getMessageDestinationRefName())) continue;
                return mdRef.getMessageDestinationRefName();
            }
        }
        catch (VersionNotSupportedException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        String refName = this.getUniqueName(this.getWebApp(), "MessageDestinationRef", "MessageDestinationRefName", ref.getMessageDestinationRefName());
        MessageDestinationRef messageDestinationRef = this.createDestinationRef();
        EnterpriseReferenceSupport.populate((MessageDestinationReference)ref, (String)refName, (MessageDestinationRef)messageDestinationRef);
        try {
            this.getWebApp().addMessageDestinationRef(messageDestinationRef);
            this.writeDD(referencingFile, referencingClass);
        }
        catch (VersionNotSupportedException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        return refName;
    }

    public ResourceRef createResourceRef() throws IOException {
        try {
            return (ResourceRef)this.getWebApp().createBean("ResourceRef");
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public MessageDestinationRef createDestinationRef() throws IOException {
        try {
            return (MessageDestinationRef)this.getWebApp().createBean("MessageDestinationRef");
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private String getUniqueName(WebApp wa, String beanName, String property, String originalValue) {
        String proposedValue = originalValue;
        int index = 1;
        while (wa.findBeanByName(beanName, property, proposedValue) != null) {
            proposedValue = originalValue + Integer.toString(index++);
        }
        return proposedValue;
    }

    private static boolean isDescriptorMandatory(Profile j2eeVersion) {
        return Profile.J2EE_14.equals(j2eeVersion);
    }

    private static boolean isResourceRefUsed(WebApp webApp, ResourceReference resRef) {
        String resRefName = resRef.getResRefName();
        String resRefType = resRef.getResType();
        for (ResourceRef existingRef : webApp.getResourceRef()) {
            if (!resRefName.equals(existingRef.getResRefName()) || !resRefType.equals(existingRef.getResType())) continue;
            return true;
        }
        return false;
    }
}

