/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.j2ee.web.WebProjectUtils;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class WebProjectWebRootProvider
implements ProjectWebRootProvider {
    private final Project project;
    private final FileObject projectDir;

    public WebProjectWebRootProvider(Project project) {
        this.project = project;
        this.projectDir = project.getProjectDirectory();
    }

    public FileObject getWebRoot(FileObject file) {
        return this.getDefaultWebRoot();
    }

    public Collection<FileObject> getWebRoots() {
        FileObject defaultWebRoot;
        LinkedHashSet<FileObject> webRootsFO = new LinkedHashSet<FileObject>();
        List<String> webRoots = WebProjectUtils.getPluginProperty(this.project, new WebRootsBuilder());
        if (webRoots != null) {
            for (String webRoot : webRoots) {
                FileObject webRootFo = this.projectDir.getFileObject(webRoot);
                if (webRootFo == null) continue;
                webRootsFO.add(webRootFo);
            }
        }
        if ((defaultWebRoot = this.getDefaultWebRoot()) != null) {
            webRootsFO.add(defaultWebRoot);
        }
        return webRootsFO;
    }

    private FileObject getDefaultWebRoot() {
        FileObject sourceRoot;
        String webSourceDir = WebProjectUtils.getPluginProperty(this.project, "warSourceDirectory");
        if (webSourceDir == null) {
            webSourceDir = "src/main/webapp";
        }
        if ((sourceRoot = this.projectDir.getFileObject(webSourceDir)) != null) {
            return sourceRoot;
        }
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(webSourceDir)));
    }

    private static class WebRootsBuilder
    implements PluginPropertyUtils.ConfigurationBuilder<List<String>> {
        private WebRootsBuilder() {
        }

        public List<String> build(Xpp3Dom configRoot, ExpressionEvaluator eval) {
            Xpp3Dom webResources;
            ArrayList<String> webRoots = new ArrayList<String>();
            if (configRoot != null && (webResources = configRoot.getChild("webResources")) != null) {
                Xpp3Dom[] resources;
                for (Xpp3Dom resource : resources = webResources.getChildren("resource")) {
                    Xpp3Dom directory;
                    if (resource == null || (directory = resource.getChild("directory")) == null) continue;
                    try {
                        String directoryValue = (String)eval.evaluate(directory.getValue());
                        if (directoryValue == null || "".equals(directoryValue.trim())) continue;
                        webRoots.add(directoryValue);
                    }
                    catch (ExpressionEvaluationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return webRoots;
        }
    }
}

