/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.maven.j2ee.web.ServletUriPanel;
import org.netbeans.modules.maven.j2ee.web.WebAppMetadataHelper;
import org.netbeans.modules.maven.spi.actions.ActionConvertor;
import org.netbeans.modules.maven.spi.actions.ReplaceTokenProvider;
import org.netbeans.modules.web.api.webmodule.RequestParametersQuery;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WebReplaceTokenProvider
implements ReplaceTokenProvider,
ActionConvertor {
    private static final String WEB_PATH = "webpagePath";
    private static final String IS_SERVLET_FILE = "org.netbeans.modules.web.IsServletFile";
    public static final String ATTR_EXECUTION_URI = "execution.uri";
    public static final String FILE_DD = "web.xml";
    private static final Set<WebModule> SERVLET_SEARCH_MODULES = new HashSet<WebModule>();
    private static RequestProcessor SERVLETS_REQUEST_PROCESSOR = new RequestProcessor(WebReplaceTokenProvider.class);
    private static RequestProcessor RP = new RequestProcessor(WebReplaceTokenProvider.class);
    private Project project;
    private AtomicBoolean isScanStarted;
    private AtomicBoolean isScanFinished;

    public WebReplaceTokenProvider(Project prj) {
        this.project = prj;
        this.isScanStarted = new AtomicBoolean(false);
        this.isScanFinished = new AtomicBoolean(false);
    }

    protected static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (DataObject d : lookup.lookupAll(DataObject.class)) {
            FileObject f = d.getPrimaryFile();
            files.add(f);
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public Map<String, String> createReplacements(String action, Lookup lookup) {
        FileObject[] fos = WebReplaceTokenProvider.extractFileObjectsfromLookup(lookup);
        String relPath = null;
        FileObject fo = null;
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        if (fos.length > 0 && action.endsWith(".deploy")) {
            WebModule webModule;
            String[] urlPatterns;
            String url;
            fo = fos[0];
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            String requestParams = RequestParametersQuery.getFileAndParameters((FileObject)fo);
            if (requestParams != null && !"/null".equals(requestParams)) {
                relPath = requestParams;
            }
            if (relPath == null && (url = FileUtil.getRelativePath((FileObject)WebModule.getWebModule((FileObject)fo).getDocumentBase(), (FileObject)fo)) != null) {
                url = url.replace(" ", "%20");
                relPath = "/" + url;
            }
            if (relPath == null) {
                SourceGroup[] grp = srcs.getSourceGroups("doc_root");
                for (int i = 0; i < grp.length && (relPath = FileUtil.getRelativePath((FileObject)grp[i].getRootFolder(), (FileObject)fo)) == null; ++i) {
                }
            }
            if (relPath == null && "text/x-java".equals(fo.getMIMEType()) && (urlPatterns = WebReplaceTokenProvider.getServletMappings(webModule = WebModule.getWebModule((FileObject)fo), fo)) != null && urlPatterns.length > 0) {
                ServletUriPanel uriPanel = new ServletUriPanel(urlPatterns, null, true);
                DialogDescriptor desc = new DialogDescriptor((Object)uriPanel, NbBundle.getMessage(WebReplaceTokenProvider.class, (String)"TTL_setServletExecutionUri"));
                Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                if (res.equals(NotifyDescriptor.YES_OPTION)) {
                    relPath = uriPanel.getServletUri();
                    try {
                        fo.setAttribute(ATTR_EXECUTION_URI, (Object)uriPanel.getServletUri());
                    }
                    catch (IOException ex) {}
                } else if (res.equals(NotifyDescriptor.CANCEL_OPTION)) {
                    replaceMap.put(WEB_PATH, null);
                    return replaceMap;
                }
            }
            if (relPath == null) {
                relPath = "";
            }
            replaceMap.put(WEB_PATH, relPath);
        }
        return replaceMap;
    }

    public static String[] getServletMappings(WebModule webModule, FileObject javaClass) {
        if (webModule == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)javaClass, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        String className = classPath.getResourceName(javaClass, '.', false);
        try {
            List<ServletInfo> servlets = WebAppMetadataHelper.getServlets((MetadataModel<WebAppMetadata>)webModule.getMetadataModel());
            ArrayList mappingList = new ArrayList();
            for (ServletInfo si : servlets) {
                if (!className.equals(si.getServletClass())) continue;
                mappingList.addAll(si.getUrlPatterns());
            }
            return mappingList.toArray(new String[mappingList.size()]);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String convert(String action, Lookup lookup) {
        FileObject[] fos;
        if (("run.single".equals(action) || "debug.single".equals(action) || "profile.single".equals(action)) && (fos = WebReplaceTokenProvider.extractFileObjectsfromLookup(lookup)).length > 0) {
            FileObject fo = fos[0];
            String mimeType = fo.getMIMEType();
            if ("text/x-java".equals(mimeType)) {
                return this.convertJavaAction(action, fo);
            }
            if ("text/x-jsp".equals(mimeType) || "text/html".equals(mimeType) || "text/xhtml".equals(mimeType)) {
                return action + ".deploy";
            }
        }
        return null;
    }

    private String convertJavaAction(String action, FileObject fo) {
        SourceGroup[] sourceGroups;
        if (fo.getAttribute(ATTR_EXECUTION_URI) == null && this.servletFilesScanning(fo)) {
            return null;
        }
        Sources srcs = ProjectUtils.getSources((Project)this.project);
        for (SourceGroup group : sourceGroups = srcs.getSourceGroups("java")) {
            String relPath;
            if ("2TestSourceRoot".equals(group.getName()) || (relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo)) == null) continue;
            if (fo.getAttribute(ATTR_EXECUTION_URI) != null || Boolean.TRUE.equals(fo.getAttribute(IS_SERVLET_FILE))) {
                return action + ".deploy";
            }
            if (!WebReplaceTokenProvider.isServletFile(fo, false)) continue;
            try {
                fo.setAttribute(IS_SERVLET_FILE, (Object)Boolean.TRUE);
            }
            catch (IOException ex) {
                // empty catch block
            }
            return action + ".deploy";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isServletFile(final FileObject javaClass, boolean initialScan) {
        if (javaClass == null) {
            return false;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)javaClass, (String)"classpath/source");
        if (classPath == null) {
            return false;
        }
        String className = classPath.getResourceName(javaClass, '.', false);
        if (className == null) {
            return false;
        }
        final WebModule webModule = WebModule.getWebModule((FileObject)javaClass);
        if (webModule == null) {
            return false;
        }
        try {
            MetadataModel metadataModel = webModule.getMetadataModel();
            boolean result = false;
            if (initialScan || metadataModel.isReady()) {
                List<ServletInfo> servlets = WebAppMetadataHelper.getServlets((MetadataModel<WebAppMetadata>)metadataModel);
                final ArrayList<String> servletClasses = new ArrayList<String>(servlets.size());
                for (ServletInfo si : servlets) {
                    if (className.equals(si.getServletClass())) {
                        result = true;
                        continue;
                    }
                    servletClasses.add(si.getServletClass());
                }
                Set<WebModule> set = SERVLET_SEARCH_MODULES;
                synchronized (set) {
                    if (!SERVLET_SEARCH_MODULES.contains(webModule)) {
                        SERVLET_SEARCH_MODULES.add(webModule);
                        if (!initialScan || SwingUtilities.isEventDispatchThread()) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    WebReplaceTokenProvider.setServletClasses(servletClasses, javaClass, webModule);
                                }
                            };
                            SERVLETS_REQUEST_PROCESSOR.post(runnable);
                        } else {
                            WebReplaceTokenProvider.setServletClasses(servletClasses, javaClass, webModule);
                        }
                    }
                }
            }
            return result;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean servletFilesScanning(final FileObject fileObject) {
        if (this.isScanFinished.get()) {
            return false;
        }
        if (this.isScanStarted.get()) {
            return true;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WebReplaceTokenProvider.isServletFile(fileObject, true);
                WebReplaceTokenProvider.this.isScanFinished.set(true);
            }
        };
        if (!this.isScanStarted.get()) {
            this.isScanStarted.set(true);
            RP.post(runnable);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setServletClasses(final List<String> servletClasses, FileObject orig, WebModule module) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)orig);
        if (javaSource == null) {
            return;
        }
        final Project project = FileOwnerQuery.getOwner((FileObject)orig);
        if (project == null) {
            return;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    block0: for (String servletClass : servletClasses) {
                        SourceGroup[] sourceGroups;
                        Sources sources;
                        ElementHandle handle;
                        FileObject fileObject;
                        TypeElement typeElem;
                        if (servletClass == null || (typeElem = controller.getElements().getTypeElement(servletClass)) == null || (fileObject = SourceUtils.getFile((ElementHandle)(handle = ElementHandle.create((Element)typeElem)), (ClasspathInfo)controller.getClasspathInfo())) == null || Boolean.TRUE.equals(fileObject.getAttribute(WebReplaceTokenProvider.IS_SERVLET_FILE)) || (sources = ProjectUtils.getSources((Project)project)) == null) continue;
                        for (SourceGroup group : sourceGroups = sources.getSourceGroups("java")) {
                            FileObject root = group.getRootFolder();
                            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fileObject)) continue;
                            fileObject.setAttribute(WebReplaceTokenProvider.IS_SERVLET_FILE, (Object)Boolean.TRUE);
                            continue block0;
                        }
                    }
                }
            }, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Set<WebModule> set = SERVLET_SEARCH_MODULES;
            synchronized (set) {
                SERVLET_SEARCH_MODULES.remove(module);
            }
        }
    }
}

