/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.openide.util.NbBundle;

final class IpAddressValidator
extends StringValidator {
    IpAddressValidator() {
    }

    @Override
    public void validate(Problems problems, String compName, String s) {
        if (s.startsWith(".") || s.endsWith(".")) {
            problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"HOST_STARTS_OR_ENDS_WITH_PERIOD", (Object)s));
            return;
        }
        if (s.indexOf(" ") >= 0 || s.indexOf("\t") >= 0) {
            problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"IP_ADDRESS_CONTAINS_WHITESPACE", (Object)compName, (Object)s));
            return;
        }
        String[] parts = s.split("\\.");
        if (parts.length > 4) {
            problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"TOO_MANY_LABELS", (Object)s));
            return;
        }
        if (parts.length < 3) {
            problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_BAD", (Object)s));
            return;
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == parts.length - 1 && part.indexOf(":") > 0) {
                if (part.endsWith(":")) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"TOO_MANY_COLONS", (Object)compName, (Object)s));
                    return;
                }
                String[] pts = part.split(":");
                try {
                    int addr = Integer.parseInt(pts[0]);
                    if (addr < 0) {
                        problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_NEGATIVE", (Object)pts[1]));
                        return;
                    }
                    if (addr > 256) {
                        problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_HIGH", (Object)pts[1]));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_BAD", (Object)(pts.length >= 2 ? pts[1] : "''")));
                    return;
                }
                if (pts.length == 2 && pts[1].length() == 0) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)""));
                    return;
                }
                if (pts.length == 1) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)""));
                    return;
                }
                if (pts.length <= 1) continue;
                try {
                    int port = Integer.parseInt(pts[1]);
                    if (port < 0) {
                        problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"NEGATIVE_PORT", (Object)pts[1]));
                        return;
                    }
                    if (port < 65536) continue;
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"PORT_TOO_HIGH", (Object)pts[1]));
                    return;
                }
                catch (NumberFormatException e) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)pts[1]));
                    return;
                }
            }
            try {
                int addr = Integer.parseInt(part);
                if (addr < 0) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_NEGATIVE", (Object)part));
                    return;
                }
                if (addr <= 256) continue;
                problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_HIGH", (Object)part));
                return;
            }
            catch (NumberFormatException e) {
                problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_BAD", (Object)part));
                return;
            }
        }
    }
}

