/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.samples;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.maven.samples.CRUDSampleDbPersistencePanel;
import org.netbeans.modules.maven.samples.MavenSamplesWizardIterator;
import org.netbeans.modules.maven.samples.MavenSamplesWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MavenCRUDSampleWizardIterator
extends MavenSamplesWizardIterator {
    private static final long serialVersionUID = 1L;
    private CRUDSampleDbPersistencePanel configurationPanel;

    public MavenCRUDSampleWizardIterator() {
        super(NbBundle.getMessage(MavenCRUDSampleWizardIterator.class, (String)"Templates/Project/Samples/Maven/MavenCRUDSample"));
    }

    public static MavenCRUDSampleWizardIterator createIterator() {
        return new MavenCRUDSampleWizardIterator();
    }

    @Override
    protected WizardDescriptor.Panel[] createPanels() {
        this.configurationPanel = new CRUDSampleDbPersistencePanel();
        return new WizardDescriptor.Panel[]{new MavenSamplesWizardPanel(this.configurationPanel.isValid()), this.configurationPanel};
    }

    @Override
    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(MavenCRUDSampleWizardIterator.class, (String)"LBL_CreateProjectStep"), NbBundle.getMessage(MavenCRUDSampleWizardIterator.class, (String)"LBL_CreatePersistenceStep")};
    }

    @Override
    protected void configureProject(FileObject dir) throws IOException {
        try {
            this.copyPersistenceLibraries(this.configurationPanel.getSelectedLibrary(), dir);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        catch (IllegalStateException ex) {
            throw new IOException(ex);
        }
        this.configureDerby(this.configurationPanel.getDerbyLocation(), dir);
    }

    private void copyPersistenceLibraries(Library l, FileObject projectRoot) throws URISyntaxException, IllegalStateException, FileNotFoundException, IOException {
        String libraryName = l.getName();
        File libraryFile = new File(FileUtil.toFile((FileObject)projectRoot), "crudsample" + File.separator + libraryName + ".xml");
        Logger.getLogger(MavenCRUDSampleWizardIterator.class.getName()).log(Level.FINE, "pom.xml found at {0}", new Object[]{libraryFile});
        assert (libraryFile.exists()) : libraryFile + " exists.";
        File pomFile = new File(FileUtil.toFile((FileObject)projectRoot), "crudsample" + File.separator + "pom.xml");
        libraryFile.renameTo(pomFile);
        File libraryConfFile = new File(FileUtil.toFile((FileObject)projectRoot), "crudsample" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "META-INF" + File.separator + l.getName() + ".xml");
        Logger.getLogger(MavenCRUDSampleWizardIterator.class.getName()).log(Level.FINE, "META-INF/peristence.xml found at {0}", new Object[]{libraryConfFile});
        assert (libraryConfFile.exists()) : libraryConfFile + " exists.";
        File persistenceConfFile = new File(libraryConfFile.getParent(), "persistence.xml");
        libraryConfFile.renameTo(persistenceConfFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureDerby(String loc, FileObject projectRoot) throws FileNotFoundException, IOException {
        File bundleFile = new File(FileUtil.toFile((FileObject)projectRoot), "crudsample" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "org" + File.separator + "netbeans" + File.separator + "modules" + File.separator + "crudsampleapplication" + File.separator + "dbaccess" + File.separator + "Bundle.properties");
        FileObject bundleFO = FileUtil.toFileObject((File)bundleFile);
        Properties bundleProperties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = bundleFO.getInputStream();
            bundleProperties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        bundleProperties.setProperty("javadb.home", loc);
        OutputStream outputStream = null;
        try {
            outputStream = bundleFO.getOutputStream();
            bundleProperties.store(outputStream, null);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        Logger.getLogger(MavenCRUDSampleWizardIterator.class.getName()).log(Level.FINE, "JavaDB home is {0}", new Object[]{loc});
    }
}

