/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.weblogic.common.spi.WebLogicTrustHandler;
import org.openide.util.Lookup;

public final class URLWait {
    private static final Logger LOGGER = Logger.getLogger(URLWait.class.getName());
    private static final HostnameVerifier EMPTY_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession ssls) {
            return true;
        }
    };

    private URLWait() {
    }

    public static boolean waitForUrlReady(WLDeploymentManager dm, ExecutorService service, URL url, int timeout) {
        String host = url.getHost();
        try {
            InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return URLWait.waitForUrlConnection(dm, service, url, timeout, 100);
    }

    private static boolean waitForUrlConnection(WLDeploymentManager dm, ExecutorService service, URL url, int timeout, int retryTime) {
        Connect connect = new Connect(dm, url, retryTime);
        Future<Boolean> task = service.submit(connect);
        try {
            return task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, null, ex);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException ex) {
            task.cancel(true);
        }
        return false;
    }

    private static class Connect
    implements Callable<Boolean> {
        private final WLDeploymentManager dm;
        private final URL url;
        private final int retryTime;
        private final String host;

        public Connect(WLDeploymentManager dm, URL url, int retryTime) {
            this.dm = dm;
            this.url = url;
            this.retryTime = retryTime;
            this.host = url.getHost();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                InetAddress.getByName(this.host);
            }
            catch (UnknownHostException e) {
                return Boolean.FALSE;
            }
            boolean interrupted = false;
            HttpURLConnection con = null;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (this.dm.isProxyMisconfigured()) {
                        con = (HttpURLConnection)this.url.openConnection(Proxy.NO_PROXY);
                    } else {
                        WebLogicTrustHandler handler;
                        con = (HttpURLConnection)this.url.openConnection();
                        if (con instanceof HttpsURLConnection && (handler = (WebLogicTrustHandler)Lookup.getDefault().lookup(WebLogicTrustHandler.class)) != null) {
                            SSLContext context = SSLContext.getInstance("TLS");
                            context.init(null, new TrustManager[]{handler.getTrustManager(this.dm.getCommonConfiguration())}, new SecureRandom());
                            ((HttpsURLConnection)con).setSSLSocketFactory(context.getSocketFactory());
                            ((HttpsURLConnection)con).setHostnameVerifier(EMPTY_VERIFIER);
                        }
                    }
                    int code = con.getResponseCode();
                    if (code == 502) {
                        this.dm.setProxyMisconfigured(true);
                    } else {
                        boolean error;
                        boolean bl = error = code == -1 || code > 399 && code < 600 && code != 403;
                        if (!error) {
                            Boolean bl2 = Boolean.TRUE;
                            return bl2;
                        }
                    }
                }
                catch (IOException ioe) {
                    if (ioe.getMessage() != null && ioe.getMessage().contains(Integer.toString(502))) {
                        this.dm.setProxyMisconfigured(true);
                    } else {
                        this.dm.setProxyMisconfigured(false);
                    }
                    LOGGER.log(Level.FINE, null, ioe);
                }
                finally {
                    if (con != null) {
                        con.disconnect();
                    }
                }
                try {
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                    break;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return Boolean.FALSE;
        }
    }
}

