/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.api.RecentProjects;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.netbeans.modules.welcome.content.ActionButton;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class RecentProjectsPanel
extends JPanel
implements Constants,
Runnable {
    private static final int MAX_PROJECTS = 10;
    private PropertyChangeListener changeListener;
    private static final RequestProcessor RP = new RequestProcessor("RecentProjects");

    public RecentProjectsPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.removeAll();
        this.add((Component)this.startBuildingContent(), "Center");
        RecentProjects.getDefault().addPropertyChangeListener(this.getPropertyChangeListener());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        RecentProjects.getDefault().removePropertyChangeListener(this.getPropertyChangeListener());
    }

    private PropertyChangeListener getPropertyChangeListener() {
        if (null == this.changeListener) {
            this.changeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if ("RecentProjectInformation".equals(e.getPropertyName())) {
                        SwingUtilities.invokeLater(RecentProjectsPanel.this);
                    }
                }
            };
        }
        return this.changeListener;
    }

    @Override
    public void run() {
        this.removeAll();
        this.add((Component)this.rebuildContent(RecentProjects.getDefault().getRecentProjectInformation()), "Center");
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private JPanel startBuildingContent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JLabel lbl = new JLabel(BundleSupport.getLabel("LoadingProjects"));
        lbl.setHorizontalAlignment(0);
        panel.add((Component)lbl, "Center");
        this.loadProjects();
        return panel;
    }

    private void loadProjects() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                ArrayList projects = new ArrayList(RecentProjects.getDefault().getRecentProjectInformation());
                final ArrayList<UnloadedProjectInformation> existingProjects = new ArrayList<UnloadedProjectInformation>(projects.size());
                for (UnloadedProjectInformation p : projects) {
                    try {
                        File projectDir = Utilities.toFile((URI)p.getURL().toURI());
                        if (!projectDir.exists() || !projectDir.isDirectory()) continue;
                        existingProjects.add(p);
                        if (existingProjects.size() < 10) continue;
                        break;
                    }
                    catch (Exception e) {
                        Logger.getLogger(RecentProjectsPanel.class.getName()).log(Level.FINER, null, e);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RecentProjectsPanel.this.removeAll();
                        RecentProjectsPanel.this.add((Component)RecentProjectsPanel.this.rebuildContent(existingProjects), "Center");
                        RecentProjectsPanel.this.invalidate();
                        RecentProjectsPanel.this.revalidate();
                        RecentProjectsPanel.this.repaint();
                    }
                });
            }
        });
    }

    private JPanel rebuildContent(List<UnloadedProjectInformation> projects) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int row = 0;
        for (UnloadedProjectInformation p : projects) {
            this.addProject(panel, row++, p);
            if (row < 10) continue;
            break;
        }
        if (0 == row) {
            panel.add((Component)new JLabel(BundleSupport.getLabel("NoRecentProject")), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        } else {
            panel.add((Component)new JLabel(), new GridBagConstraints(0, row, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    private void addProject(JPanel panel, int row, UnloadedProjectInformation project) {
        OpenProjectAction action = new OpenProjectAction(project);
        ActionButton b = new ActionButton(action, project.getURL().toString(), false, "RecentProject");
        b.setFont(BUTTON_FONT);
        b.getAccessibleContext().setAccessibleName(b.getText());
        b.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("RecentProject", b.getText()));
        b.setIcon(project.getIcon());
        panel.add((Component)b, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private class OpenProjectAction
    extends AbstractAction {
        private final UnloadedProjectInformation project;

        public OpenProjectAction(UnloadedProjectInformation project) {
            super(project.getDisplayName(), project.getIcon());
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    URL url = OpenProjectAction.this.project.getURL();
                    Project prj = null;
                    FileObject dir = URLMapper.findFileObject((URL)url);
                    if (dir != null && dir.isFolder()) {
                        try {
                            prj = ProjectManager.getDefault().findProject(dir);
                        }
                        catch (IOException ioEx) {
                            // empty catch block
                        }
                    }
                    if (prj != null) {
                        OpenProjects.getDefault().open(new Project[]{prj}, false, true);
                    } else {
                        String msg = BundleSupport.getMessage("ERR_InvalidProject", OpenProjectAction.this.project.getDisplayName());
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        RecentProjectsPanel.this.startBuildingContent();
                    }
                }
            };
            ProgressUtils.runOffEventDispatchThread((Runnable)r, (String)BundleSupport.getLabel("OPEN_RECENT_PROJECT"), (AtomicBoolean)new AtomicBoolean(false), (boolean)false);
        }
    }
}

