/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.coverage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.atoum.coverage.CoverageImpl;
import org.netbeans.modules.php.atoum.coverage.FileMetricsImpl;
import org.netbeans.modules.php.spi.testing.coverage.Coverage;
import org.netbeans.modules.php.spi.testing.coverage.FileMetrics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class CloverLogParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(CloverLogParser.class.getName());
    final XMLReader xmlReader;
    final List<Coverage.File> files = new ArrayList<Coverage.File>();
    private boolean inFile = false;
    private String filePath;
    private FileMetrics fileMetrics;
    private List<Coverage.Line> lines;

    private CloverLogParser() throws SAXException {
        this.xmlReader = FileUtils.createXmlReader();
    }

    private static CloverLogParser create() throws SAXException {
        CloverLogParser parser = new CloverLogParser();
        parser.xmlReader.setContentHandler(parser);
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static List<Coverage.File> parse(Reader reader) {
        try {
            CloverLogParser parser = CloverLogParser.create();
            parser.xmlReader.parse(new InputSource(reader));
            List<Coverage.File> list = Collections.unmodifiableList(parser.files);
            return list;
        }
        catch (SAXException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("file".equals(qName)) {
            this.processFileStart(attributes);
        } else if ("class".equals(qName)) {
            this.processClassStart();
        } else if ("metrics".equals(qName)) {
            this.processMetricsStart(attributes);
        } else if ("line".equals(qName)) {
            this.processLine(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("file".equals(qName)) {
            this.processFileEnd();
        } else if ("class".equals(qName)) {
            this.processClassEnd();
        }
    }

    private void processFileStart(Attributes attributes) {
        assert (!this.inFile);
        assert (this.filePath == null) : this.filePath;
        assert (this.fileMetrics == null) : this.fileMetrics;
        assert (this.lines == null) : this.lines;
        this.inFile = true;
        this.filePath = this.getPath(attributes);
        this.lines = new ArrayList<Coverage.Line>();
    }

    private void processClassStart() {
        assert (this.inFile);
        this.inFile = false;
    }

    private void processMetricsStart(Attributes attributes) {
        if (!this.inFile) {
            return;
        }
        assert (this.filePath != null);
        this.fileMetrics = new FileMetricsImpl(this.getLineCount(this.filePath), this.getStatements(attributes), this.getCoveredStatements(attributes));
    }

    private void processFileEnd() {
        assert (this.inFile);
        assert (this.filePath != null);
        assert (this.fileMetrics != null);
        this.inFile = false;
        this.files.add(new CoverageImpl.FileImpl(this.filePath, this.fileMetrics, this.lines));
        this.filePath = null;
        this.fileMetrics = null;
        this.lines = null;
    }

    private void processClassEnd() {
        assert (!this.inFile);
        this.inFile = true;
    }

    private void processLine(Attributes attributes) {
        if (!this.inFile) {
            return;
        }
        assert (this.filePath != null) : attributes;
        assert (this.lines != null) : this.filePath;
        int number = this.getNum(attributes);
        int hits = this.getCount(attributes);
        if (number == -1 || hits == -1) {
            LOGGER.log(Level.INFO, "Unexpected line number or hits [{0}]", attributes);
            return;
        }
        this.lines.add(new CoverageImpl.LineImpl(number, hits));
    }

    private String getPath(Attributes attributes) {
        return attributes.getValue("path");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getLineCount(String filePath) {
        File file = new File(filePath);
        assert (file.isFile()) : file;
        FileObject fo = FileUtil.toFileObject((File)file);
        assert (fo != null) : file;
        try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), FileEncodingQuery.getEncoding((FileObject)fo)));){
            while (lineNumberReader.readLine() != null) {
            }
            int n = lineNumberReader.getLineNumber();
            return n;
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, null, exc);
            return -1;
        }
    }

    private int getStatements(Attributes attributes) {
        return this.getInt(attributes, "statements");
    }

    private int getCoveredStatements(Attributes attributes) {
        return this.getInt(attributes, "coveredstatements");
    }

    private int getNum(Attributes attributes) {
        return this.getInt(attributes, "num");
    }

    private int getCount(Attributes attributes) {
        return this.getInt(attributes, "count");
    }

    private int getInt(Attributes attributes, String name) {
        int i = -1;
        try {
            i = Integer.parseInt(attributes.getValue(name));
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        return i;
    }
}

