/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.util.Map;
import org.clang.basic.LangOptions;
import org.clang.basic.vfs.FileSystem;
import org.clang.frontend.CompilerInvocation;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.lex.HeaderSearchOptions;
import org.clang.lex.PreprocessorOptions;
import org.clang.lex.frontend;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.impl.PreprocessorInitializer;
import org.clang.tools.services.support.ClangFileSystemProvider;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.StringRef;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.raw_ostream;

public class AdvancedPreprocessorInitializer
extends PreprocessorInitializer {
    private final ClankCompilationDataBase.Entry compileEntry;
    private final boolean TRACE = false;
    private final Map<String, MemoryBuffer> remappedBuffers;

    public AdvancedPreprocessorInitializer(ClankCompilationDataBase.Entry entry, String triple, raw_ostream llvm_err, Map<String, MemoryBuffer> remappedBuffers) {
        super(llvm_err, triple, AdvancedPreprocessorInitializer.getFileSystem(entry));
        this.compileEntry = entry;
        this.remappedBuffers = remappedBuffers;
    }

    private static IntrusiveRefCntPtr<FileSystem> getFileSystem(ClankCompilationDataBase.Entry entry) {
        IntrusiveRefCntPtr<FileSystem> pfs = ClangFileSystemProvider.getFileSystem(entry);
        return pfs;
    }

    @Override
    protected LangOptions createLangOptions() {
        LangOptions opts = super.createLangOptions();
        CompilerInvocation.setLangDefaults((LangOptions)opts, (InputKind)this.compileEntry.getLanguage(), (LangStandard.Kind)this.compileEntry.getLangStandard());
        return opts;
    }

    @Override
    protected HeaderSearchOptions createHeaderSearchOptions() {
        HeaderSearchOptions options = super.createHeaderSearchOptions();
        for (CharSequence Path : this.compileEntry.getUserIncludePaths()) {
            options.AddPath(new StringRef(Path), frontend.IncludeDirGroup.Angled, false, true);
        }
        for (CharSequence Path : this.compileEntry.getPredefinedSystemIncludePaths()) {
            options.AddPath(new StringRef(Path), frontend.IncludeDirGroup.System, false, true);
            options.AddSystemHeaderPrefix(new StringRef(Path), true);
        }
        return options;
    }

    @Override
    protected PreprocessorOptions createPreprocessorOptions() {
        PreprocessorOptions out = super.createPreprocessorOptions();
        for (CharSequence charSequence : this.compileEntry.getIncludeFiles()) {
            out.Includes.push_back(charSequence);
        }
        for (String string2 : this.compileEntry.getSystemMacroDefines()) {
            out.addMacroDef(new StringRef((CharSequence)string2));
        }
        for (String string3 : this.compileEntry.getUserMacroDefines()) {
            out.addMacroDef(new StringRef((CharSequence)string3));
        }
        if (this.remappedBuffers != null && !this.remappedBuffers.isEmpty()) {
            out.RetainRemappedFileBuffers = true;
            for (Map.Entry entry : this.remappedBuffers.entrySet()) {
                out.addRemappedFile(new StringRef((CharSequence)entry.getKey()), (MemoryBuffer)entry.getValue());
            }
        }
        return out;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }
}

