/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.clang.basic.DiagnosticsEngine;
import org.clang.frontend.FrontendOptions;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.ClankProgressHandler;
import org.clang.tools.services.impl.CompilationDBFromDumpedEntries;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.support.raw_ostream;

public final class ClangUtilities {
    private static final Pattern variable = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private static final ClankProgressHandler NO_OP_PROGRESS = new ClankProgressHandler(){

        @Override
        public void setDisplayName(String newDisplayName) {
        }

        @Override
        public void start(int workunits, long estimate) {
        }

        @Override
        public void switchToIndeterminate() {
        }

        @Override
        public void switchToDeterminate(int workunits, long estimate) {
        }

        @Override
        public void progress(String message, int workunit) {
        }
    };

    private ClangUtilities() {
    }

    public static CharSequence getFirstCompiledPath(ClankCompilationDataBase.Entry entry) {
        Collection<CharSequence> TUs = entry.getCompiledFiles();
        Iterator<CharSequence> iterator2 = TUs.iterator();
        if (iterator2.hasNext()) {
            CharSequence TU = iterator2.next();
            return TU;
        }
        return "";
    }

    public static void DumpEntry(ClankCompilationDataBase.Entry compileEntry, raw_ostream out) {
        CompilationDBFromDumpedEntries.DumpEntry(compileEntry, out);
    }

    public static ClankProgressHandler EmptyProgress() {
        return NO_OP_PROGRESS;
    }

    public static ClankProgressHandler createProgress(raw_ostream out) {
        return new ClankOSProgressHandler(out);
    }

    public static Level toLoggerLevel(DiagnosticsEngine.Level DiagLevel) {
        switch (DiagLevel) {
            case Ignored: 
            case Note: {
                return Level.INFO;
            }
            case Warning: {
                return Level.WARNING;
            }
            case Error: 
            case Fatal: {
                return Level.SEVERE;
            }
        }
        throw new AssertionError((Object)DiagLevel.name());
    }

    public static LangStandard.Kind getLangStandard(String param) {
        LangStandard.Kind LangStd = (LangStandard.Kind)new StringSwitch(new StringRef((CharSequence)param)).Case((CharSequence)"c89", (Object)LangStandard.Kind.lang_c89).Case((CharSequence)"c90", (Object)LangStandard.Kind.lang_c90).Case((CharSequence)"iso9899:1990", (Object)LangStandard.Kind.lang_iso9899_1990).Case((CharSequence)"iso9899:199409", (Object)LangStandard.Kind.lang_c94).Case((CharSequence)"gnu89", (Object)LangStandard.Kind.lang_gnu89).Case((CharSequence)"gnu90", (Object)LangStandard.Kind.lang_gnu90).Case((CharSequence)"c99", (Object)LangStandard.Kind.lang_c99).Case((CharSequence)"c9x", (Object)LangStandard.Kind.lang_c9x).Case((CharSequence)"iso9899:1999", (Object)LangStandard.Kind.lang_iso9899_1999).Case((CharSequence)"iso9899:199x", (Object)LangStandard.Kind.lang_iso9899_199x).Case((CharSequence)"gnu99", (Object)LangStandard.Kind.lang_gnu99).Case((CharSequence)"gnu9x", (Object)LangStandard.Kind.lang_gnu9x).Case((CharSequence)"c11", (Object)LangStandard.Kind.lang_c11).Case((CharSequence)"c1x", (Object)LangStandard.Kind.lang_c1x).Case((CharSequence)"iso9899:2011", (Object)LangStandard.Kind.lang_iso9899_2011).Case((CharSequence)"iso9899:2011", (Object)LangStandard.Kind.lang_iso9899_201x).Case((CharSequence)"gnu11", (Object)LangStandard.Kind.lang_gnu11).Case((CharSequence)"gnu1x", (Object)LangStandard.Kind.lang_gnu1x).Case((CharSequence)"c++98", (Object)LangStandard.Kind.lang_cxx98).Case((CharSequence)"c++03", (Object)LangStandard.Kind.lang_cxx03).Case((CharSequence)"gnu++98", (Object)LangStandard.Kind.lang_gnucxx98).Case((CharSequence)"c++0x", (Object)LangStandard.Kind.lang_cxx0x).Case((CharSequence)"c++11", (Object)LangStandard.Kind.lang_cxx11).Case((CharSequence)"gnu++0x", (Object)LangStandard.Kind.lang_gnucxx0x).Case((CharSequence)"gnu++11", (Object)LangStandard.Kind.lang_gnucxx11).Case((CharSequence)"c++1y", (Object)LangStandard.Kind.lang_cxx1y).Case((CharSequence)"gnu++1y", (Object)LangStandard.Kind.lang_gnucxx1y).Case((CharSequence)"cl", (Object)LangStandard.Kind.lang_opencl).Case((CharSequence)"CL1.1", (Object)LangStandard.Kind.lang_opencl11).Case((CharSequence)"CL1.2", (Object)LangStandard.Kind.lang_opencl12).Case((CharSequence)"cuda", (Object)LangStandard.Kind.lang_cuda).Default((Object)LangStandard.Kind.lang_unspecified);
        return LangStd;
    }

    public static InputKind getInputKind(String param, String intputFile) {
        InputKind DashX = InputKind.IK_None;
        DashX = (InputKind)new StringSwitch(new StringRef((CharSequence)param)).Case((CharSequence)"c", (Object)InputKind.IK_C).Case((CharSequence)"cl", (Object)InputKind.IK_OpenCL).Case((CharSequence)"cuda", (Object)InputKind.IK_CUDA).Case((CharSequence)"c++", (Object)InputKind.IK_CXX).Case((CharSequence)"objective-c", (Object)InputKind.IK_ObjC).Case((CharSequence)"objective-c++", (Object)InputKind.IK_ObjCXX).Case((CharSequence)"cpp-output", (Object)InputKind.IK_PreprocessedC).Case((CharSequence)"assembler-with-cpp", (Object)InputKind.IK_Asm).Case((CharSequence)"c++-cpp-output", (Object)InputKind.IK_PreprocessedCXX).Case((CharSequence)"objective-c-cpp-output", (Object)InputKind.IK_PreprocessedObjC).Case((CharSequence)"objc-cpp-output", (Object)InputKind.IK_PreprocessedObjC).Case((CharSequence)"objective-c++-cpp-output", (Object)InputKind.IK_PreprocessedObjCXX).Case((CharSequence)"objc++-cpp-output", (Object)InputKind.IK_PreprocessedObjCXX).Case((CharSequence)"c-header", (Object)InputKind.IK_C).Case((CharSequence)"cl-header", (Object)InputKind.IK_OpenCL).Case((CharSequence)"objective-c-header", (Object)InputKind.IK_ObjC).Case((CharSequence)"c++-header", (Object)InputKind.IK_CXX).Case((CharSequence)"objective-c++-header", (Object)InputKind.IK_ObjCXX).Cases((CharSequence)"ast", (CharSequence)"pcm", (Object)InputKind.IK_AST).Case((CharSequence)"ir", (Object)InputKind.IK_LLVM_IR).Default((Object)InputKind.IK_None);
        if (DashX == InputKind.IK_None) {
            DashX = FrontendOptions.getInputKindForExtension((StringRef)((StringRef)new StringRef((CharSequence)intputFile).rsplit((byte)NativePointer.$((char)'.')).second));
        }
        return DashX;
    }

    public static String substituteEnvironmentVariables(String from) {
        return ClangUtilities.substituteEnvironmentVariables(from, System.getenv(), null);
    }

    public static String substituteEnvironmentVariables(String str, Map<String, String> variables, Map<String, String> usedVariables) {
        if (usedVariables == null) {
            usedVariables = new HashMap<String, String>();
        } else {
            usedVariables.clear();
        }
        Matcher matcher = variable.matcher(str);
        int start = 0;
        while (matcher.find(start)) {
            String property = variables.get(matcher.group(1));
            if (property != null) {
                usedVariables.put(matcher.group(), property);
            }
            start = matcher.end();
        }
        for (String key : usedVariables.keySet()) {
            str = str.replace(key, usedVariables.get(key));
        }
        return str;
    }

    private static final class ClankOSProgressHandler
    implements ClankProgressHandler {
        private final raw_ostream out;

        public ClankOSProgressHandler(raw_ostream out) {
            this.out = out;
        }

        @Override
        public void setDisplayName(String newDisplayName) {
            this.out.$out((CharSequence)newDisplayName).$out('\n').flush();
        }

        @Override
        public void start(int workunits, long estimate) {
            this.out.$out((CharSequence)"Started to proceed ").$out(workunits).$out((CharSequence)" work units\n").flush();
        }

        @Override
        public void switchToIndeterminate() {
        }

        @Override
        public void switchToDeterminate(int workunits, long estimate) {
            this.out.$out((CharSequence)"Going to proceed ").$out(workunits).$out((CharSequence)" work units\n").flush();
        }

        @Override
        public void progress(String message, int workunit) {
            this.out.$out((CharSequence)message).$out('\n').flush();
        }
    }

    public static class ClankProgressHandlerChain
    implements ClankProgressHandler {
        private final ClankProgressHandler next;

        public ClankProgressHandlerChain(ClankProgressHandler next) {
            this.next = next;
        }

        @Override
        public void setDisplayName(String newDisplayName) {
            this.next.setDisplayName(newDisplayName);
        }

        @Override
        public void start(int workunits, long estimate) {
            this.next.start(workunits, estimate);
        }

        @Override
        public void switchToIndeterminate() {
            this.next.switchToIndeterminate();
        }

        @Override
        public void switchToDeterminate(int workunits, long estimate) {
            this.next.switchToDeterminate(workunits, estimate);
        }

        @Override
        public void progress(String message, int workunit) {
            this.next.progress(message, workunit);
        }
    }
}

