/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.web.common.api.Bundle;
import org.netbeans.modules.web.common.api.ExternalExecutableValidator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public final class ExternalExecutable {
    private static final Logger LOGGER = Logger.getLogger(ExternalExecutable.class.getName());
    public static final ExecutionDescriptor DEFAULT_EXECUTION_DESCRIPTOR = new ExecutionDescriptor().controllable(true).frontWindow(true).frontWindowOnError(true).inputVisible(true).showProgress(true).charset(StandardCharsets.UTF_8);
    private final String executable;
    private final List<String> parameters;
    private final String command;
    final List<String> fullCommand = new CopyOnWriteArrayList<String>();
    private String executableName = null;
    private String displayName = null;
    private String optionsPath = null;
    private boolean redirectErrorStream = true;
    private File workDir = null;
    private boolean warnUser = true;
    private List<String> additionalParameters = Collections.emptyList();
    private Map<String, String> environmentVariables = Collections.emptyMap();
    private File fileOutput = null;
    private boolean fileOutputOnly = false;
    private boolean noInfo = false;
    private boolean noOutput = false;

    public ExternalExecutable(String command) {
        Pair<String, List<String>> parsedCommand = ExternalExecutable.parseCommand(command);
        this.executable = (String)parsedCommand.first();
        this.parameters = (List)parsedCommand.second();
        this.command = command.trim();
    }

    static Pair<String, List<String>> parseCommand(String command) {
        String[] tokens;
        if (command == null) {
            command = "";
        }
        if ((tokens = command.split(" * (?=\\-|/)", 2)).length == 1) {
            LOGGER.log(Level.FINE, "Only program given (no parameters): {0}", command);
            return Pair.of((Object)tokens[0].trim(), Collections.emptyList());
        }
        Pair parsedCommand = Pair.of((Object)tokens[0].trim(), Arrays.asList(Utilities.parseParameters((String)tokens[1].trim())));
        LOGGER.log(Level.FINE, "Parameters parsed: {0} {1}", new Object[]{parsedCommand.first(), parsedCommand.second()});
        return parsedCommand;
    }

    public String getExecutable() {
        return this.executable;
    }

    public List<String> getParameters() {
        return new ArrayList<String>(this.parameters);
    }

    public String getCommand() {
        return this.command;
    }

    public ExternalExecutable executableName(@NonNull String executableName) {
        Parameters.notEmpty((CharSequence)"executableName", (CharSequence)executableName);
        this.executableName = executableName;
        return this;
    }

    public ExternalExecutable displayName(String displayName) {
        Parameters.notEmpty((CharSequence)"displayName", (CharSequence)displayName);
        this.displayName = displayName;
        return this;
    }

    public ExternalExecutable optionsPath(String optionsPath) {
        Parameters.notEmpty((CharSequence)"optionsPath", (CharSequence)optionsPath);
        this.optionsPath = optionsPath;
        return this;
    }

    public ExternalExecutable redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public ExternalExecutable workDir(@NonNull File workDir) {
        Parameters.notNull((CharSequence)"workDir", (Object)workDir);
        this.workDir = workDir;
        return this;
    }

    public ExternalExecutable warnUser(boolean warnUser) {
        this.warnUser = warnUser;
        return this;
    }

    public ExternalExecutable additionalParameters(@NonNull List<String> additionalParameters) {
        Parameters.notNull((CharSequence)"additionalParameters", additionalParameters);
        this.additionalParameters = additionalParameters;
        return this;
    }

    public ExternalExecutable environmentVariables(Map<String, String> environmentVariables) {
        Parameters.notNull((CharSequence)"environmentVariables", environmentVariables);
        this.environmentVariables = environmentVariables;
        return this;
    }

    public ExternalExecutable fileOutput(@NonNull File fileOutput, boolean fileOutputOnly) {
        Parameters.notNull((CharSequence)"fileOutput", (Object)fileOutput);
        this.fileOutput = fileOutput;
        this.fileOutputOnly = fileOutputOnly;
        return this;
    }

    public ExternalExecutable noInfo(boolean noInfo) {
        this.noInfo = noInfo;
        return this;
    }

    public ExternalExecutable noOutput(boolean noOutput) {
        this.noOutput = noOutput;
        return this;
    }

    @CheckForNull
    public Future<Integer> run() {
        return this.run(DEFAULT_EXECUTION_DESCRIPTOR);
    }

    @CheckForNull
    public Future<Integer> run(@NonNull ExecutionDescriptor executionDescriptor) {
        return this.run(executionDescriptor, null);
    }

    @CheckForNull
    public Future<Integer> run(@NonNull ExecutionDescriptor executionDescriptor, @NullAllowed ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory) {
        Parameters.notNull((CharSequence)"executionDescriptor", (Object)executionDescriptor);
        return this.runInternal(executionDescriptor, outProcessorFactory);
    }

    @CheckForNull
    public Integer runAndWait(@NonNull String progressMessage) throws ExecutionException {
        return this.runAndWait(DEFAULT_EXECUTION_DESCRIPTOR, progressMessage);
    }

    @CheckForNull
    public Integer runAndWait(@NonNull ExecutionDescriptor executionDescriptor, @NonNull String progressMessage) throws ExecutionException {
        return this.runAndWait(executionDescriptor, null, progressMessage);
    }

    @CheckForNull
    public Integer runAndWait(@NonNull ExecutionDescriptor executionDescriptor, @NullAllowed ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory, @NonNull String progressMessage) throws ExecutionException {
        Parameters.notNull((CharSequence)"progressMessage", (Object)progressMessage);
        final Future<Integer> result = this.run(executionDescriptor, outProcessorFactory);
        if (result == null) {
            return null;
        }
        final AtomicReference executionException = new AtomicReference();
        if (SwingUtilities.isEventDispatchThread() && !result.isDone()) {
            try {
                ExternalExecutable.getResult(result, 90L);
            }
            catch (TimeoutException ex) {
                BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExternalExecutable.getResult(result);
                        }
                        catch (ExecutionException extEx) {
                            executionException.set(extEx);
                        }
                    }
                }, (String)progressMessage);
            }
        }
        if (executionException.get() != null) {
            throw (ExecutionException)executionException.get();
        }
        return ExternalExecutable.getResult(result);
    }

    @CheckForNull
    private Future<Integer> runInternal(ExecutionDescriptor executionDescriptor, ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory) {
        Parameters.notNull((CharSequence)"executionDescriptor", (Object)executionDescriptor);
        final String error = ExternalExecutableValidator.validateCommand(this.executable, this.executableName);
        if (error != null) {
            if (this.warnUser) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)error, 0));
                        if (ExternalExecutable.this.optionsPath != null) {
                            OptionsDisplayer.getDefault().open(ExternalExecutable.this.optionsPath);
                        }
                    }
                });
            }
            return null;
        }
        ProcessBuilder processBuilder = this.getProcessBuilder();
        executionDescriptor = this.getExecutionDescriptor(executionDescriptor, outProcessorFactory);
        return ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)this.getDisplayName()).run();
    }

    private ProcessBuilder getProcessBuilder() {
        ProcessBuilder processBuilder = this.createProcessBuilder();
        ArrayList<String> arguments = new ArrayList<String>();
        for (String string : this.parameters) {
            this.fullCommand.add(string);
            arguments.add(string);
        }
        for (String string : this.additionalParameters) {
            this.fullCommand.add(string);
            arguments.add(string);
        }
        processBuilder.setArguments(arguments);
        if (this.workDir != null) {
            processBuilder.setWorkingDirectory(this.workDir.getAbsolutePath());
        }
        for (Map.Entry entry : this.environmentVariables.entrySet()) {
            processBuilder.getEnvironment().setVariable((String)entry.getKey(), (String)entry.getValue());
        }
        processBuilder.setRedirectErrorStream(this.redirectErrorStream);
        return processBuilder;
    }

    private ProcessBuilder createProcessBuilder() {
        this.fullCommand.clear();
        this.fullCommand.add(this.executable);
        ProcessBuilder processBuilder = ProcessBuilder.getLocal();
        processBuilder.setExecutable(this.executable);
        return processBuilder;
    }

    private String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName();
    }

    private String getDefaultDisplayName() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(this.executable);
        for (String param : this.parameters) {
            buffer.append(" ");
            buffer.append(param);
        }
        return buffer.toString();
    }

    static Integer getResult(Future<Integer> result) throws ExecutionException {
        try {
            return ExternalExecutable.getResult(result, null);
        }
        catch (TimeoutException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    private static Integer getResult(Future<Integer> result, Long timeout) throws TimeoutException, ExecutionException {
        try {
            if (timeout != null) {
                return result.get(timeout, TimeUnit.MILLISECONDS);
            }
            return result.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private ExecutionDescriptor getExecutionDescriptor(ExecutionDescriptor executionDescriptor, ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory) {
        ExecutionDescriptor.InputProcessorFactory2 fileOutProcessorFactory;
        ExecutionDescriptor.InputProcessorFactory2 outputOutProcessorFactory;
        final CopyOnWriteArrayList<ExecutionDescriptor.InputProcessorFactory2> inputProcessors = new CopyOnWriteArrayList<ExecutionDescriptor.InputProcessorFactory2>();
        ExecutionDescriptor.InputProcessorFactory2 infoOutProcessorFactory = this.getInfoOutputProcessorFactory();
        if (infoOutProcessorFactory != null) {
            inputProcessors.add(infoOutProcessorFactory);
        }
        if ((outputOutProcessorFactory = this.getOutputProcessorFactory()) != null) {
            inputProcessors.add(outputOutProcessorFactory);
        }
        if ((fileOutProcessorFactory = this.getFileOutputProcessorFactory()) != null) {
            inputProcessors.add(fileOutProcessorFactory);
            if (this.fileOutputOnly) {
                executionDescriptor = executionDescriptor.inputOutput(InputOutput.NULL).frontWindow(false).frontWindowOnError(false);
            }
        }
        if (outProcessorFactory != null) {
            inputProcessors.add(outProcessorFactory);
        }
        if (!inputProcessors.isEmpty()) {
            executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory2(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    InputProcessor[] processors = new InputProcessor[inputProcessors.size()];
                    for (int i = 0; i < inputProcessors.size(); ++i) {
                        processors[i] = ((ExecutionDescriptor.InputProcessorFactory2)inputProcessors.get(i)).newInputProcessor(defaultProcessor);
                    }
                    return InputProcessors.proxy((InputProcessor[])processors);
                }
            });
        }
        return executionDescriptor;
    }

    private ExecutionDescriptor.InputProcessorFactory2 getInfoOutputProcessorFactory() {
        if (this.noInfo) {
            return null;
        }
        return new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return new InfoInputProcessor(defaultProcessor, ExternalExecutable.this.fullCommand);
            }
        };
    }

    private ExecutionDescriptor.InputProcessorFactory2 getOutputProcessorFactory() {
        if (this.noOutput) {
            return null;
        }
        return new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return defaultProcessor;
            }
        };
    }

    private ExecutionDescriptor.InputProcessorFactory2 getFileOutputProcessorFactory() {
        if (this.fileOutput == null) {
            return null;
        }
        return new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return new RedirectOutputProcessor(ExternalExecutable.this.fileOutput);
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [executable: ");
        sb.append(this.executable);
        sb.append(", parameters: ");
        sb.append(this.parameters);
        sb.append("]");
        return sb.toString();
    }

    static final class RedirectOutputProcessor
    implements InputProcessor {
        private final File fileOuput;
        private OutputStream outputStream;

        public RedirectOutputProcessor(File fileOuput) {
            this.fileOuput = fileOuput;
        }

        public void processInput(char[] chars) throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.fileOuput));
            }
            for (char c : chars) {
                this.outputStream.write((byte)c);
            }
        }

        public void reset() {
        }

        public void close() throws IOException {
            this.outputStream.close();
        }
    }

    static final class InfoInputProcessor
    implements InputProcessor {
        private final InputProcessor defaultProcessor;
        private char lastChar;

        public InfoInputProcessor(InputProcessor defaultProcessor, List<String> fullCommand) {
            this.defaultProcessor = defaultProcessor;
            String infoCommand = InfoInputProcessor.colorize(InfoInputProcessor.getInfoCommand(fullCommand)) + "\n";
            try {
                defaultProcessor.processInput(infoCommand.toCharArray());
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }

        public void processInput(char[] chars) throws IOException {
            if (chars.length > 0) {
                this.lastChar = chars[chars.length - 1];
            }
        }

        public void reset() throws IOException {
        }

        public void close() throws IOException {
            StringBuilder msg = new StringBuilder(Bundle.InfoInputProcessor_done().length() + 2);
            if (!InfoInputProcessor.isNewLine(this.lastChar)) {
                msg.append("\n");
            }
            msg.append(InfoInputProcessor.colorize(Bundle.InfoInputProcessor_done()));
            msg.append("\n");
            this.defaultProcessor.processInput(msg.toString().toCharArray());
        }

        public static String getInfoCommand(List<String> fullCommand) {
            ArrayList<String> escapedCommand = new ArrayList<String>(fullCommand.size());
            for (String command : fullCommand) {
                escapedCommand.add("\"" + command.replace("\"", "\\\"") + "\"");
            }
            return InfoInputProcessor.implode(escapedCommand, " ");
        }

        private static String colorize(String msg) {
            return "\u001b[1;30m" + msg + "\u001b[0m";
        }

        private static boolean isNewLine(char ch) {
            return ch == '\n' || ch == '\r' || ch == '\u0000';
        }

        private static String implode(List<String> items, String delimiter) {
            if (items.isEmpty()) {
                return "";
            }
            StringBuilder buffer = new StringBuilder(200);
            boolean first = true;
            for (String s : items) {
                if (!first) {
                    buffer.append(delimiter);
                }
                buffer.append(s);
                first = false;
            }
            return buffer.toString();
        }
    }
}

