/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.modules.web.browser.api.ResizeOption;
import org.netbeans.modules.web.browser.api.ResizeOptions;
import org.netbeans.modules.web.browser.spi.Resizable;
import org.netbeans.modules.web.browser.spi.Zoomable;
import org.netbeans.modules.web.browser.ui.BrowserResizeButton;
import org.netbeans.modules.web.browser.ui.ResizeOptionsCustomizer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DeveloperToolbar {
    private final JPanel panel;
    private Lookup context;
    private ResizeOption currentSize = ResizeOption.SIZE_TO_FIT;
    private final JToolBar resizeBar;
    private final ArrayList<BrowserResizeButton> resizeButtons;
    private final JToggleButton btnResizeMenu;
    private final ItemListener resizeListener;
    private boolean ignoreSelectionChanges;
    private final JComboBox comboZoom = new JComboBox();
    private JToolBar customToolbar;
    private final ContainerListener toolbarListener;

    private DeveloperToolbar() {
        this.panel = new JPanel(new FlowLayout(0));
        this.panel.setOpaque(false);
        this.resizeBar = new JToolBar();
        this.resizeBar.setFloatable(false);
        this.resizeBar.setFocusable(false);
        this.panel.add(this.resizeBar);
        this.resizeButtons = new ArrayList(15);
        this.resizeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (DeveloperToolbar.this.ignoreSelectionChanges) {
                    return;
                }
                if (e.getSource() instanceof BrowserResizeButton) {
                    DeveloperToolbar.this.setBrowserSize(((BrowserResizeButton)e.getSource()).getResizeOption());
                }
            }
        };
        this.comboZoom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                String newZoom = DeveloperToolbar.this.zoom(DeveloperToolbar.this.comboZoom.getSelectedItem().toString());
                DeveloperToolbar.this.comboZoom.setSelectedItem(newZoom);
            }
        });
        this.toolbarListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                DeveloperToolbar.this.initActions(DeveloperToolbar.this.customToolbar);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        };
        this.btnResizeMenu = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/browser/ui/resources/menu.png", (boolean)true));
        this.btnResizeMenu.setToolTipText(NbBundle.getMessage(DeveloperToolbar.class, (String)"Tip_ResizeOptions"));
        this.btnResizeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = DeveloperToolbar.this.buildResizePopup();
                popup.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        DeveloperToolbar.this.setBrowserSize(DeveloperToolbar.this.currentSize);
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                        DeveloperToolbar.this.setBrowserSize(DeveloperToolbar.this.currentSize);
                    }
                });
                popup.show(DeveloperToolbar.this.btnResizeMenu, 0, DeveloperToolbar.this.btnResizeMenu.getHeight());
            }
        });
    }

    public static DeveloperToolbar create() {
        return new DeveloperToolbar();
    }

    public Component getComponent() {
        return this.panel;
    }

    public void intialize(Lookup context) {
        this.context = context;
        JToolBar bar = (JToolBar)context.lookup(JToolBar.class);
        if (null == bar) {
            bar = new JToolBar();
        }
        bar.setFloatable(false);
        bar.setFocusable(false);
        bar.setOpaque(false);
        if (null != this.customToolbar) {
            this.panel.remove(this.customToolbar);
        }
        this.panel.add(bar);
        DefaultComboBoxModel<String> zoomModel = new DefaultComboBoxModel<String>();
        zoomModel.addElement("200%");
        zoomModel.addElement("150%");
        zoomModel.addElement("100%");
        zoomModel.addElement("75%");
        zoomModel.addElement("50%");
        this.comboZoom.setModel(zoomModel);
        this.comboZoom.setEditable(true);
        if (this.comboZoom.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextField)this.comboZoom.getEditor().getEditorComponent()).setColumns(4);
        }
        this.comboZoom.setSelectedItem("100%");
        this.comboZoom.setEnabled(null != this.getLookup().lookup(Zoomable.class));
        this.fillResizeBar();
        this.initActions(bar);
        if (null != this.customToolbar) {
            this.customToolbar.removeContainerListener(this.toolbarListener);
        }
        bar.addContainerListener(this.toolbarListener);
        this.customToolbar = bar;
    }

    private Lookup getLookup() {
        return null == this.context ? Lookup.EMPTY : this.context;
    }

    private String zoom(String zoomFactor) {
        if (zoomFactor.trim().isEmpty()) {
            return null;
        }
        Zoomable zoomable = (Zoomable)this.getLookup().lookup(Zoomable.class);
        if (null == zoomable) {
            return null;
        }
        try {
            zoomFactor = zoomFactor.replaceAll("\\%", "");
            zoomFactor = zoomFactor.trim();
            double zoom = Double.parseDouble(zoomFactor);
            zoom = Math.abs(zoom) / 100.0;
            if (zoom <= 0.0) {
                return null;
            }
            zoomable.zoom(zoom);
            return (int)(100.0 * zoom) + "%";
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void fillResizeBar() {
        this.resizeBar.removeAll();
        this.resizeButtons.clear();
        this.resizeBar.setOpaque(false);
        boolean resizingEnabled = null != this.context.lookup(Resizable.class);
        List<ResizeOption> options = ResizeOptions.getDefault().loadAll();
        options.add(ResizeOption.SIZE_TO_FIT);
        for (ResizeOption ro : options) {
            if (!ro.isShowInToolbar()) continue;
            BrowserResizeButton button = BrowserResizeButton.create(ro);
            this.resizeBar.add(button);
            button.setSelected(ro.equals(this.currentSize));
            button.addItemListener(this.resizeListener);
            this.resizeButtons.add(button);
            button.setEnabled(resizingEnabled);
        }
        this.resizeBar.add(this.btnResizeMenu);
        this.resizeBar.add(this.comboZoom);
    }

    private void setBrowserSize(ResizeOption resizeOption) {
        this.ignoreSelectionChanges = true;
        boolean doResize = !resizeOption.equals(this.currentSize);
        this.currentSize = resizeOption;
        boolean isToolbarSelection = false;
        for (BrowserResizeButton b : this.resizeButtons) {
            b.setSelected(b.getResizeOption().equals(resizeOption));
            isToolbarSelection |= b.isSelected();
        }
        this.ignoreSelectionChanges = false;
        this.btnResizeMenu.setSelected(!isToolbarSelection);
        if (isToolbarSelection || null == resizeOption) {
            this.btnResizeMenu.setToolTipText(NbBundle.getMessage(DeveloperToolbar.class, (String)"Tip_ResizeOptions"));
        } else {
            this.btnResizeMenu.setToolTipText(resizeOption.getToolTip());
        }
        if (doResize) {
            this.doResize(resizeOption.getWidth(), resizeOption.getHeight());
        }
    }

    private JPopupMenu buildResizePopup() {
        JPopupMenu res = new JPopupMenu();
        List<ResizeOption> options = ResizeOptions.getDefault().loadAll();
        options.add(ResizeOption.SIZE_TO_FIT);
        Iterator<ResizeOption> i$ = options.iterator();
        while (i$.hasNext()) {
            ResizeOption ro;
            final ResizeOption size = ro = i$.next();
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(ro.getToolTip());
            res.add(menuItem);
            menuItem.setSelected(size.equals(this.currentSize));
            menuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DeveloperToolbar.this.setBrowserSize(size);
                }
            });
            menuItem.setIcon(BrowserResizeButton.toIcon(ro));
        }
        res.addSeparator();
        JMenuItem menu = new JMenuItem(NbBundle.getMessage(DeveloperToolbar.class, (String)"Lbl_CUSTOMIZE"));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResizeOptionsCustomizer customizer = new ResizeOptionsCustomizer();
                if (customizer.showCustomizer()) {
                    List<ResizeOption> newOptions = customizer.getResizeOptions();
                    ResizeOptions.getDefault().saveAll(newOptions);
                    DeveloperToolbar.this.fillResizeBar();
                }
            }
        });
        res.add(menu);
        return res;
    }

    void doResize(int width, int height) {
        Resizable resizable = (Resizable)this.context.lookup(Resizable.class);
        if (null == resizable) {
            return;
        }
        if (width < 0 || height < 0) {
            resizable.autofit();
        } else {
            resizable.resize(width, height);
        }
    }

    private void initActions(JToolBar bar) {
        HtmlBrowserComponent tc = (HtmlBrowserComponent)SwingUtilities.getAncestorOfClass(HtmlBrowserComponent.class, this.panel);
        if (null == tc) {
            return;
        }
        ActionMap am = tc.getActionMap();
        InputMap im = tc.getInputMap(1);
        for (Component c : bar.getComponents()) {
            JToggleButton toggle;
            Object ks;
            if (!(c instanceof AbstractButton)) continue;
            if (c instanceof JToggleButton && (ks = (toggle = (JToggleButton)c).getClientProperty("AcceleratorKey")) instanceof KeyStroke && null != toggle.getName()) {
                KeyStroke key = (KeyStroke)ks;
                im.put(key, toggle.getName());
                am.put(toggle.getName(), new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        toggle.setSelected(!toggle.isSelected());
                    }
                });
                continue;
            }
            AbstractButton button = (AbstractButton)c;
            Action a = button.getAction();
            if (null == a || null == a.getValue("AcceleratorKey") || null == a.getValue("Name")) continue;
            String accelerator = a.getValue("AcceleratorKey").toString();
            Object name = a.getValue("Name");
            am.put(name, a);
            im.put(KeyStroke.getKeyStroke(accelerator), name);
        }
    }
}

