/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.versioning.util.Utils;

public class KeyringSupport {
    private static final Logger LOG = Logger.getLogger("versioning.util.KeyringSupport");
    private static final boolean PRINT_PASSWORDS = "true".equals(System.getProperty("versioning.keyring.logpassword", "false"));
    private static final Set<String> NULL_HASHED_RECORDS = Collections.synchronizedSet(new HashSet());

    public static void save(String keyPrefix, String key, char[] password, String description) {
        String hashedKey = KeyringSupport.getKeyringKeyHashed(keyPrefix, key);
        if (password == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Deleting password for {0}:{1}", new String[]{keyPrefix, key});
            }
            Keyring.delete((String)KeyringSupport.getKeyringKey(keyPrefix, key));
            Keyring.delete((String)hashedKey);
            NULL_HASHED_RECORDS.add(hashedKey);
        } else {
            if (description == null) {
                description = key;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Saving password for {0}:{1}", new String[]{keyPrefix, key});
                if (PRINT_PASSWORDS) {
                    LOG.log(Level.FINEST, "Saving password: \"{0}\"", new String(password));
                }
            }
            Keyring.save((String)KeyringSupport.getKeyringKey(keyPrefix, key), (char[])password, (String)description);
            Keyring.delete((String)hashedKey);
            NULL_HASHED_RECORDS.remove(hashedKey);
        }
    }

    public static char[] read(String keyPrefix, String key) {
        char[] retval = Keyring.read((String)KeyringSupport.getKeyringKey(keyPrefix, key));
        if (retval == null) {
            retval = KeyringSupport.migrateRecord(keyPrefix, key);
        }
        if (LOG.isLoggable(Level.FINE)) {
            if (retval == null) {
                LOG.log(Level.FINE, "No password for {0}:{1}", new String[]{keyPrefix, key});
            } else if (PRINT_PASSWORDS) {
                LOG.log(Level.FINEST, "Getting password: {0}:{1} -- \"{2}\"", new Object[]{keyPrefix, key, new String(retval)});
            }
        }
        return retval;
    }

    static String getKeyringKeyHashed(String keyPrefix, String keyToHash) {
        String keyPart = "";
        if (keyToHash != null) {
            try {
                keyPart = Utils.getHash("SHA-1", keyToHash.getBytes());
            }
            catch (NoSuchAlgorithmException ex) {
                Logger.getLogger(KeyringSupport.class.getName()).log(Level.INFO, null, ex);
                keyPart = keyToHash;
            }
        }
        return keyPrefix + keyPart;
    }

    static String getKeyringKey(String keyPrefix, String key) {
        return keyPrefix + key;
    }

    private static char[] migrateRecord(String keyPrefix, String key) {
        String hashedKey = KeyringSupport.getKeyringKeyHashed(keyPrefix, key);
        if (NULL_HASHED_RECORDS.contains(hashedKey)) {
            return null;
        }
        char[] password = Keyring.read((String)hashedKey);
        if (password != null) {
            String fullKey = KeyringSupport.getKeyringKey(keyPrefix, key);
            Keyring.save((String)fullKey, (char[])((char[])password.clone()), (String)fullKey);
            Keyring.delete((String)hashedKey);
        }
        NULL_HASHED_RECORDS.add(hashedKey);
        return password;
    }
}

