/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.knockout.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.netbeans.modules.javascript2.knockout.index.KnockoutCustomElement;
import org.netbeans.modules.javascript2.knockout.index.KnockoutIndexer;
import org.netbeans.modules.javascript2.knockout.model.ModelUtils;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class KnockoutRegisterInterceptor
implements FunctionInterceptor {
    private static final Pattern NAME_PATTERN = Pattern.compile("ko\\.components\\.register");

    public Pattern getNamePattern() {
        return NAME_PATTERN;
    }

    public Collection<TypeUsage> intercept(Snapshot snapshot, String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        JsObject componentDecl;
        if (!KnockoutIndexer.isScannerThread()) {
            return Collections.emptyList();
        }
        String customElementName = null;
        int functionOffset = -1;
        int nameOffset = -1;
        for (FunctionArgument fArgument : args) {
            switch (fArgument.getKind()) {
                case STRING: {
                    if (customElementName != null) break;
                    customElementName = (String)fArgument.getValue();
                    nameOffset = fArgument.getOffset();
                    break;
                }
                case ANONYMOUS_OBJECT: {
                    functionOffset = fArgument.getOffset();
                }
            }
            if (customElementName == null || functionOffset == -1) continue;
            break;
        }
        if (customElementName != null && (componentDecl = ModelUtils.findJsObject(globalObject, functionOffset)) != null && componentDecl.getJSKind() == JsElement.Kind.ANONYMOUS_OBJECT && componentDecl.isDeclared()) {
            String fqnOfCustomElement = componentDecl.getFullyQualifiedName();
            FileObject fo = globalObject.getFileObject();
            Collection<String> componentParams = this.getComponentParameters(componentDecl);
            if (fo != null) {
                KnockoutIndexer.addCustomElement(fo.toURI(), new KnockoutCustomElement(customElementName, fqnOfCustomElement, componentParams, fo.toURL(), nameOffset));
            }
        }
        return Collections.emptyList();
    }

    private Collection<String> getComponentParameters(JsObject component) {
        JsObject createViewModel;
        JsObject viewModel = component.getProperty("viewModel");
        List functionParams = null;
        if (viewModel instanceof JsFunction) {
            functionParams = (List)((JsFunction)viewModel).getParameters();
        } else if (viewModel instanceof JsObject && (createViewModel = viewModel.getProperty("createViewModel")) != null) {
            functionParams = (List)((JsFunction)createViewModel).getParameters();
        }
        if (functionParams != null && !functionParams.isEmpty()) {
            return ((JsObject)functionParams.get(0)).getProperties().keySet();
        }
        return Collections.emptyList();
    }
}

