/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;

final class Debug {
    private static final Comparator<URL> C = new Comparator<URL>(){

        @Override
        public int compare(URL o1, URL o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };

    private Debug() {
        throw new IllegalStateException("No instance allowed");
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    @NonNull
    static StringBuilder printMap(@NonNull Map<URL, List<URL>> deps, @NonNull StringBuilder sb) {
        TreeSet<URL> sortedRoots = new TreeSet<URL>(C);
        sortedRoots.addAll(deps.keySet());
        for (URL url : sortedRoots) {
            sb.append("  ").append(url).append(":\n");
        }
        return sb;
    }

    static StringBuilder printCollection(Collection<? extends URL> collection, StringBuilder sb) {
        TreeSet<URL> sortedRoots = new TreeSet<URL>(C);
        sortedRoots.addAll(collection);
        for (URL url : sortedRoots) {
            sb.append("  ").append(url).append("\n");
        }
        return sb;
    }

    static StringBuilder printMimeTypes(Collection<? extends String> collection, StringBuilder sb) {
        Iterator<? extends String> i = collection.iterator();
        while (i.hasNext()) {
            String mimeType = i.next();
            sb.append("'").append(mimeType).append("'");
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb;
    }
}

