/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.api;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public abstract class IONotifier {
    private static IONotifier find(InputOutput io) {
        if (io instanceof Lookup.Provider) {
            Lookup.Provider p = (Lookup.Provider)io;
            return (IONotifier)p.getLookup().lookup(IONotifier.class);
        }
        return null;
    }

    public static void addPropertyChangeListener(InputOutput io, PropertyChangeListener listener) {
        IONotifier ion = IONotifier.find(io);
        if (ion != null) {
            ion.addPropertyChangeListener(listener);
        }
    }

    public static void removePropertyChangeListener(InputOutput io, PropertyChangeListener listener) {
        IONotifier ion = IONotifier.find(io);
        if (ion != null) {
            ion.removePropertyChangeListener(listener);
        }
    }

    public static void addVetoableChangeListener(InputOutput io, VetoableChangeListener listener) {
        IONotifier ion = IONotifier.find(io);
        if (ion != null) {
            ion.addVetoableChangeListener(listener);
        }
    }

    public static void removeVetoableChangeListener(InputOutput io, VetoableChangeListener listener) {
        IONotifier ion = IONotifier.find(io);
        if (ion != null) {
            ion.removeVetoableChangeListener(listener);
        }
    }

    public static boolean isSupported(InputOutput io) {
        return IONotifier.find(io) != null;
    }

    protected abstract void addPropertyChangeListener(PropertyChangeListener var1);

    protected abstract void removePropertyChangeListener(PropertyChangeListener var1);

    protected abstract void addVetoableChangeListener(VetoableChangeListener var1);

    protected abstract void removeVetoableChangeListener(VetoableChangeListener var1);
}

