/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.xml.DomExternalizable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtil {
    private static final DocumentBuilderFactory BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    public static Document parseXmlFile(File xmlFile) throws IOException, ParseException {
        return DomUtil.parseXmlFile(xmlFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseXmlFile(File xmlFile, Charset charset) throws IOException, ParseException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(xmlFile));
        try {
            Document document = DomUtil.parseXmlFile(in, charset);
            return document;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException ignord) {}
        }
    }

    public static Document parseXmlFile(CharSequence xmlFile) throws ParseException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xmlFile.toString().getBytes("UTF-8"));
            return DomUtil.parseXmlFile(in);
        }
        catch (UnsupportedEncodingException worntHappend) {
            throw new ParseException("utf-8 not supported!", worntHappend);
        }
        catch (IOException worntHappend) {
            throw new ParseException("fatal error: I/O mustn't happen here.", worntHappend);
        }
    }

    public static Document parseXmlFile(InputStream xmlStream, Charset charset) throws IOException, ParseException {
        try {
            InputSource inputSource;
            DocumentBuilder builder = BUILDER_FACTORY.newDocumentBuilder();
            if (charset != null) {
                InputStreamReader reader = new InputStreamReader(xmlStream, charset);
                inputSource = new InputSource(reader);
            } else {
                inputSource = new InputSource(xmlStream);
            }
            return builder.parse(inputSource);
        }
        catch (ParserConfigurationException worntHappend) {
            throw new ParseException("parse configuration error.", worntHappend);
        }
        catch (SAXException ex) {
            throw new ParseException("parsing error occuers!", ex);
        }
    }

    public static Document parseXmlFile(InputStream xmlStream) throws IOException, ParseException {
        return DomUtil.parseXmlFile(xmlStream, null);
    }

    public static void writeXmlFile(Document document, OutputStream outputStream, Charset charset) throws IOException {
        try {
            StreamResult output;
            DOMSource domSource = new DOMSource(document);
            if (charset != null) {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, charset));
                output = new StreamResult(writer);
            } else {
                output = new StreamResult(outputStream);
            }
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.transform(domSource, output);
        }
        catch (TransformerConfigurationException worntHappend) {
            throw new IOException(worntHappend.getMessage());
        }
        catch (TransformerException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public static void writeXmlFile(Document document, OutputStream outputStream) throws IOException {
        DomUtil.writeXmlFile(document, outputStream, null);
    }

    public static void writeXmlFile(Document document, File file) throws IOException {
        DomUtil.writeXmlFile(document, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXmlFile(Document document, File file, Charset charset) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            DomUtil.writeXmlFile(document, out, charset);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ignord) {}
        }
    }

    public static <T extends DomExternalizable> void addChild(Element parent, T object) {
        parent.appendChild(object.writeXML(parent.getOwnerDocument()));
    }

    public static void addElement(Element parent, String elemName, String elemText) {
        Element child = parent.getOwnerDocument().createElement(elemName);
        child.setTextContent(elemText);
        parent.appendChild(child);
    }
}

