/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.source.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.project.CodeAssistance;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsAdapter;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.source.spi.CndDocumentCodeStyleProvider;
import org.netbeans.modules.cnd.source.spi.CndSourcePropertiesProvider;
import org.netbeans.modules.cnd.utils.CndLanguageStandards;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.lexer.MutableTextInput;
import org.netbeans.spi.lexer.TokenHierarchyControl;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public final class DocumentLanguageFlavorProvider
implements CndSourcePropertiesProvider {
    public void addProperty(DataObject dob, StyledDocument doc) {
        Iterator i$;
        Language language;
        ListenerImpl old = (ListenerImpl)doc.getProperty(ListenerImpl.class);
        if (old != null) {
            old.unregister();
        }
        if ((language = (Language)doc.getProperty(Language.class)) != CppTokenId.languageCpp() && language != CppTokenId.languageC() && language != CppTokenId.languageHeader()) {
            return;
        }
        NativeFileItemSet nfis = (NativeFileItemSet)dob.getLookup().lookup(NativeFileItemSet.class);
        if (nfis != null && !nfis.isEmpty() && (i$ = nfis.getItems().iterator()).hasNext()) {
            NativeFileItem nativeFileItem = (NativeFileItem)i$.next();
            doc.putProperty(ListenerImpl.class, new ListenerImpl(doc, dob, nativeFileItem));
            DocumentLanguageFlavorProvider.setLanguage(nativeFileItem, doc);
            DocumentLanguageFlavorProvider.rebuildTH(doc);
            return;
        }
        FileObject primaryFile = dob.getPrimaryFile();
        if (primaryFile == null) {
            return;
        }
        if (DocumentLanguageFlavorProvider.setLanguage(primaryFile, doc)) {
            DocumentLanguageFlavorProvider.rebuildTH(doc);
            return;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)primaryFile);
        if (owner == null) {
            return;
        }
        NativeProject np = (NativeProject)owner.getLookup().lookup(NativeProject.class);
        if (np == null) {
            this.setDefaltLanguageFlavor(doc);
            return;
        }
        NativeFileItem nfi = np.findFileItem(primaryFile);
        if (nfi == null) {
            CndDocumentCodeStyleProvider cs = (CndDocumentCodeStyleProvider)owner.getLookup().lookup(CndDocumentCodeStyleProvider.class);
            if (cs != null) {
                doc.putProperty(CndDocumentCodeStyleProvider.class, cs);
            }
            this.setDefaltLanguageFlavor(doc);
            return;
        }
        doc.putProperty(ListenerImpl.class, new ListenerImpl(doc, dob, nfi));
        DocumentLanguageFlavorProvider.setLanguage(nfi, doc);
        DocumentLanguageFlavorProvider.rebuildTH(doc);
    }

    private void setDefaltLanguageFlavor(StyledDocument doc) {
        String mime = (String)doc.getProperty("mimeType");
        MIMEExtensions ee = MIMEExtensions.get((String)mime);
        if (ee == null) {
            return;
        }
        CndLanguageStandards.CndLanguageStandard defaultStandard = ee.getDefaultStandard();
        if (defaultStandard != null) {
            switch (defaultStandard) {
                case C89: {
                    if (MIMENames.isHeader((String)mime)) {
                        DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.C_HEADER, NativeFileItem.LanguageFlavor.C89, null, doc);
                        break;
                    }
                    DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.C, NativeFileItem.LanguageFlavor.C89, null, doc);
                    break;
                }
                case C99: {
                    if (MIMENames.isHeader((String)mime)) {
                        DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.C_HEADER, NativeFileItem.LanguageFlavor.C99, null, doc);
                        break;
                    }
                    DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.C, NativeFileItem.LanguageFlavor.C99, null, doc);
                    break;
                }
                case C11: {
                    if (MIMENames.isHeader((String)mime)) {
                        DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.C_HEADER, NativeFileItem.LanguageFlavor.C11, null, doc);
                        break;
                    }
                    DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.C, NativeFileItem.LanguageFlavor.C11, null, doc);
                    break;
                }
                case CPP98: {
                    if (MIMENames.isHeader((String)mime)) {
                        DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.C_HEADER, NativeFileItem.LanguageFlavor.CPP, null, doc);
                        break;
                    }
                    DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.CPP, NativeFileItem.LanguageFlavor.CPP, null, doc);
                    break;
                }
                case CPP11: {
                    if (MIMENames.isHeader((String)mime)) {
                        DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.C_HEADER, NativeFileItem.LanguageFlavor.CPP11, null, doc);
                        break;
                    }
                    DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.CPP, NativeFileItem.LanguageFlavor.CPP11, null, doc);
                    break;
                }
                case CPP14: {
                    if (MIMENames.isHeader((String)mime)) {
                        DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.C_HEADER, NativeFileItem.LanguageFlavor.CPP14, null, doc);
                        break;
                    }
                    DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(NativeFileItem.Language.CPP, NativeFileItem.LanguageFlavor.CPP14, null, doc);
                    break;
                }
                default: {
                    return;
                }
            }
            DocumentLanguageFlavorProvider.rebuildTH(doc);
        }
    }

    private static boolean setLanguage(FileObject fo, StyledDocument doc) {
        CodeAssistance CAProvider = (CodeAssistance)Lookup.getDefault().lookup(CodeAssistance.class);
        if (CAProvider != null) {
            Pair pair = CAProvider.getHeaderLanguageFlavour(fo);
            return DocumentLanguageFlavorProvider.tryToSetDocumentLanguage((NativeFileItem.Language)pair.first(), (NativeFileItem.LanguageFlavor)pair.second(), null, doc);
        }
        return false;
    }

    private static boolean setLanguage(NativeFileItem nfi, StyledDocument doc) {
        Lookup lookup;
        CndDocumentCodeStyleProvider cs;
        Lookup.Provider project;
        NativeProject nativeProject = nfi.getNativeProject();
        if (nativeProject != null && (project = nativeProject.getProject()) != null && (cs = (CndDocumentCodeStyleProvider)(lookup = project.getLookup()).lookup(CndDocumentCodeStyleProvider.class)) != null) {
            doc.putProperty(CndDocumentCodeStyleProvider.class, cs);
        }
        return DocumentLanguageFlavorProvider.tryToSetDocumentLanguage(null, null, nfi, doc);
    }

    private static boolean tryToSetDocumentLanguage(NativeFileItem.Language itemLang, NativeFileItem.LanguageFlavor flavor, NativeFileItem nfi, StyledDocument doc) {
        if (itemLang == null) {
            itemLang = nfi.getLanguage();
        }
        Filter filter = null;
        Language language = null;
        switch (itemLang) {
            case C: {
                language = CppTokenId.languageC();
                filter = CndLexerUtilities.getGccCFilter();
                break;
            }
            case C_HEADER: {
                language = CppTokenId.languageHeader();
                if (flavor == null) {
                    flavor = DocumentLanguageFlavorProvider.getLanguageFlavor(nfi);
                }
                if (flavor == NativeFileItem.LanguageFlavor.CPP11 || flavor == NativeFileItem.LanguageFlavor.CPP14) {
                    filter = CndLexerUtilities.getHeaderCpp11Filter();
                    break;
                }
                filter = CndLexerUtilities.getHeaderCppFilter();
                break;
            }
            case CPP: {
                language = CppTokenId.languageCpp();
                if (flavor == null) {
                    flavor = DocumentLanguageFlavorProvider.getLanguageFlavor(nfi);
                }
                if (flavor == NativeFileItem.LanguageFlavor.CPP11 || flavor == NativeFileItem.LanguageFlavor.CPP14) {
                    filter = CndLexerUtilities.getGccCpp11Filter();
                    break;
                }
                filter = CndLexerUtilities.getGccCppFilter();
                break;
            }
            case FORTRAN: 
            case OTHER: {
                return false;
            }
        }
        assert (language != null);
        assert (filter != null);
        doc.putProperty(Language.class, language);
        InputAttributes lexerAttrs = (InputAttributes)doc.getProperty(InputAttributes.class);
        lexerAttrs.setValue(language, (Object)"lexer-filter", (Object)filter, true);
        return true;
    }

    private static NativeFileItem.LanguageFlavor getLanguageFlavor(NativeFileItem nfi) {
        CodeAssistance CAProvider;
        NativeFileItem.LanguageFlavor flavor = nfi.getLanguageFlavor();
        if (flavor == NativeFileItem.LanguageFlavor.UNKNOWN && (CAProvider = (CodeAssistance)Lookup.getDefault().lookup(CodeAssistance.class)) != null) {
            flavor = (NativeFileItem.LanguageFlavor)CAProvider.getStartFileLanguageFlavour(nfi).second();
        }
        return flavor;
    }

    private static void rebuildTH(final StyledDocument doc) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BaseDocument bdoc = (BaseDocument)doc;
                try {
                    if (bdoc != null) {
                        TokenHierarchyControl thc;
                        bdoc.extWriteLock();
                        MutableTextInput mti = (MutableTextInput)bdoc.getProperty(MutableTextInput.class);
                        if (mti != null && (thc = mti.tokenHierarchyControl()) != null) {
                            thc.rebuild();
                        }
                    }
                }
                finally {
                    if (bdoc != null) {
                        bdoc.extWriteUnlock();
                    }
                }
            }
        });
    }

    private static final class ListenerImpl
    extends NativeProjectItemsAdapter
    implements PropertyChangeListener {
        private static final boolean TRACE = false;
        private final Reference<StyledDocument> docRef;
        private final String path;
        private final FileObject fo;
        private final Reference<NativeProject> prjRef;
        private NativeFileItem.LanguageFlavor languageFlavor;

        public ListenerImpl(StyledDocument doc, DataObject dob, NativeFileItem nativeFileItem) {
            this.docRef = new WeakReference<StyledDocument>(doc);
            this.fo = dob.getPrimaryFile();
            this.path = nativeFileItem.getAbsolutePath();
            NativeProject nativeProject = nativeFileItem.getNativeProject();
            this.prjRef = new WeakReference<NativeProject>(nativeProject);
            this.languageFlavor = DocumentLanguageFlavorProvider.getLanguageFlavor(nativeFileItem);
            if (nativeProject != null) {
                nativeProject.addProjectItemsListener((NativeProjectItemsListener)this);
            } else {
                System.err.println("no native project for " + nativeFileItem);
            }
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JTextComponent oldValue;
            StyledDocument doc = this.docRef.get();
            NativeProject project = this.prjRef.get();
            if (doc == null || project == null) {
                this.unregister();
                return;
            }
            if ("usedByCloneableEditor".equals(evt.getPropertyName())) {
                if (Boolean.FALSE.equals(evt.getNewValue())) {
                    this.unregister();
                }
            } else if ("componentRemoved".equals(evt.getPropertyName()) && (oldValue = (JTextComponent)evt.getOldValue()) != null && doc.equals(oldValue.getDocument())) {
                this.unregister();
            }
        }

        private void unregister() {
            StyledDocument doc;
            EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
            NativeProject nativeProject = this.prjRef.get();
            if (nativeProject != null) {
                nativeProject.removeProjectItemsListener((NativeProjectItemsListener)this);
            }
            if ((doc = this.docRef.get()) != null) {
                doc.putProperty(ListenerImpl.class, null);
            }
        }

        public void filesAdded(List<NativeFileItem> fileItems) {
            this.filesPropertiesChanged(fileItems);
        }

        private void filePropertiesChanged(NativeFileItem fileItem) {
            if (fileItem != null && this.path.equals(fileItem.getAbsolutePath())) {
                StyledDocument doc = this.docRef.get();
                if (doc == null) {
                    this.unregister();
                    return;
                }
                NativeFileItem.LanguageFlavor newFlavor = DocumentLanguageFlavorProvider.getLanguageFlavor(fileItem);
                if (!this.languageFlavor.equals((Object)newFlavor)) {
                    DocumentLanguageFlavorProvider.setLanguage(fileItem, doc);
                    this.languageFlavor = newFlavor;
                    DocumentLanguageFlavorProvider.rebuildTH(doc);
                }
            }
        }

        public void filesPropertiesChanged(List<NativeFileItem> fileItems) {
            for (NativeFileItem nativeFileItem : fileItems) {
                this.filePropertiesChanged(nativeFileItem);
            }
        }

        public void filesPropertiesChanged() {
            NativeProject nativeProject = this.prjRef.get();
            if (nativeProject != null) {
                NativeFileItem findFileItem = nativeProject.findFileItem(this.fo);
                this.filePropertiesChanged(findFileItem);
            } else {
                this.unregister();
            }
        }

        public void projectDeleted(NativeProject nativeProject) {
            this.unregister();
        }
    }
}

