/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.SftpSupport;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.signals.SignalSupport;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.openide.util.Exceptions;

public final class CommonTasksSupport {
    private CommonTasksSupport() {
    }

    private static boolean getBoolean(String name, boolean result) {
        String text = System.getProperty(name);
        if (text != null) {
            result = Boolean.parseBoolean(text);
        }
        return result;
    }

    public static Future<Integer> downloadFile(String srcFileName, ExecutionEnvironment srcExecEnv, String dstFileName, Writer error) {
        return SftpSupport.getInstance(srcExecEnv).downloadFile(srcFileName, dstFileName, error);
    }

    public static Future<Integer> downloadFile(String srcFileName, ExecutionEnvironment srcExecEnv, File dstFile, Writer error) {
        return SftpSupport.getInstance(srcExecEnv).downloadFile(srcFileName, dstFile.getAbsolutePath(), error);
    }

    public static byte[] readFile(String srcFileName, ExecutionEnvironment srcExecEnv, long offset, int count, Writer error) {
        int actual;
        int bs = 512;
        long iseek = offset / (long)bs;
        long endOffset = offset + (long)count;
        long cnt = endOffset / (long)bs;
        if (endOffset % (long)bs > 0L) {
            ++cnt;
        }
        byte[] buffer = new byte[(int)(cnt -= iseek) * bs];
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(srcExecEnv);
        if (iseek > 0L) {
            npb.setExecutable("/bin/dd").setArguments("if=" + srcFileName, "ibs=" + bs, "skip=" + iseek, "count=" + cnt);
        } else {
            npb.setExecutable("/bin/dd").setArguments("if=" + srcFileName, "ibs=" + bs, "count=" + cnt);
        }
        try {
            int readed;
            NativeProcess process = npb.call();
            if (process.getState() == NativeProcess.State.ERROR) {
                String err = ProcessUtils.readProcessErrorLine(process);
                if (iseek > 0L) {
                    throw new IOException("Cannot start /bin/dd if=" + srcFileName + " ibs=" + bs + " skip=" + iseek + " count=" + cnt + ": " + err);
                }
                throw new IOException("Cannot start /bin/dd if=" + srcFileName + " ibs=" + bs + " count=" + cnt + ": " + err);
            }
            int start = 0;
            int rest = buffer.length;
            actual = 0;
            while ((readed = process.getInputStream().read(buffer, start, rest)) > 0) {
                start += readed;
                actual += readed;
                if ((rest -= readed) > 0) continue;
                break;
            }
            int rc = 0;
            try {
                rc = process.waitFor();
            }
            catch (InterruptedException ex) {
                throw new IOException("/bin/dd was interrupted");
            }
            if (rc != 0) {
                String err = ProcessUtils.readProcessErrorLine(process);
                throw new IOException("Error while reading " + srcFileName + ": " + err);
            }
        }
        catch (IOException ex) {
            if (error != null) {
                try {
                    error.write(ex.getMessage());
                    error.flush();
                }
                catch (IOException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
            return new byte[0];
        }
        int extra = (int)(offset % (long)bs);
        if (actual - extra < 0) {
            return new byte[0];
        }
        int res_size = Math.min(actual - extra, count);
        byte[] result = new byte[res_size];
        System.arraycopy(buffer, extra, result, 0, res_size);
        return result;
    }

    public static Future<UploadStatus> uploadFile(UploadParameters parameters) {
        return SftpSupport.getInstance(parameters.dstExecEnv).uploadFile(parameters);
    }

    public static Future<UploadStatus> uploadFile(String srcFileName, ExecutionEnvironment dstExecEnv, String dstFileName, int mask) {
        return SftpSupport.getInstance(dstExecEnv).uploadFile(new UploadParameters(new File(srcFileName), dstExecEnv, dstFileName, null, mask, false, null));
    }

    public static Future<UploadStatus> uploadFile(String srcFileName, ExecutionEnvironment dstExecEnv, String dstFileName, int mask, boolean checkMd5) {
        return SftpSupport.getInstance(dstExecEnv).uploadFile(new UploadParameters(new File(srcFileName), dstExecEnv, dstFileName, null, mask, checkMd5, null));
    }

    public static Future<UploadStatus> uploadFile(File srcFile, ExecutionEnvironment dstExecEnv, String dstFileName, int mask) {
        return SftpSupport.getInstance(dstExecEnv).uploadFile(new UploadParameters(srcFile, dstExecEnv, dstFileName, null, mask, false, null));
    }

    public static Future<UploadStatus> uploadFile(File srcFile, ExecutionEnvironment dstExecEnv, String dstFileName, int mask, boolean checkMd5) {
        return SftpSupport.getInstance(dstExecEnv).uploadFile(new UploadParameters(srcFile, dstExecEnv, dstFileName, null, mask, checkMd5, null));
    }

    public static Future<Integer> rmFile(ExecutionEnvironment execEnv, String fname, Writer error) {
        return NativeTaskExecutorService.submit(new CommandRunner(execEnv, error, "rm", "-f", fname), "rm -f " + fname);
    }

    public static Future<Integer> chmod(ExecutionEnvironment execEnv, String file, int mode, Writer error) {
        return NativeTaskExecutorService.submit(new CommandRunner(execEnv, error, "chmod", String.format("0%03o", mode), file), "chmod " + String.format("0%03o ", mode) + file);
    }

    public static Future<Integer> rmDir(ExecutionEnvironment execEnv, String dirname, boolean recursively, Writer error) {
        Object[] objectArray;
        String cmd;
        String string = cmd = recursively ? "rm" : "rmdir";
        if (recursively) {
            Object[] objectArray2 = new String[2];
            objectArray2[0] = "-rf";
            objectArray = objectArray2;
            objectArray2[1] = dirname;
        } else {
            String[] stringArray = new String[2];
            stringArray[0] = "-f";
            objectArray = stringArray;
            stringArray[1] = dirname;
        }
        Object[] args = objectArray;
        return NativeTaskExecutorService.submit(new CommandRunner(execEnv, error, cmd, (String[])args), cmd + ' ' + Arrays.toString(args));
    }

    public static Future<Integer> mkDir(ExecutionEnvironment execEnv, String dirname, Writer error) {
        return NativeTaskExecutorService.submit(new CommandRunner(execEnv, error, "mkdir", "-p", dirname), "mkdir -p " + dirname);
    }

    public static Future<Integer> sendSignal(final ExecutionEnvironment execEnv, final int pid, final Signal signal, Writer error) {
        String descr = "Sending signal " + (Object)((Object)signal) + " to the process " + pid;
        return NativeTaskExecutorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SignalSupport.signalProcess(execEnv, pid, signal);
            }
        }, descr);
    }

    public static Future<Integer> sendSignalGrp(final ExecutionEnvironment execEnv, final int pid, final Signal signal, Writer error) {
        String descr = "Sending signal " + (Object)((Object)signal) + " to the group " + pid;
        return NativeTaskExecutorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SignalSupport.signalProcessGroup(execEnv, pid, signal);
            }
        }, descr);
    }

    public static Future<Integer> sendSignalSession(final ExecutionEnvironment execEnv, final int pid, final Signal signal, Writer error) {
        String descr = "Sending signal " + (Object)((Object)signal) + " to the session " + pid;
        return NativeTaskExecutorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SignalSupport.signalProcessGroup(execEnv, pid, signal);
            }
        }, descr);
    }

    @Deprecated
    public static Future<Integer> sigqueue(final ExecutionEnvironment execEnv, final int pid, final int signo, final int value, Writer error) {
        String descr = "Sigqueue " + signo + " with value " + value + " to " + pid;
        return NativeTaskExecutorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                for (Signal signal : Signal.values()) {
                    if (signal.getID() != signo) continue;
                    return SignalSupport.sigqueue(execEnv, pid, signal, value);
                }
                return -1;
            }
        }, descr);
    }

    public static Future<Integer> sigqueue(final ExecutionEnvironment execEnv, final int pid, final Signal signal, final int value, Writer error) {
        String descr = "Sigqueue " + (Object)((Object)signal) + " with value " + value + " to " + pid;
        return NativeTaskExecutorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SignalSupport.sigqueue(execEnv, pid, signal, value);
            }
        }, descr);
    }

    public static final class UploadParameters {
        public final File srcFile;
        public final ExecutionEnvironment dstExecEnv;
        public final String dstFileName;
        public final String dstFileToRename;
        public final int mask;
        public final ChangeListener callback;
        public final boolean checkMd5;
        public final boolean returnStat;

        public UploadParameters(File srcFile, ExecutionEnvironment dstExecEnv, String dstFileName) {
            this(srcFile, dstExecEnv, dstFileName, null, -1, false, null);
        }

        public UploadParameters(File srcFile, ExecutionEnvironment dstExecEnv, String dstFileName, int mask) {
            this(srcFile, dstExecEnv, dstFileName, null, mask, false, null);
        }

        public UploadParameters(File srcFile, ExecutionEnvironment dstExecEnv, String dstFileName, String dstFileToRename, int mask, boolean checkMd5, ChangeListener callback) {
            this(srcFile, dstExecEnv, dstFileName, dstFileToRename, mask, checkMd5, callback, true);
        }

        public UploadParameters(File srcFile, ExecutionEnvironment dstExecEnv, String dstFileName, String dstFileToRename, int mask, boolean checkMd5, ChangeListener callback, boolean returnStat) {
            this.srcFile = srcFile;
            this.dstExecEnv = dstExecEnv;
            this.dstFileName = dstFileName;
            this.dstFileToRename = dstFileToRename;
            this.mask = mask;
            this.checkMd5 = checkMd5;
            this.callback = callback;
            this.returnStat = returnStat;
        }

        public String toString() {
            return "UploadParameters src=" + this.srcFile + " env=" + this.dstExecEnv + " dst=" + this.dstFileName + "rename=" + this.dstFileToRename + " mask=" + this.mask + " md5=" + this.checkMd5;
        }
    }

    public static class UploadStatus {
        private final int exitCode;
        private final String error;
        private final FileInfoProvider.StatInfo statInfo;

        UploadStatus(int exitCode, String error, FileInfoProvider.StatInfo statInfo) {
            this.exitCode = exitCode;
            this.error = error;
            this.statInfo = statInfo;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getError() {
            return this.error;
        }

        public FileInfoProvider.StatInfo getStatInfo() {
            return this.statInfo;
        }
    }

    private static class CommandRunner
    implements Callable<Integer> {
        private static final java.util.logging.Logger log = Logger.getInstance();
        private final ExecutionEnvironment execEnv;
        private final String cmd;
        private final String[] args;
        private final Writer error;

        public CommandRunner(ExecutionEnvironment execEnv, Writer error, String cmd, String ... args) {
            this.execEnv = execEnv;
            this.cmd = cmd;
            this.args = args;
            this.error = error;
        }

        @Override
        public Integer call() throws Exception {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(this.execEnv);
            npb.setExecutable(this.cmd).setArguments(this.args);
            NativeProcess p = npb.call();
            int exitStatus = p.waitFor();
            if (exitStatus != 0) {
                if (this.error != null) {
                    ProcessUtils.writeError(this.error, p);
                } else {
                    ProcessUtils.logError(Level.FINE, log, p);
                }
            }
            return exitStatus;
        }
    }
}

