/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.EnvUtils;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.support.EnvWriter;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.Utilities;

public final class MacroMap
implements Cloneable {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private final ExecutionEnvironment execEnv;
    private final MacroExpanderFactory.MacroExpander macroExpander;
    private final TreeMap<String, String> hostEnv;
    private final TreeMap<String, String> map;
    private final Set<String> varsForExport = new HashSet<String>();
    private final boolean isWindows;
    private final Object lock = new Object();

    private MacroMap(ExecutionEnvironment execEnv, MacroExpanderFactory.MacroExpander macroExpander, boolean init) {
        this.execEnv = execEnv;
        this.macroExpander = macroExpander;
        boolean bl = this.isWindows = execEnv.isLocal() && Utilities.isWindows();
        if (this.isWindows) {
            this.map = new TreeMap(new CaseInsensitiveComparator());
            this.hostEnv = new TreeMap(new CaseInsensitiveComparator());
        } else {
            this.map = new TreeMap();
            this.hostEnv = new TreeMap();
        }
        if (init && HostInfoUtils.isHostInfoAvailable(execEnv)) {
            try {
                this.hostEnv.putAll(HostInfoUtils.getHostInfo(execEnv).getEnvironment());
            }
            catch (IOException ex) {
            }
            catch (ConnectionManager.CancellationException ex) {
                // empty catch block
            }
        }
        this.varsForExport.addAll(EnvWriter.wellKnownVars);
    }

    public static MacroMap forExecEnv(ExecutionEnvironment execEnv) {
        return new MacroMap(execEnv, MacroExpanderFactory.getExpander(execEnv), true);
    }

    public static MacroMap createEmpty(ExecutionEnvironment execEnv) {
        return new MacroMap(execEnv, MacroExpanderFactory.getExpander(execEnv), false);
    }

    public final void putAll(MacroMap envVariables) {
        if (envVariables == null) {
            return;
        }
        this.putAll(envVariables.map);
    }

    public final void putAll(Map<String, String> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public final void putAll(String[] env) {
        if (env == null) {
            return;
        }
        for (String envString : env) {
            this.put(EnvUtils.getKey(envString), EnvUtils.getValue(envString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            log.log(Level.INFO, "Attempt to set env variable {0} with null value", key);
        }
        String result = value;
        TreeMap<String, String> oneElementMap = this.isWindows ? new TreeMap<String, String>(new CaseInsensitiveComparator()) : new TreeMap();
        Object object = this.lock;
        synchronized (object) {
            if (!this.map.containsKey(key) && this.hostEnv.containsKey(key)) {
                oneElementMap.put(key, this.hostEnv.remove(key));
            } else if (this.map.containsKey(key)) {
                oneElementMap.put(key, this.map.get(key));
            }
            try {
                result = this.macroExpander.expandMacros(value, oneElementMap);
            }
            catch (ParseException ex) {
                // empty catch block
            }
            this.varsForExport.add(key);
            return this.map.put(key, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.map.containsKey(key)) {
                return this.map.get(key);
            }
            return this.hostEnv.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getUserDefinedMap() {
        TreeMap<String, String> result;
        Object object = this.lock;
        synchronized (object) {
            result = new TreeMap<String, String>(this.map.comparator());
            result.putAll(this.map);
        }
        return result;
    }

    public Set<String> getExportVariablesSet() {
        return Collections.unmodifiableSet(this.varsForExport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                buf.append(entry.getKey());
                buf.append(" = ");
                buf.append(entry.getValue());
                buf.append(", ");
            }
            for (Map.Entry<String, String> entry : this.hostEnv.entrySet()) {
                buf.append(entry.getKey());
                buf.append(" = ");
                buf.append(entry.getValue());
                buf.append(", ");
            }
        }
        buf.append("}");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.isEmpty() && this.hostEnv.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> joint = new HashSet<Map.Entry<String, String>>();
        Object object = this.lock;
        synchronized (object) {
            joint.addAll(this.map.entrySet());
            joint.addAll(this.hostEnv.entrySet());
        }
        return joint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MacroMap clone() {
        MacroMap clone;
        Object object = this.lock;
        synchronized (object) {
            clone = new MacroMap(this.execEnv, this.macroExpander, false);
            clone.map.putAll(this.map);
            clone.hostEnv.putAll(this.hostEnv);
            clone.varsForExport.addAll(this.varsForExport);
        }
        return clone;
    }

    public void prependPathVariable(String name, String path) {
        if (path == null) {
            return;
        }
        String oldpath = this.get(name);
        String newPath = path + (oldpath == null ? "" : (this.isWindows ? (char)';' : ':') + oldpath);
        newPath = newPath.replaceAll("::", ":");
        newPath = newPath.replaceAll("^:", "");
        newPath = newPath.replaceAll(":$", "");
        this.put(name, newPath);
    }

    public void appendPathVariable(String name, String path) {
        if (path == null) {
            return;
        }
        String oldpath = this.get(name);
        String newPath = (oldpath == null ? "" : oldpath + (this.isWindows ? (char)';' : ':')) + path;
        this.put(name, newPath);
    }

    public void dump(PrintStream out) {
        for (Map.Entry<String, String> entry : this.entrySet()) {
            out.printf("Environment: %s=%s\n", entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(String name) {
        Object object = this.lock;
        synchronized (object) {
            if (this.map.containsKey(name)) {
                return this.map.remove(name);
            }
            return this.hostEnv.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> toMap() {
        TreeMap<String, String> result;
        Object object = this.lock;
        synchronized (object) {
            result = new TreeMap<String, String>(this.map.comparator());
            result.putAll(this.hostEnv);
            result.putAll(this.map);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.hostEnv.clear();
            this.map.clear();
        }
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        @Override
        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.toUpperCase().compareTo(s2.toUpperCase());
        }
    }
}

