/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser.processors;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.beans.FxEvent;
import org.netbeans.modules.javafx2.editor.completion.model.EventHandler;
import org.netbeans.modules.javafx2.editor.completion.model.FxClassUtils;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.parser.BuildEnvironment;
import org.netbeans.modules.javafx2.editor.parser.ModelBuilderStep;
import org.netbeans.modules.javafx2.editor.parser.processors.Bundle;

public class EventResolver
extends FxNodeVisitor.ModelTreeTraversal
implements ModelBuilderStep {
    private BuildEnvironment env;
    private FxBean bean;
    private TypeElement controllerElement;
    private TypeMirror eventType;
    private static final String FX_EVENT_TYPE = "javafx.event.Event";

    public EventResolver() {
    }

    EventResolver(BuildEnvironment env) {
        this.env = env;
    }

    @Override
    public FxNodeVisitor createVisitor(BuildEnvironment env) {
        return new EventResolver(env);
    }

    @Override
    public void visitSource(FxModel source) {
        TypeElement el;
        ElementHandle<TypeElement> cTypeH;
        String controller = source.getController();
        if (controller != null && (cTypeH = source.getControllerType()) != null) {
            this.controllerElement = (TypeElement)cTypeH.resolve(this.env.getCompilationInfo());
        }
        if ((el = this.env.getCompilationInfo().getElements().getTypeElement(FX_EVENT_TYPE)) == null) {
            return;
        }
        this.eventType = el.asType();
        super.visitSource(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitBaseInstance(FxInstance decl) {
        FxBean saveBean = this.bean;
        try {
            this.bean = decl.getDefinition();
            super.visitBaseInstance(decl);
        }
        finally {
            this.bean = saveBean;
        }
    }

    @Override
    public void visitEvent(EventHandler eh) {
        if (this.bean == null) {
            return;
        }
        String eventName = eh.getEvent();
        FxEvent ev = this.bean.getEvent(eventName);
        if (ev == null && this.bean.getBuilder() != null) {
            ev = this.bean.getBuilder().getEvent(eventName);
        }
        int offs = this.env.getTreeUtilities().positions(eh).getStart();
        if (ev == null) {
            String sourceClassName = this.bean.getClassName();
            this.env.addError(new ErrorMark(offs, eh.getEvent().length() + 2, "event-undefined", Bundle.ERR_eventNotExists(sourceClassName, eh.getEvent()), eh));
            return;
        }
        this.env.getAccessor().resolve(eh, null, null, null, ev);
        if (eh.isScript()) {
            return;
        }
        int st = this.env.getTreeUtilities().positions(eh).getContentStart();
        int end = this.env.getTreeUtilities().positions(eh).getContentEnd();
        String c = eh.getRoot().getController();
        if (c == null) {
            this.env.addError(new ErrorMark(st, end - st, "event-controller-undefined", Bundle.ERR_controllerUndefined(), eh));
            return;
        }
        if (this.controllerElement == null) {
            return;
        }
        CharSequence cname = eh.getHandlerName();
        ExecutableElement found = null;
        ExecutableElement partialFound = null;
        boolean notAssignable = false;
        for (ExecutableElement ce : ElementFilter.methodsIn(this.env.getCompilationInfo().getElements().getAllMembers(this.controllerElement))) {
            if (!ce.getSimpleName().contentEquals(cname)) continue;
            partialFound = ce;
            if (ce.getParameters().size() > 1) continue;
            if (ce.getParameters().isEmpty()) {
                if (found != null) continue;
                found = ce;
                continue;
            }
            TypeMirror paramType = ce.getParameters().get(0).asType();
            if (this.env.getCompilationInfo().getTypes().isAssignable(paramType, this.eventType)) {
                found = ce;
                if (FxClassUtils.isFxmlAccessible(ce)) break;
                this.env.addError(new ErrorMark(st, end - st, "event-handler-inaccessible", Bundle.ERR_handlerMethodNotAccessible(), eh));
                break;
            }
            notAssignable = true;
        }
        if (found != null) {
            this.env.getAccessor().resolve(eh, ElementHandle.create(found), null, null, ev);
        } else if (notAssignable) {
            this.env.addError(new ErrorMark(st, end - st, "event-handler-bad-signature", Bundle.ERR_handlerMethodNotAccessible(), eh));
        } else {
            this.env.addError(new ErrorMark(st, end - st, "event-handler-not-found", Bundle.ERR_handlerNotFound(), eh));
        }
        super.visitEvent(eh);
    }
}

