/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.doctrine2.options;

import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.doctrine2.commands.Doctrine2Script;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class Doctrine2Options {
    private static final String PREFERENCES_PATH = "doctrine2";
    private static final Doctrine2Options INSTANCE = new Doctrine2Options();
    private static final String SCRIPT = "script";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile boolean scriptSearched = false;

    private Doctrine2Options() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                Doctrine2Options.this.changeSupport.fireChange();
            }
        });
    }

    public static Doctrine2Options getInstance() {
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getScript() {
        String script = this.getPreferences().get(SCRIPT, null);
        if (script == null && !this.scriptSearched) {
            this.scriptSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"doctrine", Doctrine2Script.SCRIPT_NAME_LONG});
            if (!scripts.isEmpty()) {
                script = (String)scripts.get(0);
                this.setScript(script);
            }
        }
        return script;
    }

    public void setScript(String script) {
        this.getPreferences().put(SCRIPT, script);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(Doctrine2Options.class).node(PREFERENCES_PATH);
    }
}

