/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.samples;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.websvc.metro.samples.FoldersListSettings;
import org.netbeans.modules.websvc.metro.samples.PanelConfigureProject;
import org.netbeans.modules.websvc.metro.samples.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener {
    private PanelConfigureProject panel;
    private JButton Button;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    protected JTextField projectNameTextField;

    public PanelProjectLocationVisual(PanelConfigureProject panel) {
        this.initComponents();
        this.panel = panel;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.Button = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setDisplayedMnemonic(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_LabelMnemonic").charAt(0));
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        this.projectNameLabel.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        this.projectLocationLabel.setDisplayedMnemonic(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_LabelMnemonic").charAt(0));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        this.projectLocationLabel.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NPW1_ProjectLocation_A11YDesc"));
        this.Button.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.Button.setActionCommand("BROWSE");
        this.Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationVisual.this.browseLocationAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.Button, gridBagConstraints);
        this.Button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_BrowseLocation_A11YDesc"));
        this.createdFolderLabel.setDisplayedMnemonic(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_LablelMnemonic").charAt(0));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        this.createdFolderLabel.setText(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_CreatedProjectFolder_A11YDesc"));
    }

    private void browseLocationAction(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_SelectProjectLocation"));
            chooser.setFileSelectionMode(1);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(projectDir.getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectLocationTextField.requestFocus();
    }

    @Override
    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File destFolder = new File(this.createdFolderTextField.getText());
        File[] children = destFolder.listFiles();
        if (destFolder.exists() && children != null && children.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderExists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    @Override
    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(this.createdFolderTextField.getText().trim()));
        d.putProperty("name", (Object)name);
        File projectsDir = new File(this.projectLocationTextField.getText());
        if (projectsDir.isDirectory()) {
            ProjectChooser.setProjectsFolder((File)projectsDir);
        }
    }

    @Override
    void read(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        this.projectLocationTextField.selectAll();
        String formater = null;
        String projectName = (String)settings.getProperty("name");
        formater = projectName == null ? NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NPW1_DefaultProjectName") : projectName + "{0}";
        if (projectName == null || this.validFreeProjectName(projectLocation, projectName) == null) {
            int baseCount = FoldersListSettings.getDefault().getNewProjectCount() + 1;
            while ((projectName = this.validFreeProjectName(projectLocation, formater, baseCount)) == null) {
                ++baseCount;
            }
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, index);
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    private String validFreeProjectName(File parentFolder, String name) {
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    private void updateTexts(DocumentEvent e) {
        this.createdFolderTextField.setText(this.getCreatedFolderPath());
        this.panel.fireChangeEvent();
    }

    private String getCreatedFolderPath() {
        StringBuffer folder = new StringBuffer(this.projectLocationTextField.getText().trim());
        if (!this.projectLocationTextField.getText().endsWith(File.separator)) {
            folder.append(File.separatorChar);
        }
        folder.append(this.projectNameTextField.getText().trim());
        return folder.toString();
    }
}

