/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.SrcMgr;
import org.clang.lex.HeaderMap;
import org.clang.lex.HeaderSearch;
import org.clang.lex.ModuleMap;
import org.clang.lex.impl.HeaderSearchStatics;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.llvm;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public final class DirectoryLookup
implements Native.NativePOD<DirectoryLookup> {
    private Unnamed_union1 u;
    private byte DirCharacteristic;
    private byte LookupType;
    private boolean IsIndexHeaderMap;
    private boolean SearchedAllModuleMaps;
    private boolean $LookupFileTmpDirInUse = false;
    private final SmallString $LookupFileTmpDir = new SmallString(1024);
    private boolean $LookupFilePathInUse = false;
    private final SmallString $LookupFilePath = new SmallString(1024);

    public DirectoryLookup() {
    }

    public DirectoryLookup(DirectoryEntry dir, SrcMgr.CharacteristicKind DT, boolean isFramework) {
        this.u = new Unnamed_union1();
        this.DirCharacteristic = DT.getValue();
        this.LookupType = (byte)(isFramework ? LookupType_t.LT_Framework.getValue() : LookupType_t.LT_NormalDir.getValue());
        this.IsIndexHeaderMap = false;
        this.SearchedAllModuleMaps = false;
        this.u.Dir.$assign(dir);
    }

    public DirectoryLookup(HeaderMap map, SrcMgr.CharacteristicKind DT, boolean isIndexHeaderMap) {
        this.u = new Unnamed_union1();
        this.DirCharacteristic = DT.getValue();
        this.LookupType = (byte)LookupType_t.LT_HeaderMap.getValue();
        this.IsIndexHeaderMap = isIndexHeaderMap;
        this.SearchedAllModuleMaps = false;
        this.u.Map = map;
    }

    public LookupType_t getLookupType() {
        return LookupType_t.valueOf(this.LookupType);
    }

    public char.ptr getName() {
        if (this.isNormalDir()) {
            return this.getDir().getName();
        }
        if (this.isFramework()) {
            return this.getFrameworkDir().getName();
        }
        assert (this.isHeaderMap()) : "Unknown DirectoryLookup";
        return this.getHeaderMap().getFileName();
    }

    public DirectoryEntry getDir() {
        return this.isNormalDir() ? this.u.Dir : null;
    }

    public DirectoryEntry getFrameworkDir() {
        return this.isFramework() ? this.u.Dir : null;
    }

    public HeaderMap getHeaderMap() {
        return this.isHeaderMap() ? this.u.Map : null;
    }

    public boolean isNormalDir() {
        return this.getLookupType() == LookupType_t.LT_NormalDir;
    }

    public boolean isFramework() {
        return this.getLookupType() == LookupType_t.LT_Framework;
    }

    public boolean isHeaderMap() {
        return this.getLookupType() == LookupType_t.LT_HeaderMap;
    }

    public boolean haveSearchedAllModuleMaps() {
        return this.SearchedAllModuleMaps;
    }

    public void setSearchedAllModuleMaps(boolean SAMM) {
        this.SearchedAllModuleMaps = SAMM;
    }

    public SrcMgr.CharacteristicKind getDirCharacteristic() {
        return SrcMgr.CharacteristicKind.valueOf((int)this.DirCharacteristic);
    }

    public byte getRawDirCharacteristic() {
        return this.DirCharacteristic;
    }

    public boolean isSystemHeaderDirectory() {
        return this.getRawDirCharacteristic() != 0;
    }

    public boolean isIndexHeaderMap() {
        return this.isHeaderMap() && this.IsIndexHeaderMap;
    }

    private SmallString $getLookupFileTmpDir() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$LookupFileTmpDirInUse) break block3;
                this.$LookupFileTmpDirInUse = true;
                if (true) break block2;
            }
            throw new AssertionError((Object)"already in use. Forgot to release? Or have to switch to vector-based impl?");
        }
        this.$LookupFileTmpDir.resize(0);
        return this.$LookupFileTmpDir;
    }

    private void $releaseLookupFileTmpDir(SmallString TmpDir) {
        assert (TmpDir == this.$LookupFileTmpDir) : "returns different instance";
        assert (this.$LookupFileTmpDirInUse) : "releasing without get ";
        if (!$assertionsDisabled) {
            this.$LookupFileTmpDirInUse = false;
            if (!false) {
                // empty if block
            }
        }
    }

    private SmallString $getLookupFilePath() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$LookupFilePathInUse) break block3;
                this.$LookupFilePathInUse = true;
                if (true) break block2;
            }
            throw new AssertionError((Object)"already in use. Forgot to release? Or have to switch to vector-based impl?");
        }
        this.$LookupFilePath.resize(0);
        return this.$LookupFilePath;
    }

    private void $releaseLookupFilePath(SmallString Path) {
        assert (Path == this.$LookupFilePath) : "returns different instance";
        assert (this.$LookupFilePathInUse) : "releasing without get ";
        if (!$assertionsDisabled) {
            this.$LookupFilePathInUse = false;
            if (!false) {
                // empty if block
            }
        }
    }

    public FileEntry LookupFile(StringRef Filename, HeaderSearch HS, SmallString SearchPath, SmallString RelativePath, ModuleMap.KnownHeader SuggestedModule, bool.ref InUserSpecifiedSystemFramework, bool.ref HasBeenMapped, SmallString MappedName) {
        SmallString TmpDir = this.$getLookupFileTmpDir();
        SmallString Path = this.$getLookupFilePath();
        FileEntry out = this.LookupFile(TmpDir, Path, Filename, HS, SearchPath, RelativePath, SuggestedModule, InUserSpecifiedSystemFramework, HasBeenMapped, MappedName);
        this.$releaseLookupFileTmpDir(TmpDir);
        this.$releaseLookupFilePath(Path);
        return out;
    }

    private FileEntry LookupFile(SmallString TmpDir, SmallString Path, StringRef Filename, HeaderSearch HS, SmallString SearchPath, SmallString RelativePath, ModuleMap.KnownHeader SuggestedModule, bool.ref InUserSpecifiedSystemFramework, bool.ref HasBeenMapped, SmallString MappedName) {
        FileEntry Result;
        InUserSpecifiedSystemFramework.$set(false);
        HasBeenMapped.$set(false);
        assert (TmpDir != null);
        assert (TmpDir.size() == 0);
        if (this.isNormalDir()) {
            DirectoryEntry dir = this.getDir();
            TmpDir.$assign(dir.getName(), dir.getNameLen());
            path.append((SmallString)TmpDir, (StringRef)Filename);
            if (SearchPath != null) {
                SearchPath.clear();
                SearchPath.append(dir.getName(), dir.getNameLen());
            }
            if (RelativePath != null) {
                RelativePath.clear();
                RelativePath.append(Filename);
            }
            return HeaderSearchStatics.getFileAndSuggestModule(HS, TmpDir.str(), dir, this.isSystemHeaderDirectory(), SuggestedModule);
        }
        if (this.isFramework()) {
            return this.DoFrameworkLookup(Filename, HS, SearchPath, RelativePath, SuggestedModule, InUserSpecifiedSystemFramework);
        }
        assert (this.isHeaderMap()) : "Unknown directory lookup";
        HeaderMap HM = this.getHeaderMap();
        assert (Path != null);
        assert (Path.size() == 0);
        StringRef Dest = HM.lookupFilename(Filename, Path);
        if (Dest.empty()) {
            return null;
        }
        if (path.is_relative((Twine)new Twine(Dest))) {
            MappedName.clear();
            MappedName.append(Dest);
            Filename.$assignMove(new StringRef(MappedName.begin().toPointer(), MappedName.size()));
            HasBeenMapped.$set(true);
            Result = HM.LookupFile(Filename, HS.getFileMgr());
        } else {
            Result = HS.getFileMgr().getFile(Dest);
        }
        if (Result != null) {
            if (SearchPath != null) {
                SearchPath.clear();
                SearchPath.append(this.getName());
            }
            if (RelativePath != null) {
                RelativePath.clear();
                RelativePath.append(Filename);
            }
        }
        return Result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private FileEntry DoFrameworkLookup(StringRef Filename, HeaderSearch HS, SmallString SearchPath, SmallString RelativePath, ModuleMap.KnownHeader SuggestedModule, bool.ref InUserSpecifiedSystemFramework) {
        FrameworkName = null;
        try {
            FileMgr = HS.getFileMgr();
            SlashPos = Filename.find(NativePointer.$((char)'/'));
            if (SlashPos == StringRef.npos) {
                var10_10 = null;
                return var10_10;
            }
            CacheEntry = HS.LookupFrameworkCache(Filename.substr(0, SlashPos));
            frameworkDir = this.getFrameworkDir();
            if (CacheEntry.Directory != null && CacheEntry.Directory != frameworkDir) {
                var12_13 = null;
                return var12_13;
            }
            FrameworkName = new SmallString(1024);
            FrameworkName.$addassign(frameworkDir.getName(), frameworkDir.getNameLen());
            if (FrameworkName.empty() || FrameworkName.back() != NativePointer.$((char)'/')) {
                FrameworkName.push_back(NativePointer.$((char)'/'));
            }
            FrameworkName.$addassign(Filename, 0, SlashPos);
            FrameworkName.$addassign((CharSequence)".framework/");
            if (CacheEntry.Directory == null) {
                HS.IncrementFrameworkLookupCount();
                Dir = FileMgr.getDirectory(FrameworkName.str());
                if (Dir == null) {
                    var13_16 = null;
                    return var13_16;
                }
                CacheEntry.Directory = frameworkDir;
                if (this.getDirCharacteristic() == SrcMgr.CharacteristicKind.C_User) {
                    SystemFrameworkMarker = new SmallString(FrameworkName);
                    SystemFrameworkMarker.$addassign((CharSequence)".system_framework");
                    if (fs.exists((Twine)new Twine(SystemFrameworkMarker.str()))) {
                        CacheEntry.IsUserSpecifiedSystemFramework = true;
                    }
                }
            }
            InUserSpecifiedSystemFramework.$set(CacheEntry.IsUserSpecifiedSystemFramework);
            if (RelativePath != null) {
                RelativePath.clear();
                RelativePath.append(Filename, SlashPos + 1, Filename.size());
            }
            OrigSize = FrameworkName.size();
            FrameworkName.$addassign((CharSequence)"Headers/");
            if (SearchPath != null) {
                SearchPath.clear();
                SearchPath.append((SmallVectorImplChar)FrameworkName, 0, FrameworkName.size() - 1);
            }
            FrameworkName.append(Filename, SlashPos + 1, Filename.size());
            FE = FileMgr.getFile(FrameworkName.str(), SuggestedModule == null);
            if (FE == null) {
                Private = NativePointer.$((String)"Private");
                FrameworkName.insert(FrameworkName.begin().$add(OrigSize), (char.iterator)Private, (char.iterator)Private.$add(std.strlen((char.ptr)Private)));
                if (SearchPath != null) {
                    SearchPath.insert(SearchPath.begin().$add(OrigSize), (char.iterator)Private, (char.iterator)Private.$add(std.strlen((char.ptr)Private)));
                }
                FE = FileMgr.getFile(FrameworkName.str(), SuggestedModule == null);
            }
            if (FE != null && SuggestedModule != null) {
                dir = FE.getDir();
                FrameworkPath = new StringRef(dir.getName(), dir.getNameLen());
                FoundFramework = false;
                while ((Dir = FileMgr.getDirectory(FrameworkPath)) != null) {
                    if (llvm.$eq_StringRef((StringRef)path.extension((StringRef)FrameworkPath), (CharSequence)".framework")) {
                        FoundFramework = true;
                        break;
                    }
                    FrameworkPath.$assignMove(path.parent_path((StringRef)FrameworkPath));
                    if (!FrameworkPath.empty()) continue;
                    break;
                }
                if (FoundFramework) {
                    SubmodulePath = null;
                    try {
                        SubmodulePath = new SmallVector(4, (Object)new std.string());
                        TopFrameworkDir = HeaderSearchStatics.getTopFrameworkDir(FileMgr, FrameworkPath, (SmallVectorImpl<std.string>)SubmodulePath);
                        ModuleName_ = path.stem((StringRef)new StringRef(TopFrameworkDir.getName(), TopFrameworkDir.getNameLen()));
                        v0 = IsSystem = this.getDirCharacteristic() != SrcMgr.CharacteristicKind.C_User;
                        if (HS.loadFrameworkModule(ModuleName_, TopFrameworkDir, IsSystem) == null) ** GOTO lbl85
                        SuggestedModule.$assign(HS.findModuleForHeader(FE));
                    }
                    finally {
                        if (SubmodulePath != null) {
                            SubmodulePath.$destroy();
                        }
                    }
                } else {
                    SuggestedModule.$assignMove(HS.findModuleForHeader(FE));
                }
            }
lbl85:
            // 5 sources

            var14_18 = FE;
            return var14_18;
        }
        finally {
            if (FrameworkName != null) {
                FrameworkName.$destroy();
            }
        }
    }

    public DirectoryLookup $assign(DirectoryLookup $Prm0) {
        this.u.$assign($Prm0.u);
        this.DirCharacteristic = $Prm0.DirCharacteristic;
        this.LookupType = $Prm0.LookupType;
        this.IsIndexHeaderMap = $Prm0.IsIndexHeaderMap;
        this.SearchedAllModuleMaps = $Prm0.SearchedAllModuleMaps;
        return this;
    }

    public DirectoryLookup(DirectoryLookup $Prm0) {
        this.u = new Unnamed_union1($Prm0.u);
        this.DirCharacteristic = $Prm0.DirCharacteristic;
        this.LookupType = $Prm0.LookupType;
        this.IsIndexHeaderMap = $Prm0.IsIndexHeaderMap;
        this.SearchedAllModuleMaps = $Prm0.SearchedAllModuleMaps;
    }

    public DirectoryLookup clone() {
        return new DirectoryLookup(this);
    }

    public boolean $noteq(DirectoryLookup other) {
        return !this.$eq(other);
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean $eq(DirectoryLookup other) {
        if (this.DirCharacteristic != other.DirCharacteristic) {
            return false;
        }
        if (this.LookupType != other.LookupType) {
            return false;
        }
        if (this.IsIndexHeaderMap != other.IsIndexHeaderMap) {
            return false;
        }
        if (this.SearchedAllModuleMaps != other.SearchedAllModuleMaps) {
            return false;
        }
        return this.u.$eq(other.u);
    }

    public String toString() {
        return "DirectoryLookup{u=" + this.u + ", DirCharacteristic=" + this.DirCharacteristic + ", LookupType=" + this.LookupType + ", IsIndexHeaderMap=" + this.IsIndexHeaderMap + ", SearchedAllModuleMaps=" + this.SearchedAllModuleMaps + '}';
    }

    private static class Unnamed_union1 {
        public DirectoryEntry Dir;
        public HeaderMap Map;

        public Unnamed_union1() {
            this.Dir = new DirectoryEntry();
        }

        public Unnamed_union1(Unnamed_union1 $Prm0) {
            this.Dir = new DirectoryEntry($Prm0.Dir);
            this.Map = $Prm0.Map;
        }

        public Unnamed_union1 $assign(Unnamed_union1 $Prm0) {
            this.Dir.$assign($Prm0.Dir);
            this.Map = $Prm0.Map;
            return this;
        }

        private boolean $eq(Unnamed_union1 u) {
            return this.Map == u.Map && this.Dir.$eq(u.Dir);
        }

        public String toString() {
            return "{Dir=" + this.Dir + ", Map=" + this.Map + '}';
        }
    }

    public static final class LookupType_t
    extends Enum<LookupType_t> {
        public static final /* enum */ LookupType_t LT_NormalDir = new LookupType_t(0);
        public static final /* enum */ LookupType_t LT_Framework = new LookupType_t(1);
        public static final /* enum */ LookupType_t LT_HeaderMap = new LookupType_t(2);
        private final int value;
        private static final /* synthetic */ LookupType_t[] $VALUES;

        public static LookupType_t[] values() {
            return (LookupType_t[])$VALUES.clone();
        }

        public static LookupType_t valueOf(String name) {
            return Enum.valueOf(LookupType_t.class, name);
        }

        public static LookupType_t valueOf(int val) {
            LookupType_t out;
            LookupType_t lookupType_t = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private LookupType_t(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new LookupType_t[]{LT_NormalDir, LT_Framework, LT_HeaderMap};
        }

        private static final class Values {
            private static final LookupType_t[] VALUES;
            private static final LookupType_t[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (LookupType_t kind : LookupType_t.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new LookupType_t[min < 0 ? 1 - min : 0];
                VALUES = new LookupType_t[max >= 0 ? 1 + max : 0];
                for (LookupType_t kind : LookupType_t.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((LookupType_t)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((LookupType_t)kind).value] = kind;
                }
            }
        }
    }
}

