/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.target.TargetInfo;
import org.clang.lex.ArrayRefToken;
import org.clang.lex.ClangGlobals;
import org.clang.lex.Lexer;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.impl.LiteralSupportStatics;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ushort;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;

public class StringLiteralParser {
    private SourceManager SM;
    private LangOptions Features;
    private TargetInfo Target;
    private DiagnosticsEngine Diags;
    private long MaxTokenLength;
    private long SizeBound;
    private long CharByteWidth;
    private short Kind;
    private SmallString ResultBuf;
    private char.ptr ResultPtr;
    private SmallString UDSuffixBuf;
    private long UDSuffixToken;
    private long UDSuffixOffset;
    public boolean hadError;
    public boolean Pascal;

    public StringLiteralParser(ArrayRefToken StringToks, Preprocessor PP) {
        this(StringToks, PP, true);
    }

    public StringLiteralParser(ArrayRefToken StringToks, Preprocessor PP, boolean Complain) {
        this.SM = PP.getSourceManager();
        this.Features = PP.getLangOpts();
        this.Target = PP.getTargetInfo();
        this.Diags = Complain ? PP.getDiagnostics() : null;
        this.MaxTokenLength = 0L;
        this.SizeBound = 0L;
        this.CharByteWidth = 0L;
        this.Kind = 0;
        this.ResultBuf = new SmallString(512);
        this.ResultPtr = this.ResultBuf.data();
        this.UDSuffixBuf = new SmallString(32);
        this.hadError = false;
        this.Pascal = false;
        this.init(new ArrayRefToken(StringToks));
    }

    public StringLiteralParser(ArrayRefToken StringToks, SourceManager sm, LangOptions features, TargetInfo target) {
        this(StringToks, sm, features, target, null);
    }

    public StringLiteralParser(ArrayRefToken StringToks, SourceManager sm, LangOptions features, TargetInfo target, DiagnosticsEngine diags) {
        this.SM = sm;
        this.Features = features;
        this.Target = target;
        this.Diags = diags;
        this.MaxTokenLength = 0L;
        this.SizeBound = 0L;
        this.CharByteWidth = 0L;
        this.Kind = 0;
        this.ResultBuf = new SmallString(512);
        this.ResultPtr = this.ResultBuf.data();
        this.UDSuffixBuf = new SmallString(32);
        this.hadError = false;
        this.Pascal = false;
        this.init(new ArrayRefToken(StringToks));
    }

    public StringRef GetString() {
        return new StringRef(this.ResultBuf.data(), this.GetStringLength());
    }

    public int GetStringLength() {
        return this.ResultPtr.$sub((abstract_iterator)this.ResultBuf.data());
    }

    public long GetNumStringChars() {
        return (long)this.GetStringLength() / this.CharByteWidth;
    }

    public long getOffsetOfStringByte(Token Tok, long ByteNo) {
        SmallString SpellingBuffer = new SmallString(32);
        SpellingBuffer.resize(Tok.getLength());
        char.ptr SpellingPtr = SpellingBuffer.data();
        long TokLen = Lexer.getSpelling(Tok, SpellingPtr, this.SM, this.Features, null);
        if (TokLen == -1L) {
            return 0L;
        }
        char.ptr SpellingStart = Native.$tryClone((char.ptr)SpellingPtr);
        char.ptr SpellingEnd = (char.ptr)SpellingPtr.$add(TokLen);
        if (SpellingPtr.$at(0) == NativePointer.$((char)'u') && SpellingPtr.$at(1) == NativePointer.$((char)'8')) {
            SpellingPtr.$inc(2);
        }
        assert (SpellingPtr.$at(0) != NativePointer.$((char)'L') && SpellingPtr.$at(0) != NativePointer.$((char)'u') && SpellingPtr.$at(0) != NativePointer.$((char)'U')) : "Doesn't handle wide or utf strings yet";
        if (SpellingPtr.$at(0) == NativePointer.$((char)'R')) {
            assert (SpellingPtr.$at(1) == NativePointer.$((char)'\"')) : "Should be a raw string literal!";
            SpellingPtr.$inc(2);
            while (SpellingPtr.$star() != NativePointer.$((char)'(')) {
                SpellingPtr.$preInc();
                assert (SpellingPtr.$less((Object)SpellingEnd)) : "Missing ( for raw string literal";
            }
            SpellingPtr.$preInc();
            return (long)SpellingPtr.$sub((abstract_iterator)SpellingStart) + ByteNo;
        }
        assert (SpellingPtr.$at(0) == NativePointer.$((char)'\"')) : "Should be a string literal!";
        SpellingPtr.$preInc();
        while (ByteNo != 0L) {
            assert (SpellingPtr.$less((Object)SpellingEnd)) : "Didn't find byte offset!";
            if (SpellingPtr.$star() != 92) {
                SpellingPtr.$preInc();
                --ByteNo;
                continue;
            }
            bool.ref HadError = NativePointer.create_bool$ref((boolean)false);
            if (SpellingPtr.$at(1) == NativePointer.$((char)'u') || SpellingPtr.$at(1) == NativePointer.$((char)'U')) {
                int EscapePtr = SpellingPtr.$index();
                long Len = LiteralSupportStatics.MeasureUCNEscape(SpellingStart, SpellingPtr, SpellingEnd, 1L, this.Features, HadError);
                if (Len > ByteNo) {
                    Native.$setIndex((char.ptr)SpellingPtr, (int)EscapePtr);
                    break;
                }
                ByteNo -= Len;
            } else {
                LiteralSupportStatics.ProcessCharEscape(SpellingStart, SpellingPtr, SpellingEnd, HadError, new FullSourceLoc(Tok.getRawLocation(), this.SM), this.CharByteWidth * 8L, this.Diags, this.Features);
                --ByteNo;
            }
            assert (!HadError.$deref()) : "This method isn't valid on erroneous strings";
        }
        return SpellingPtr.$sub((abstract_iterator)SpellingStart);
    }

    public boolean isAscii() {
        return this.Kind == 13;
    }

    public boolean isWide() {
        return this.Kind == 14;
    }

    public boolean isUTF8() {
        return this.Kind == 16;
    }

    public boolean isUTF16() {
        return this.Kind == 17;
    }

    public boolean isUTF32() {
        return this.Kind == 18;
    }

    public boolean isPascal() {
        return this.Pascal;
    }

    public StringRef getUDSuffix() {
        return this.UDSuffixBuf.$StringRef();
    }

    public long getUDSuffixToken() {
        assert (!this.UDSuffixBuf.empty()) : "no ud-suffix";
        return this.UDSuffixToken;
    }

    public long getUDSuffixOffset() {
        assert (!this.UDSuffixBuf.empty()) : "no ud-suffix";
        return this.UDSuffixOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ArrayRefToken StringToks) {
        if (StringToks.empty() || ((Token)StringToks.$at(0)).getLength() < 2) {
            this.DiagnoseLexingError(new SourceLocation());
            return;
        }
        assert (!StringToks.empty()) : "expected at least one token";
        this.MaxTokenLength = ((Token)StringToks.$at(0)).getLength();
        assert (((Token)StringToks.$at(0)).getLength() >= 2) : "literal token is invalid!";
        this.SizeBound = ((Token)StringToks.$at(0)).getLength() - 2;
        this.Kind = ((Token)StringToks.$at(0)).getKind();
        this.hadError = false;
        for (long i = 1L; i != (long)StringToks.size(); ++i) {
            if (((Token)StringToks.$at((int)i)).getLength() < 2) {
                this.DiagnoseLexingError(((Token)StringToks.$at((int)i)).getLocation());
                return;
            }
            assert (((Token)StringToks.$at((int)i)).getLength() >= 2) : "literal token is invalid!";
            this.SizeBound += (long)(((Token)StringToks.$at((int)i)).getLength() - 2);
            if ((long)((Token)StringToks.$at((int)i)).getLength() > this.MaxTokenLength) {
                this.MaxTokenLength = ((Token)StringToks.$at((int)i)).getLength();
            }
            if (!((Token)StringToks.$at((int)i)).isNot(this.Kind) || !((Token)StringToks.$at((int)i)).isNot((short)13)) continue;
            if (this.isAscii()) {
                this.Kind = ((Token)StringToks.$at((int)i)).getKind();
                continue;
            }
            if (this.Diags != null) {
                this.Diags.Report(((Token)StringToks.$at((int)i)).getLocation(), 748L);
            }
            this.hadError = true;
        }
        ++this.SizeBound;
        this.CharByteWidth = LiteralSupportStatics.getCharWidth(this.Kind, this.Target);
        assert ((this.CharByteWidth & 7L) == 0L) : "Assumes character size is byte multiple";
        this.CharByteWidth /= 8L;
        this.SizeBound *= this.CharByteWidth;
        this.ResultBuf.resize(this.SizeBound);
        SmallString TokenBuf = new SmallString(512);
        TokenBuf.resize(this.MaxTokenLength);
        this.ResultPtr = Native.$tryClone((char.ptr)this.ResultBuf.data());
        this.Pascal = false;
        SourceLocation UDSuffixTokLoc = new SourceLocation();
        int e = StringToks.size();
        for (int i = 0; i != e; ++i) {
            char.ptr ThisTokBuf = TokenBuf.data();
            int ThisTokLen = Lexer.getSpelling((Token)StringToks.$at(i), ThisTokBuf, this.SM, this.Features, null);
            if (ThisTokLen == -1) {
                this.DiagnoseLexingError(((Token)StringToks.$at(i)).getLocation());
                return;
            }
            char.ptr ThisTokBegin = Native.$tryClone((char.ptr)ThisTokBuf);
            char.ptr ThisTokEnd = (char.ptr)ThisTokBuf.$add(ThisTokLen);
            if (ThisTokEnd.$at(-1) != NativePointer.$((char)'\"')) {
                int UDSuffixEnd = ThisTokEnd.$index();
                do {
                    ThisTokEnd.$preDec();
                } while (ThisTokEnd.$at(-1) != NativePointer.$((char)'\"'));
                StringRef UDSuffix = new StringRef(ThisTokEnd, UDSuffixEnd - ThisTokEnd.$index());
                if (this.UDSuffixBuf.empty()) {
                    if (((Token)StringToks.$at(i)).hasUCN()) {
                        ClangGlobals.expandUCNs(this.UDSuffixBuf, UDSuffix);
                    } else {
                        this.UDSuffixBuf.assign(UDSuffix);
                    }
                    this.UDSuffixToken = i;
                    this.UDSuffixOffset = ThisTokEnd.$sub((abstract_iterator)ThisTokBuf);
                    UDSuffixTokLoc.$assign(((Token)StringToks.$at(i)).getRawLocation());
                } else if (!this.UDSuffixBuf.equals(UDSuffix)) {
                    SmallString ExpandedUDSuffix = null;
                    try {
                        ExpandedUDSuffix = new SmallString(32);
                        if (((Token)StringToks.$at(i)).hasUCN()) {
                            ClangGlobals.expandUCNs(ExpandedUDSuffix, UDSuffix);
                            UDSuffix.$assignMove(ExpandedUDSuffix.$StringRef());
                        }
                        if (llvm.$noteq_StringRef((StringRef)this.UDSuffixBuf.$StringRef(), (StringRef)UDSuffix)) {
                            if (this.Diags != null) {
                                SourceLocation TokLoc = ((Token)StringToks.$at(i)).getLocation();
                                org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diags.Report(TokLoc, 741L), (StringRef)this.UDSuffixBuf.$StringRef()), (StringRef)UDSuffix), (SourceRange)new SourceRange(UDSuffixTokLoc, UDSuffixTokLoc)), (SourceRange)new SourceRange(TokLoc, TokLoc)).$destroy();
                            }
                            this.hadError = true;
                        }
                    }
                    finally {
                        if (ExpandedUDSuffix != null) {
                            ExpandedUDSuffix.$destroy();
                        }
                    }
                }
            }
            ThisTokEnd.$preDec();
            if (ThisTokBuf.$at(0) == NativePointer.$((char)'L') || ThisTokBuf.$at(0) == NativePointer.$((char)'u') || ThisTokBuf.$at(0) == NativePointer.$((char)'U')) {
                ThisTokBuf.$preInc();
                if (ThisTokBuf.$at(0) == NativePointer.$((char)'8')) {
                    ThisTokBuf.$preInc();
                }
            }
            if (ThisTokBuf.$at(0) == NativePointer.$((char)'R')) {
                ThisTokBuf.$inc(2);
                int Prefix = ThisTokBuf.$index();
                while (ThisTokBuf.$at(0) != NativePointer.$((char)'(')) {
                    ThisTokBuf.$preInc();
                }
                ThisTokBuf.$preInc();
                ThisTokEnd.$dec(ThisTokBuf.$index() - Prefix);
                assert (ThisTokEnd.$greatereq((Object)ThisTokBuf)) : "malformed raw string literal";
                if (!this.CopyStringFragment((Token)StringToks.$at(i), ThisTokBegin, new StringRef(ThisTokBuf, ThisTokEnd.$sub((abstract_iterator)ThisTokBuf)))) continue;
                this.hadError = true;
                continue;
            }
            if (ThisTokBuf.$at(0) != NativePointer.$((char)'\"')) {
                this.DiagnoseLexingError(((Token)StringToks.$at(i)).getLocation());
                return;
            }
            ThisTokBuf.$preInc();
            if (this.Features.PascalStrings && ThisTokBuf.$add(1) != ThisTokEnd && ThisTokBuf.$at(0) == 92 && ThisTokBuf.$at(1) == NativePointer.$((char)'p')) {
                if (i == 0) {
                    ThisTokBuf.$preInc();
                    this.Pascal = true;
                } else if (this.Pascal) {
                    ThisTokBuf.$inc(2);
                }
            }
            while (ThisTokBuf.$noteq((Object)ThisTokEnd)) {
                uint.ptr ResultWidePtr;
                if (ThisTokBuf.$at(0) != 92) {
                    char.ptr InStart = Native.$tryClone((char.ptr)ThisTokBuf);
                    do {
                        ThisTokBuf.$preInc();
                    } while (ThisTokBuf.$noteq((Object)ThisTokEnd) && ThisTokBuf.$at(0) != 92);
                    if (!this.CopyStringFragment((Token)StringToks.$at(i), ThisTokBegin, new StringRef(InStart, ThisTokBuf.$sub((abstract_iterator)InStart)))) continue;
                    this.hadError = true;
                    continue;
                }
                if (ThisTokBuf.$at(1) == NativePointer.$((char)'u') || ThisTokBuf.$at(1) == NativePointer.$((char)'U')) {
                    bool.ref _hadError = NativePointer.create_bool$ref((boolean)this.hadError);
                    LiteralSupportStatics.EncodeUCNEscape(ThisTokBegin, ThisTokBuf, ThisTokEnd, (type.ref<char.ptr>)this.ResultPtr.$addr().star$ref(), _hadError, new FullSourceLoc(((Token)StringToks.$at(i)).getRawLocation(), this.SM), this.CharByteWidth, this.Diags, this.Features);
                    this.hadError = _hadError.$deref();
                    continue;
                }
                bool.ref _hadError = NativePointer.create_bool$ref((boolean)this.hadError);
                long ResultChar = LiteralSupportStatics.ProcessCharEscape(ThisTokBegin, ThisTokBuf, ThisTokEnd, _hadError, new FullSourceLoc(((Token)StringToks.$at(i)).getRawLocation(), this.SM), this.CharByteWidth * 8L, this.Diags, this.Features);
                this.hadError = _hadError.$deref();
                if (this.CharByteWidth == 4L) {
                    ResultWidePtr = (uint.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)this.ResultPtr)));
                    ResultWidePtr.$set(ResultChar);
                    this.ResultPtr.$inc(4);
                    continue;
                }
                if (this.CharByteWidth == 2L) {
                    ResultWidePtr = (ushort.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)Casts.reinterpret_cast(ushort.ptr.class, (void.ptr)this.ResultPtr)));
                    ResultWidePtr.$set((char)(ResultChar & 0xFFFFL));
                    this.ResultPtr.$inc(2);
                    continue;
                }
                assert (this.CharByteWidth == 1L) : "Unexpected char width";
                this.ResultPtr.$set((byte)(ResultChar & 0xFFL));
                this.ResultPtr.$preInc();
            }
        }
        if (this.Pascal) {
            if (this.CharByteWidth == 4L) {
                uint.ptr ResultWidePtr = (uint.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)this.ResultBuf.data())));
                ResultWidePtr.$set(0, this.GetNumStringChars() - 1L);
            } else if (this.CharByteWidth == 2L) {
                ushort.ptr ResultWidePtr = (ushort.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)Casts.reinterpret_cast(ushort.ptr.class, (void.ptr)this.ResultBuf.data())));
                ResultWidePtr.$set(0, (char)(this.GetNumStringChars() - 1L));
            } else {
                assert (this.CharByteWidth == 1L) : "Unexpected char width";
                this.ResultBuf.$set(0, (byte)(this.GetNumStringChars() - 1L));
            }
            if (this.GetStringLength() > 256) {
                if (this.Diags != null) {
                    org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)this.Diags.Report(((Token)StringToks.front()).getLocation(), 683L), (SourceRange)new SourceRange(((Token)StringToks.front()).getLocation(), ((Token)StringToks.back()).getLocation())).$destroy();
                }
                this.hadError = true;
                return;
            }
        } else if (this.Diags != null) {
            long MaxChars;
            long l = this.Features.CPlusPlus ? 65536L : (MaxChars = this.Features.C99 ? 4095L : 509L);
            if (this.GetNumStringChars() > MaxChars) {
                org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_uint((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_uint((DiagnosticBuilder)this.Diags.Report(((Token)StringToks.front()).getLocation(), 797L), (long)this.GetNumStringChars()), (long)MaxChars), (int)(this.Features.CPlusPlus ? 2 : (this.Features.C99 ? 1 : 0))), (SourceRange)new SourceRange(((Token)StringToks.$at(0)).getLocation(), ((Token)StringToks.back()).getLocation())).$destroy();
            }
        }
    }

    private boolean CopyStringFragment(Token Tok, char.ptr TokBegin, StringRef Fragment) {
        type.ref ErrorPtrTmp = NativePointer.create_type$ref(null);
        if (llvm.ConvertUTF8toWide((long)this.CharByteWidth, (StringRef)Fragment, (type.ref)this.ResultPtr.$addr().star$ref(), (type.ref)ErrorPtrTmp)) {
            return false;
        }
        boolean NoErrorOnBadEncoding = this.isAscii();
        if (NoErrorOnBadEncoding) {
            std.memcpy((char.ptr)this.ResultPtr, (char.ptr)Fragment.data(), (int)Fragment.size());
            this.ResultPtr.$inc(Fragment.size());
        }
        if (this.Diags != null) {
            char.ptr ErrorPtr = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)ErrorPtrTmp.$deref()))));
            FullSourceLoc SourceLoc = new FullSourceLoc(Tok.getRawLocation(), this.SM);
            DiagnosticBuilder Builder = LiteralSupportStatics.Diag(this.Diags, this.Features, SourceLoc, TokBegin, ErrorPtr, LiteralSupportStatics.resyncUTF8(ErrorPtr, Fragment.end()), NoErrorOnBadEncoding ? 838L : 624L);
            char.ptr NextStart = Native.$tryClone((char.ptr)LiteralSupportStatics.resyncUTF8(ErrorPtr, Fragment.end()));
            StringRef NextFragment = new StringRef(NextStart, Fragment.end().$sub((abstract_iterator)NextStart));
            SmallString Dummy = new SmallString(512);
            Dummy.reserve((long)Fragment.size() * this.CharByteWidth);
            char.ptr Ptr = Native.$tryClone((char.ptr)Dummy.data());
            while (!llvm.ConvertUTF8toWide((long)this.CharByteWidth, (StringRef)NextFragment, (type.ref)Ptr.$addr().star$ref(), (type.ref)ErrorPtrTmp)) {
                char.ptr _ErrorPtr = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)ErrorPtrTmp.$deref()))));
                NextStart = Native.$tryClone((char.ptr)LiteralSupportStatics.resyncUTF8(_ErrorPtr, Fragment.end()));
                org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_CharSourceRange((DiagnosticBuilder)Builder, (CharSourceRange)LiteralSupportStatics.MakeCharSourceRange(this.Features, SourceLoc, TokBegin, _ErrorPtr, NextStart));
                NextFragment.$assign(new StringRef(NextStart, Fragment.end().$sub((abstract_iterator)NextStart)));
            }
            Builder.$destroy();
        }
        return !NoErrorOnBadEncoding;
    }

    private void DiagnoseLexingError(SourceLocation Loc) {
        this.hadError = true;
        if (this.Diags != null) {
            this.Diags.Report(Loc, 646L);
        }
    }
}

