/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.SourceLocation;
import org.clang.lex.HeaderFileInfo;
import org.clang.lex.HeaderSearch;
import org.clang.lex.ModuleMap;
import org.clank.java.std;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.BumpPtrAllocatorImpl;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;

public final class HeaderSearchStatics {
    public static FileEntry getFileAndSuggestModule(HeaderSearch HS, StringRef FileName, DirectoryEntry Dir, boolean IsSystemHeaderDir, ModuleMap.KnownHeader SuggestedModule) {
        HS.hasModuleMap(FileName, Dir, IsSystemHeaderDir);
        if (SuggestedModule != null) {
            FileEntry File2 = HS.getFileMgr().getFile(FileName, false);
            if (File2 != null) {
                SuggestedModule.$assignMove(HS.findModuleForHeader(File2));
                if (SuggestedModule.getModule() == null && HS.hasModuleMap(FileName, Dir, IsSystemHeaderDir)) {
                    SuggestedModule.$assignMove(HS.findModuleForHeader(File2));
                }
            }
            return File2;
        }
        return HS.getFileMgr().getFile(FileName, true);
    }

    public static char.ptr copyString(StringRef Str, BumpPtrAllocatorImpl Alloc) {
        assert (!Str.empty());
        char.ptr CopyStr = Native.$tryClone((char.ptr)Alloc.Allocate(Str.size() + 1));
        std.copy((char.iterator)Str.begin(), (char.iterator)Str.end(), (char.iterator)CopyStr);
        CopyStr.$set(Str.size(), NativePointer.$((char)'\u0000'));
        return CopyStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectoryEntry getTopFrameworkDir(FileManager FileMgr, StringRef DirName, SmallVectorImpl<std.string> SubmodulePath) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            assert (llvm.$eq_StringRef((StringRef)path.extension((StringRef)DirName), (CharSequence)".framework")) : "Not a framework directory";
            DirectoryEntry TopFrameworkDir = FileMgr.getDirectory(DirName);
            DirName.$assignMove(FileMgr.getCanonicalName(TopFrameworkDir));
            while (true) {
                DirectoryEntry Dir;
                DirName.$assignMove(path.parent_path((StringRef)DirName));
                if (path.is_empty((StringRef)DirName) || (Dir = FileMgr.getDirectory(DirName)) == null) break;
                if (!llvm.$eq_StringRef((StringRef)path.extension((StringRef)DirName), (CharSequence)".framework")) continue;
                SubmodulePath.push_back($c.track((Object)path.stem((StringRef)DirName).$basic_string()));
                $c.clean();
                TopFrameworkDir = Dir;
            }
            DirectoryEntry directoryEntry = TopFrameworkDir;
            return directoryEntry;
        }
        finally {
            $c.$destroy();
        }
    }

    public static boolean checkMSVCHeaderSearch(DiagnosticsEngine Diags, FileEntry MSFE, FileEntry FE, SourceLocation IncludeLoc) {
        if (MSFE != null && FE != MSFE) {
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)Diags.Report(IncludeLoc, 786L), (char.ptr)MSFE.getName()).$destroy();
            return true;
        }
        return false;
    }

    public static void mergeHeaderFileInfo(HeaderFileInfo HFI, HeaderFileInfo OtherHFI) {
        HFI.isImport |= OtherHFI.isImport;
        HFI.isPragmaOnce |= OtherHFI.isPragmaOnce;
        HFI.isModuleHeader |= OtherHFI.isModuleHeader;
        HFI.NumIncludes = (char)(HFI.NumIncludes + OtherHFI.NumIncludes);
        if (HFI.ControllingMacro == null && HFI.ControllingMacroID == 0L) {
            HFI.ControllingMacro = OtherHFI.ControllingMacro;
            HFI.ControllingMacroID = OtherHFI.ControllingMacroID;
        }
        if (OtherHFI.External) {
            HFI.DirInfo = OtherHFI.DirInfo;
            HFI.External = OtherHFI.External;
            HFI.IndexHeaderMapHeader = OtherHFI.IndexHeaderMapHeader;
        }
        if (HFI.Framework.empty()) {
            HFI.Framework = OtherHFI.Framework;
        }
        HFI.Resolved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileEntry getPrivateModuleMap(FileEntry File2, FileManager FileMgr) {
        SmallString PrivateFilename = null;
        try {
            StringRef Filename = path.filename((StringRef)new StringRef(File2.getName()));
            DirectoryEntry dir = File2.getDir();
            PrivateFilename = new SmallString(new StringRef(dir.getName(), dir.getNameLen()), 128);
            if (llvm.$eq_StringRef((StringRef)Filename, (CharSequence)"module.map")) {
                path.append((SmallString)PrivateFilename, (char.ptr)NativePointer.$((String)"module_private.map"));
            } else if (llvm.$eq_StringRef((StringRef)Filename, (CharSequence)"module.modulemap")) {
                path.append((SmallString)PrivateFilename, (char.ptr)NativePointer.$((String)"module.private.modulemap"));
            } else {
                FileEntry fileEntry = null;
                return fileEntry;
            }
            FileEntry fileEntry = FileMgr.getFile(PrivateFilename.$StringRef());
            return fileEntry;
        }
        finally {
            if (PrivateFilename != null) {
                PrivateFilename.$destroy();
            }
        }
    }
}

