/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.LangOptions;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.lex.MacroInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.impl.MacroDiag;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringRef;

public final class PPDirectivesStatics {
    private static boolean isReservedId(IdentifierInfo II, LangOptions Lang) {
        StringMapEntryBase Text = II.getEntry();
        byte[] keyArray = Text.getKeyArray();
        int keyArrayIndex = Text.getKeyArrayIndex();
        int keyLength = Text.getKeyLength();
        if (keyLength >= 2 && keyArray[0 + keyArrayIndex] == NativePointer.$((char)'_') && (ClangGlobals.isUppercase((byte)keyArray[1 + keyArrayIndex]) || keyArray[1 + keyArrayIndex] == NativePointer.$((char)'_'))) {
            return true;
        }
        return Lang.CPlusPlus && StringRef.find((CharSequence)"__", (byte[])keyArray, (int)keyArrayIndex, (int)keyLength) != StringRef.npos;
    }

    public static MacroDiag shouldWarnOnMacroDef(Preprocessor PP, IdentifierInfo II) {
        LangOptions Lang = PP.getLangOpts();
        if (PPDirectivesStatics.isReservedId(II, Lang)) {
            return MacroDiag.MD_ReservedMacro;
        }
        if (II.isKeyword(Lang)) {
            return MacroDiag.MD_KeywordDef;
        }
        if (Lang.CPlusPlus11 && (II.isStr((CharSequence)"override") || II.isStr((CharSequence)"final"))) {
            return MacroDiag.MD_KeywordDef;
        }
        return MacroDiag.MD_NoWarn;
    }

    public static MacroDiag shouldWarnOnMacroUndef(Preprocessor PP, IdentifierInfo II) {
        LangOptions Lang = PP.getLangOpts();
        if (PPDirectivesStatics.isReservedId(II, Lang)) {
            return MacroDiag.MD_ReservedMacro;
        }
        return MacroDiag.MD_NoWarn;
    }

    public static boolean GetLineValue(Token DigitTok, int.ref Val, long DiagID, Preprocessor PP) {
        return PPDirectivesStatics.GetLineValue(DigitTok, Val, DiagID, PP, false);
    }

    public static boolean GetLineValue(Token DigitTok, int.ref Val, long DiagID, Preprocessor PP, boolean IsGNULineDirective) {
        if (DigitTok.isNot((short)7)) {
            PP.Diag(DigitTok, DiagID).$destroy();
            if (DigitTok.isNot((short)2)) {
                PP.DiscardUntilEndOfDirective();
            }
            return true;
        }
        SmallString IntegerBuffer = new SmallString(64);
        IntegerBuffer.resize(DigitTok.getLength());
        char.ptr DigitTokBegin = IntegerBuffer.data();
        int ActualLength = PP.getSpelling(DigitTok, DigitTokBegin, null);
        if (ActualLength == -1) {
            return true;
        }
        Val.$set(0);
        for (int i = 0; i != ActualLength; ++i) {
            if (DigitTokBegin.$at(i) == NativePointer.$SGL_QUOTE) continue;
            if (!ClangGlobals.isDigit((byte)DigitTokBegin.$at(i))) {
                ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)PP.Diag(PP.AdvanceToTokenCharacter(DigitTok.getRawLocation(), i), 718L), (boolean)IsGNULineDirective).$destroy();
                PP.DiscardUntilEndOfDirective();
                return true;
            }
            int NextVal = Val.$deref() * 10 + (DigitTokBegin.$at(i) - NativePointer.$0);
            if (NextVal < Val.$deref()) {
                PP.Diag(DigitTok, DiagID).$destroy();
                PP.DiscardUntilEndOfDirective();
                return true;
            }
            Val.$set(NextVal);
        }
        if (DigitTokBegin.$at(0) == NativePointer.$0 && Val.$deref() != 0) {
            ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)PP.Diag(DigitTok.getLocation(), 872L), (boolean)IsGNULineDirective).$destroy();
        }
        return false;
    }

    public static boolean ReadLineMarkerFlags(bool.ref IsFileEntry, bool.ref IsFileExit, bool.ref IsSystemHeader, bool.ref IsExternCHeader, Preprocessor PP) {
        int.ref FlagVal = NativePointer.create_int$ref((int)0);
        Token FlagTok = new Token();
        PP.Lex(FlagTok);
        if (FlagTok.is((short)2)) {
            return false;
        }
        if (PPDirectivesStatics.GetLineValue(FlagTok, FlagVal, 722L, PP)) {
            return true;
        }
        if (FlagVal.$deref() == 1) {
            IsFileEntry.$set(true);
            PP.Lex(FlagTok);
            if (FlagTok.is((short)2)) {
                return false;
            }
            if (PPDirectivesStatics.GetLineValue(FlagTok, FlagVal, 722L, PP)) {
                return true;
            }
        } else if (FlagVal.$deref() == 2) {
            IsFileExit.$set(true);
            SourceManager SM = PP.getSourceManager();
            int CurFileID = ClangGlobals.$first_FileID((long)SM.getDecomposedExpansionLoc(FlagTok.getRawLocation()));
            PresumedLoc PLoc = SM.getPresumedLoc(FlagTok.getLocation());
            if (PLoc.isInvalid()) {
                return true;
            }
            int IncLoc = PLoc.getRawIncludeLoc();
            if (SourceLocation.isInvalid((int)IncLoc) || ClangGlobals.$first_FileID((long)SM.getDecomposedExpansionLoc(IncLoc)) != CurFileID) {
                PP.Diag(FlagTok, 723L).$destroy();
                PP.DiscardUntilEndOfDirective();
                return true;
            }
            PP.Lex(FlagTok);
            if (FlagTok.is((short)2)) {
                return false;
            }
            if (PPDirectivesStatics.GetLineValue(FlagTok, FlagVal, 722L, PP)) {
                return true;
            }
        }
        if (FlagVal.$deref() != 3) {
            PP.Diag(FlagTok, 722L).$destroy();
            PP.DiscardUntilEndOfDirective();
            return true;
        }
        IsSystemHeader.$set(true);
        PP.Lex(FlagTok);
        if (FlagTok.is((short)2)) {
            return false;
        }
        if (PPDirectivesStatics.GetLineValue(FlagTok, FlagVal, 722L, PP)) {
            return true;
        }
        if (FlagVal.$deref() != 4) {
            PP.Diag(FlagTok, 722L).$destroy();
            PP.DiscardUntilEndOfDirective();
            return true;
        }
        IsExternCHeader.$set(true);
        PP.Lex(FlagTok);
        if (FlagTok.is((short)2)) {
            return false;
        }
        PP.Diag(FlagTok, 722L).$destroy();
        PP.DiscardUntilEndOfDirective();
        return true;
    }

    public static void EnterAnnotationToken(Preprocessor PP, SourceLocation Begin, SourceLocation End, short Kind2, Object AnnotationVal) {
        Token[] Tok = new Token[1];
        Tok[0].startToken();
        Tok[0].setKind(Kind2);
        Tok[0].setLocation(Begin);
        Tok[0].setAnnotationEndLoc(End);
        Tok[0].setAnnotationValue(AnnotationVal);
        PP.EnterTokenStream(Tok, 0, 1L, true, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConfigurationPattern(Token MacroName, MacroInfo MI, LangOptions LOptions) {
        StringRef ValueText;
        if (MI.getNumTokens() != 1) return (MacroName.is((short)85) || MacroName.is((short)90) || MacroName.is((short)99) || MacroName.is((short)78)) && MI.getNumTokens() == 0;
        Token Value = MI.getReplacementToken(0);
        if (MacroName.getKind() == Value.getKind()) {
            return true;
        }
        StringRef MacroText = MacroName.getIdentifierInfo().getName();
        IdentifierInfo II = Value.getIdentifierInfo();
        if (II == null) return false;
        if (!II.isKeyword(LOptions)) {
            return false;
        }
        StringRef TrimmedValue = ValueText = II.getName();
        if (!ValueText.startswith((CharSequence)"__")) {
            if (!ValueText.startswith((CharSequence)"_")) return false;
            TrimmedValue.$assignMove(TrimmedValue.drop_front(1));
            return TrimmedValue.equals(MacroText);
        } else {
            TrimmedValue.$assignMove(TrimmedValue.drop_front(2));
            if (!TrimmedValue.endswith((CharSequence)"__")) return TrimmedValue.equals(MacroText);
            TrimmedValue.$assignMove(TrimmedValue.drop_back(2));
        }
        return TrimmedValue.equals(MacroText);
    }
}

