/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.groovy.extender;

import java.util.List;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginExecution;
import org.netbeans.modules.maven.model.pom.Project;

public class AddMavenCompilerPlugin
implements ModelOperation<POMModel> {
    private static final String MAVEN_COMPILER_ARTIFACT_ID = "maven-compiler-plugin";
    private static final String MAVEN_COMPILER_VERSION = "2.3.2";
    private static final String GROOVY_ECLIPSE_COMPILER_ARTIFACT_ID = "groovy-eclipse-compiler";
    private static final String GROOVY_ECLIPSE_COMPILER_GROUP_ID = "org.codehaus.groovy";
    private static final String GROOVY_ECLIPSE_COMPILER_VERSION = "2.6.0-01";
    private POMComponentFactory factory;
    private Project project;

    public void performOperation(POMModel model) {
        Plugin plugin;
        this.factory = model.getFactory();
        this.project = model.getProject();
        Build build = this.project.getBuild();
        if (build == null) {
            build = this.factory.createBuild();
            this.project.setBuild(build);
        }
        if ((plugin = this.mavenCompilerPluginExists(build)) == null) {
            build.addPlugin(this.createMavenEclipseCompilerPlugin());
        } else {
            Plugin newPlugin = this.createMavenEclipseCompilerPlugin(plugin);
            build.removePlugin(plugin);
            build.addPlugin(newPlugin);
        }
    }

    private Plugin mavenCompilerPluginExists(Build build) {
        List plugins = build.getPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                if (!MAVEN_COMPILER_ARTIFACT_ID.equals(plugin.getArtifactId()) || !MAVEN_COMPILER_VERSION.equals(plugin.getVersion())) continue;
                return plugin;
            }
        }
        return null;
    }

    private Plugin createMavenEclipseCompilerPlugin() {
        Plugin plugin = this.factory.createPlugin();
        plugin.setArtifactId(MAVEN_COMPILER_ARTIFACT_ID);
        plugin.setVersion(MAVEN_COMPILER_VERSION);
        plugin.setConfiguration(this.createConfiguration());
        plugin.addDependency(this.createDependency());
        return plugin;
    }

    private Configuration createConfiguration() {
        Configuration configuration = this.factory.createConfiguration();
        configuration.setSimpleParameter("compilerId", GROOVY_ECLIPSE_COMPILER_ARTIFACT_ID);
        return configuration;
    }

    private Dependency createDependency() {
        Dependency dependency = this.factory.createDependency();
        dependency.setGroupId(GROOVY_ECLIPSE_COMPILER_GROUP_ID);
        dependency.setArtifactId(GROOVY_ECLIPSE_COMPILER_ARTIFACT_ID);
        dependency.setVersion(GROOVY_ECLIPSE_COMPILER_VERSION);
        return dependency;
    }

    private Plugin createMavenEclipseCompilerPlugin(Plugin plugin) {
        Plugin newPlugin = this.factory.createPlugin();
        newPlugin.setArtifactId(plugin.getArtifactId());
        newPlugin.setGroupId(plugin.getGroupId());
        newPlugin.setVersion(plugin.getVersion());
        this.updateDependency(plugin, newPlugin);
        this.updateConfiguration(plugin, newPlugin);
        return newPlugin;
    }

    private void updateDependency(Plugin oldPlugin, Plugin newPlugin) {
        List dependencies = oldPlugin.getDependencies();
        if (dependencies != null) {
            for (Dependency dependency : dependencies) {
                if (!GROOVY_ECLIPSE_COMPILER_ARTIFACT_ID.equals(dependency.getArtifactId()) || !GROOVY_ECLIPSE_COMPILER_GROUP_ID.equals(dependency.getGroupId())) continue;
                Dependency newDependency = this.factory.createDependency();
                newDependency.setArtifactId(dependency.getArtifactId());
                newDependency.setGroupId(dependency.getGroupId());
                newDependency.setVersion(dependency.getVersion());
                newPlugin.addDependency(newDependency);
                return;
            }
        }
        newPlugin.addDependency(this.createDependency());
    }

    private void updateConfiguration(Plugin oldPlugin, Plugin newPlugin) {
        PluginExecution compileExecution = this.factory.createExecution();
        Configuration compileConfiguration = this.factory.createConfiguration();
        Configuration currentConfiguration = oldPlugin.getConfiguration();
        if (currentConfiguration != null) {
            for (POMExtensibilityElement element : currentConfiguration.getConfigurationElements()) {
                POMExtensibilityElement newElement = this.factory.createPOMExtensibilityElement(element.getQName());
                newElement.setElementText(element.getElementText());
                int position = 0;
                for (POMExtensibilityElement childElement : element.getAnyElements()) {
                    POMExtensibilityElement newChildElement = this.factory.createPOMExtensibilityElement(childElement.getQName());
                    newChildElement.setElementText(childElement.getElementText());
                    newElement.addAnyElement(newChildElement, position++);
                }
                compileConfiguration.addExtensibilityElement(newElement);
            }
        }
        compileExecution.addGoal("compile");
        compileExecution.setId("compileId");
        compileExecution.setConfiguration(compileConfiguration);
        newPlugin.addExecution(compileExecution);
        PluginExecution testCompileExecution = this.factory.createExecution();
        testCompileExecution.addGoal("compile");
        testCompileExecution.addGoal("testCompile");
        testCompileExecution.setId("testCompileId");
        testCompileExecution.setConfiguration(this.createConfiguration());
        newPlugin.addExecution(testCompileExecution);
    }
}

