/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.indent;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.latte.LatteSyntax;
import org.netbeans.modules.php.latte.lexer.LatteMarkupTokenId;
import org.netbeans.modules.php.latte.lexer.LatteTopTokenId;
import org.netbeans.modules.web.indent.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.web.indent.api.support.AbstractIndenter;
import org.netbeans.modules.web.indent.api.support.IndentCommand;
import org.netbeans.modules.web.indent.api.support.IndenterContextData;

public class LatteIndenter
extends AbstractIndenter<LatteTopTokenId> {
    private static final Logger LOGGER = Logger.getLogger(LatteIndenter.class.getName());
    private Stack<LatteStackItem> stack = null;
    private int preservedLineIndentation = -1;

    public LatteIndenter(Context context) {
        super(LatteTopTokenId.language(), context);
    }

    protected int getFormatStableStart(JoinedTokenSequence<LatteTopTokenId> ts, int startOffset, int endOffset, AbstractIndenter.OffsetRanges rangesToIgnore) throws BadLocationException {
        return 0;
    }

    protected List<IndentCommand> getLineIndent(IndenterContextData<LatteTopTokenId> context, List<IndentCommand> preliminaryNextLineIndent) throws BadLocationException {
        Stack<LatteStackItem> blockStack = this.getStack();
        ArrayList<IndentCommand> iis = new ArrayList<IndentCommand>();
        this.getIndentFromState(iis, true, context.getLineStartOffset());
        JoinedTokenSequence ts = context.getJoinedTokenSequences();
        ts.move(context.getLineStartOffset());
        boolean isBlockMacro = false;
        boolean isElseMacro = false;
        boolean afterDelimiter = false;
        boolean nonControlMacro = false;
        int embeddingLevel = 0;
        String lastMacro = "";
        while (!context.isBlankLine() && ts.moveNext() && (ts.isCurrentTokenSequenceVirtual() && ts.offset() < context.getLineEndOffset() || ts.offset() <= context.getLineEndOffset())) {
            Token token = ts.token();
            if (token == null) continue;
            if (ts.embedded() != null) {
                if (embeddingLevel == 1 && afterDelimiter) {
                    if (token.id() == LatteTopTokenId.T_LATTE && context.isIndentThisLine()) {
                        String markupToken = this.getMarkupTokenName((Token<LatteTopTokenId>)token);
                        isBlockMacro = LatteSyntax.isBlockMacro(markupToken) && !LatteIndenter.isShortedBlockMacro((Token<LatteTopTokenId>)token);
                        if (!isBlockMacro) continue;
                        lastMacro = markupToken;
                        isElseMacro = LatteSyntax.isElseMacro(markupToken);
                        continue;
                    }
                    isBlockMacro = false;
                    isElseMacro = false;
                    continue;
                }
                if (token.text().toString().indexOf("\n") != -1) continue;
                nonControlMacro = true;
                continue;
            }
            if (token.id() == LatteTopTokenId.T_LATTE_OPEN_DELIMITER) {
                afterDelimiter = true;
                ++embeddingLevel;
                LatteStackItem state = new LatteStackItem(StackItemState.IN_RULE);
                blockStack.push(state);
                continue;
            }
            if (token.id() == LatteTopTokenId.T_LATTE_CLOSE_DELIMITER) {
                afterDelimiter = false;
                if (!this.isInState(blockStack, StackItemState.IN_RULE)) continue;
                LatteStackItem item = blockStack.pop();
                if (--embeddingLevel != 0) continue;
                assert (item.state == StackItemState.IN_RULE);
                if (!isBlockMacro) continue;
                if (!blockStack.isEmpty() && blockStack.peek().getMacro() != null && LatteSyntax.isRelatedMacro(lastMacro, blockStack.peek().getMacro())) {
                    if (isElseMacro) {
                        String macro = blockStack.pop().getMacro();
                        blockStack.push(new LatteStackItem(StackItemState.IN_BODY, macro));
                    } else {
                        blockStack.pop();
                    }
                    if (!nonControlMacro) {
                        iis.add(new IndentCommand(IndentCommand.Type.RETURN, this.preservedLineIndentation));
                    }
                    nonControlMacro = false;
                    continue;
                }
                blockStack.push(new LatteStackItem(StackItemState.IN_BODY, lastMacro));
                continue;
            }
            if (!this.isCommentToken((Token<LatteTopTokenId>)token)) continue;
            int start = context.getLineStartOffset();
            if (start < ts.offset()) {
                start = ts.offset();
            }
            int commentEndOffset = ts.offset() + ts.token().text().toString().trim().length() - 1;
            int end = context.getLineEndOffset();
            if (end > commentEndOffset) {
                end = commentEndOffset;
            }
            if (start > end) continue;
            if (start == ts.offset()) {
                if (end >= commentEndOffset) continue;
                int lineStart = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)ts.offset());
                this.preservedLineIndentation = start - lineStart;
                continue;
            }
            if (end == commentEndOffset) {
                String text = this.getDocument().getText(start, end - start + 1).trim();
                if (!text.startsWith("*/")) {
                    IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
                    ic.setFixedIndentSize(this.preservedLineIndentation);
                    iis.add(ic);
                }
                this.preservedLineIndentation = -1;
                continue;
            }
            IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
            ic.setFixedIndentSize(this.preservedLineIndentation);
            iis.add(ic);
        }
        if (context.isBlankLine() && iis.isEmpty()) {
            IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
            ic.setFixedIndentSize(this.preservedLineIndentation);
            iis.add(ic);
        }
        if (iis.isEmpty()) {
            iis.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getLineStartOffset()));
        }
        if (context.getNextLineStartOffset() != -1) {
            this.getIndentFromState(preliminaryNextLineIndent, false, context.getNextLineStartOffset());
            if (preliminaryNextLineIndent.isEmpty()) {
                preliminaryNextLineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getNextLineStartOffset()));
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            for (IndentCommand command : iis) {
                LOGGER.log(Level.FINE, command.toString());
            }
        }
        return iis;
    }

    private static boolean isShortedBlockMacro(Token<LatteTopTokenId> token) {
        return token.text().toString().endsWith("/");
    }

    private String getMarkupTokenName(Token<LatteTopTokenId> token) {
        String result = "";
        TokenHierarchy th = TokenHierarchy.create((CharSequence)token.text(), LatteMarkupTokenId.language());
        TokenSequence sequence = th.tokenSequence(LatteMarkupTokenId.language());
        while (sequence.moveNext()) {
            if (sequence.token().id() == LatteMarkupTokenId.T_WHITESPACE) continue;
            result = sequence.token().text().toString();
            break;
        }
        return result;
    }

    private boolean isCommentToken(Token<LatteTopTokenId> token) {
        return token.id() == LatteTopTokenId.T_LATTE_COMMENT || token.id() == LatteTopTokenId.T_LATTE_COMMENT_DELIMITER;
    }

    private void getIndentFromState(List<IndentCommand> iis, boolean updateState, int lineStartOffset) {
        Stack<LatteStackItem> blockStack = this.getStack();
        int lastUnprocessedItem = blockStack.size();
        int i = blockStack.size() - 1;
        while (i >= 0 && !((LatteStackItem)blockStack.get(i)).processed.booleanValue()) {
            lastUnprocessedItem = i--;
        }
        for (i = lastUnprocessedItem; i < blockStack.size(); ++i) {
            IndentCommand ii;
            LatteStackItem item = (LatteStackItem)blockStack.get(i);
            assert (!item.processed.booleanValue()) : item;
            if (item.state == StackItemState.IN_BODY) {
                ii = new IndentCommand(IndentCommand.Type.INDENT, lineStartOffset);
                if (item.indent != -1) {
                    ii.setFixedIndentSize(item.indent);
                }
                iis.add(ii);
                if (!updateState) continue;
                item.processed = Boolean.TRUE;
                continue;
            }
            if (item.state != StackItemState.BODY_FINISHED) continue;
            ii = new IndentCommand(IndentCommand.Type.RETURN, lineStartOffset);
            iis.add(ii);
            if (!updateState) continue;
            item.processed = Boolean.TRUE;
            blockStack.remove(i);
            --i;
        }
    }

    private Stack<LatteStackItem> getStack() {
        return this.stack;
    }

    protected boolean isWhiteSpaceToken(Token<LatteTopTokenId> token) {
        return false;
    }

    protected void reset() {
        this.stack = new Stack();
        this.preservedLineIndentation = -1;
    }

    private boolean isInState(Stack<LatteStackItem> stack, StackItemState state) {
        for (LatteStackItem item : stack) {
            if (item.state != state) continue;
            return true;
        }
        return false;
    }

    private static final class LatteStackItem {
        private StackItemState state;
        private Boolean processed = false;
        private String macro;
        private int indent;

        private LatteStackItem(StackItemState state, String macro) {
            assert (state != StackItemState.IN_BODY || state == StackItemState.IN_BODY && !macro.isEmpty());
            this.macro = macro;
            this.state = state;
            this.indent = -1;
        }

        private LatteStackItem(StackItemState state) {
            this.state = state;
            this.indent = -1;
        }

        public String getMacro() {
            return this.macro;
        }

        public String toString() {
            return "LatteStackItem[state=" + (Object)((Object)this.state) + ",indent=" + this.indent + ",processed=" + this.processed + ",command=" + this.macro + "]";
        }
    }

    private static enum StackItemState {
        IN_BODY,
        IN_RULE,
        IN_VALUE,
        RULE_FINISHED,
        BODY_FINISHED;

    }
}

