/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.spi;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.DLightLibsCommonLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProviderImplementation;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class FileSystemProvider {
    private static final Collection<FileSystemProviderImplementation> ALL_PROVIDERS = new ArrayList<FileSystemProviderImplementation>(Lookup.getDefault().lookupAll(FileSystemProviderImplementation.class));

    private FileSystemProvider() {
    }

    public static FileSystem getFileSystem(ExecutionEnvironment env) {
        return FileSystemProvider.getFileSystem(env, "/");
    }

    public static ExecutionEnvironment getExecutionEnvironment(FileSystem fileSystem) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            return provider.getExecutionEnvironment(fileSystem);
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    public static ExecutionEnvironment getExecutionEnvironment(FileObject fileObject) {
        try {
            return FileSystemProvider.getExecutionEnvironment(fileObject.getFileSystem());
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return ExecutionEnvironmentFactory.getLocal();
        }
    }

    public static FileSystem getFileSystem(ExecutionEnvironment env, String root) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            return provider.getFileSystem(env, root);
        }
        FileSystemProvider.noProvidersWarning(env);
        return null;
    }

    public static boolean waitWrites(ExecutionEnvironment env, Collection<FileObject> filesToWait, Collection<String> failedFiles) throws InterruptedException {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            return provider.waitWrites(env, filesToWait, failedFiles);
        }
        FileSystemProvider.noProvidersWarning(env);
        return true;
    }

    public static boolean waitWrites(ExecutionEnvironment env, Collection<String> failedFiles) throws InterruptedException {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            return provider.waitWrites(env, failedFiles);
        }
        FileSystemProvider.noProvidersWarning(env);
        return true;
    }

    public static String normalizeAbsolutePath(String absPath, ExecutionEnvironment env) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            return provider.normalizeAbsolutePath(absPath, env);
        }
        FileSystemProvider.noProvidersWarning(env);
        return FileUtil.normalizePath((String)absPath);
    }

    public static String normalizeAbsolutePath(String absPath, FileSystem fileSystem) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            return provider.normalizeAbsolutePath(absPath, fileSystem);
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
        return FileUtil.normalizePath((String)absPath);
    }

    public static FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(baseFileObject)) continue;
            return provider.getFileObject(baseFileObject, relativeOrAbsolutePath);
        }
        FileSystemProvider.noProvidersWarning(baseFileObject);
        if (FileSystemProvider.isAbsolute(relativeOrAbsolutePath)) {
            try {
                return baseFileObject.getFileSystem().findResource(relativeOrAbsolutePath);
            }
            catch (FileStateInvalidException ex) {
                return null;
            }
        }
        return baseFileObject.getFileObject(relativeOrAbsolutePath);
    }

    public static FileObject getFileObject(ExecutionEnvironment env, String absPath) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            return provider.getFileSystem(env, "/").findResource(absPath);
        }
        FileSystemProvider.noProvidersWarning(env);
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(absPath)));
    }

    public static FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileObject)) continue;
            return provider.getCanonicalFileObject(fileObject);
        }
        FileSystemProvider.noProvidersWarning(fileObject);
        return fileObject;
    }

    public static String getCanonicalPath(FileObject fileObject) throws IOException {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileObject)) continue;
            return provider.getCanonicalPath(fileObject);
        }
        FileSystemProvider.noProvidersWarning(fileObject);
        return fileObject.getPath();
    }

    public static String getCanonicalPath(FileSystem fileSystem, String absPath) throws IOException {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            return provider.getCanonicalPath(fileSystem, absPath);
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
        return absPath;
    }

    public static String getCanonicalPath(ExecutionEnvironment env, String absPath) throws IOException {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            return provider.getCanonicalPath(env, absPath);
        }
        FileSystemProvider.noProvidersWarning(env);
        return absPath;
    }

    public static boolean isAbsolute(ExecutionEnvironment env, String path) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            return provider.isAbsolute(path);
        }
        return true;
    }

    public static boolean isAbsolute(FileSystem fileSystem, String path) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            return provider.isAbsolute(path);
        }
        return true;
    }

    public static boolean isLink(FileSystem fileSystem, String path) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            return provider.isLink(fileSystem, path);
        }
        return false;
    }

    public static boolean isLink(ExecutionEnvironment env, String path) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            return provider.isLink(env, path);
        }
        return false;
    }

    public static boolean isLink(FileObject fo) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fo)) continue;
            return provider.isLink(fo);
        }
        return false;
    }

    public static String resolveLink(FileObject fo) throws IOException {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fo)) continue;
            return provider.resolveLink(fo);
        }
        return null;
    }

    public static boolean isAbsolute(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        return path.indexOf(58) == 1 && Utilities.isWindows();
    }

    public static FileObject fileToFileObject(File file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(file)) continue;
            return provider.fileToFileObject(file);
        }
        FileSystemProvider.noProvidersWarning(file);
        return FileUtil.toFileObject((File)file);
    }

    public static FileSystem getFileSystem(URI uri) {
        Parameters.notNull((CharSequence)"file", (Object)uri);
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(uri)) continue;
            return provider.getFileSystem(uri);
        }
        FileSystemProvider.noProvidersWarning(uri);
        return null;
    }

    public static FileObject urlToFileObject(String url) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(url)) continue;
            return provider.urlToFileObject(url);
        }
        FileSystemProvider.noProvidersWarning(url);
        return null;
    }

    public static FileSystem urlToFileSystem(String url) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(url)) continue;
            return provider.urlToFileSystem(url);
        }
        FileSystemProvider.noProvidersWarning(url);
        return null;
    }

    public static String toUrl(FileSystem fileSystem, String absPath) {
        Parameters.notNull((CharSequence)"fileSystem", (Object)fileSystem);
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            return provider.toURL(fileSystem, absPath);
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
        return absPath;
    }

    public static String fileObjectToUrl(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileObject)) continue;
            return provider.toURL(fileObject);
        }
        FileSystemProvider.noProvidersWarning(fileObject);
        try {
            return fileObject.getURL().toExternalForm();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static void refresh(FileObject fileObject, boolean recursive) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileObject)) continue;
            provider.refresh(fileObject, recursive);
            return;
        }
        FileSystemProvider.noProvidersWarning(fileObject);
    }

    public static void scheduleRefresh(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileObject)) continue;
            provider.scheduleRefresh(fileObject);
            return;
        }
        FileSystemProvider.noProvidersWarning(fileObject);
    }

    public static void scheduleRefresh(ExecutionEnvironment env, Collection<String> paths) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            provider.scheduleRefresh(env, paths);
            return;
        }
        FileSystemProvider.noProvidersWarning(env);
    }

    public static void addRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        FileSystemProvider.addRecursiveListener(listener, fileSystem, absPath, null, null);
    }

    public static void addRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath, FileFilter recurseInto, Callable<Boolean> interrupter) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            absPath = provider.normalizeAbsolutePath(absPath, fileSystem);
            try {
                provider.addRecursiveListener(listener, fileSystem, absPath, recurseInto, interrupter);
            }
            catch (Throwable e) {
                DLightLibsCommonLogger.printStackTraceOnce((Throwable)e, (Level)Level.INFO, (boolean)true);
            }
            return;
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
    }

    public static void removeRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            absPath = provider.normalizeAbsolutePath(absPath, fileSystem);
            try {
                provider.removeRecursiveListener(listener, fileSystem, absPath);
            }
            catch (Throwable e) {
                DLightLibsCommonLogger.printStackTraceOnce((Throwable)e, (Level)Level.INFO, (boolean)true);
            }
            return;
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
    }

    public static boolean canExecute(FileObject fileObject) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileObject)) continue;
            return provider.canExecute(fileObject);
        }
        FileSystemProvider.noProvidersWarning(fileObject);
        return true;
    }

    public static void addFileChangeListener(FileChangeListener listener, FileSystem fileSystem, String path) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            provider.addFileChangeListener(listener, fileSystem, path);
            return;
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
    }

    public static void addFileChangeListener(FileChangeListener listener, ExecutionEnvironment env, String path) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            provider.addFileChangeListener(listener, env, path);
            return;
        }
        FileSystemProvider.noProvidersWarning(env);
    }

    public static void addFileChangeListener(FileChangeListener listener) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            provider.addFileChangeListener(listener);
        }
    }

    public static void removeFileChangeListener(FileChangeListener listener) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            provider.removeFileChangeListener(listener);
        }
    }

    public static void addFileSystemProblemListener(FileSystemProblemListener listener) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            provider.addFileSystemProblemListener(listener);
        }
    }

    public static void addFileSystemProblemListener(FileSystemProblemListener listener, FileSystem fileSystem) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            provider.addFileSystemProblemListener(listener, fileSystem);
        }
    }

    public static void removeFileSystemProblemListener(FileSystemProblemListener listener, FileSystem fileSystem) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            provider.removeFileSystemProblemListener(listener, fileSystem);
        }
    }

    public static char getFileSeparatorChar(FileSystem fileSystem) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileSystem)) continue;
            return provider.getFileSeparatorChar();
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
        return '/';
    }

    public static char getFileSeparatorChar(ExecutionEnvironment env) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            return provider.getFileSeparatorChar();
        }
        FileSystemProvider.noProvidersWarning(env);
        return '/';
    }

    public static char getFileSeparatorChar(FileObject fileObject) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fileObject)) continue;
            return provider.getFileSeparatorChar();
        }
        FileSystemProvider.noProvidersWarning(fileObject);
        return '/';
    }

    public static void warmup(WarmupMode mode, ExecutionEnvironment env, Collection<String> paths, Collection<String> extensions) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(env)) continue;
            provider.warmup(mode, env, paths, extensions);
        }
    }

    public static InputStream getInputStream(FileObject fo, int maxSize) throws IOException {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fo)) continue;
            return provider.getInputStream(fo, maxSize);
        }
        return fo.getInputStream();
    }

    public static boolean canSetAccessCheckType(ExecutionEnvironment execEnv) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(execEnv)) continue;
            return provider.canSetAccessCheckType(execEnv);
        }
        FileSystemProvider.noProvidersWarning(execEnv);
        return false;
    }

    public static void setAccessCheckType(ExecutionEnvironment execEnv, AccessCheckType accessCheckType) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(execEnv)) continue;
            provider.setAccessCheckType(execEnv, accessCheckType);
            return;
        }
        FileSystemProvider.noProvidersWarning(execEnv);
    }

    public static Stat getStat(FileObject fo) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(fo)) continue;
            return provider.getStat(fo);
        }
        FileSystemProvider.noProvidersWarning(fo);
        return Stat.createInvalid();
    }

    public static AccessCheckType getAccessCheckType(ExecutionEnvironment execEnv) {
        for (FileSystemProviderImplementation provider : ALL_PROVIDERS) {
            if (!provider.isMine(execEnv)) continue;
            return provider.getAccessCheckType(execEnv);
        }
        FileSystemProvider.noProvidersWarning(execEnv);
        return null;
    }

    private static void noProvidersWarning(Object object) {
        if (RemoteLogger.getInstance().isLoggable(Level.FINE)) {
            if (RemoteLogger.getInstance().isLoggable(Level.FINEST)) {
                String message = "No file system providers for " + object;
                RemoteLogger.getInstance().log(Level.FINEST, message, new Exception(message));
            } else {
                RemoteLogger.getInstance().log(Level.FINE, "No file system providers for {0}", object);
            }
        }
    }

    public static enum WarmupMode {
        FILES_CONTENT,
        RECURSIVE_LS;

    }

    public static enum AccessCheckType {
        FAST,
        FULL;


        public String getDisplayName() {
            switch (this) {
                case FAST: {
                    return NbBundle.getMessage(FileSystemProvider.class, (String)"AccessType_Fast");
                }
                case FULL: {
                    return NbBundle.getMessage(FileSystemProvider.class, (String)"AccessType_Full");
                }
            }
            throw new IllegalArgumentException("Unexpected access type: " + (Object)((Object)this));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public static final class Stat {
        public final long inode;
        public final long device;

        private Stat(long device, long inode) {
            this.inode = inode;
            this.device = device;
        }

        public static Stat create(long device, long inode) {
            return new Stat(device, inode);
        }

        public static Stat createInvalid() {
            return new Stat(-1L, -1L);
        }

        public boolean isValid() {
            return this.inode >= 0L;
        }

        public String toString() {
            return "Stat(dev=" + this.device + ",ino=" + this.device + ')';
        }
    }

    public static interface FileSystemProblemListener {
        public void problemOccurred(FileSystem var1, String var2);

        public void recovered(FileSystem var1);
    }
}

