/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.support;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.zip.Adler32;
import org.netbeans.modules.dlight.libs.common.DLightLibsCommonLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileObjectBasedFile;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.spi.FileSystemProviderImplementation;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class LocalFileSystemProvider
implements FileSystemProviderImplementation {
    private static final String FILE_PROTOCOL = "file";
    private static final String FILE_PROTOCOL_PREFIX = "file:";
    private static final Path ROOT_PATH = Paths.get("/", new String[0]);
    private FileSystem rootFileSystem = null;
    private final Map<String, LocalFileSystem> nonRootFileSystems = new HashMap<String, LocalFileSystem>();
    private final boolean isWindows = Utilities.isWindows();
    private static final RequestProcessor RP = new RequestProcessor(LocalFileSystemProvider.class.getSimpleName());
    private static volatile RequestProcessor.Task lastRefreshTask;

    @Override
    public String normalizeAbsolutePath(String absPath, ExecutionEnvironment env) {
        return FileUtil.normalizePath((String)absPath);
    }

    @Override
    public String normalizeAbsolutePath(String absPath, FileSystem fileSystem) {
        return FileUtil.normalizePath((String)absPath);
    }

    @Override
    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    @Override
    public FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        String absPath = FileSystemProvider.isAbsolute(relativeOrAbsolutePath) ? relativeOrAbsolutePath : baseFileObject.getPath() + File.separatorChar + relativeOrAbsolutePath.toString();
        return FileUtil.toFileObject((File)new File(FileUtil.normalizePath((String)absPath)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getRootFileSystem() {
        if (this.rootFileSystem == null) {
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile("NetBeans", ".tmp");
                tmpFile = FileUtil.normalizeFile((File)tmpFile);
                FileObject fo = FileUtil.toFileObject((File)tmpFile);
                this.rootFileSystem = fo.getFileSystem();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
        return this.rootFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(ExecutionEnvironment env, String root) {
        if (env.isLocal()) {
            LocalFileSystemProvider localFileSystemProvider = this;
            synchronized (localFileSystemProvider) {
                if ("/".equals(root) || "".equals(root)) {
                    return this.getRootFileSystem();
                }
                LocalFileSystem fs = this.nonRootFileSystems.get(root);
                if (fs == null) {
                    fs = new LocalFileSystem();
                    try {
                        fs.setRootDirectory(new File(root));
                        this.nonRootFileSystems.put(root, fs);
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return fs;
            }
        }
        return null;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        assert (this.isMine(uri));
        return this.getFileSystem(ExecutionEnvironmentFactory.getLocal(), uri.getPath());
    }

    @Override
    public FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        RemoteLogger.assertTrueInConsole(file != null, "null file for fileObject " + fileObject);
        if (file == null) {
            return fileObject;
        }
        File canonicalFile = file.getCanonicalFile();
        if (canonicalFile.equals(file)) {
            return fileObject;
        }
        FileObject canonicalFileObject = FileUtil.toFileObject((File)canonicalFile);
        RemoteLogger.assertTrueInConsole(canonicalFileObject != null, "null canonical file object for file " + canonicalFile);
        return canonicalFileObject == null ? fileObject : canonicalFileObject;
    }

    @Override
    public String getCanonicalPath(FileObject fileObject) throws IOException {
        return this.getCanonicalFileObject(fileObject).getPath();
    }

    @Override
    public String getCanonicalPath(FileSystem fs, String absPath) throws IOException {
        return new File(absPath).getCanonicalPath();
    }

    @Override
    public String getCanonicalPath(ExecutionEnvironment env, String absPath) throws IOException {
        RemoteLogger.assertTrueInConsole(env.isLocal(), this.getClass().getSimpleName() + ".getCanonicalPath is called for REMOTE env: " + env);
        return new File(absPath).getCanonicalPath();
    }

    @Override
    public boolean isMine(ExecutionEnvironment env) {
        return env.isLocal();
    }

    @Override
    public ExecutionEnvironment getExecutionEnvironment(FileSystem fileSystem) {
        return ExecutionEnvironmentFactory.getLocal();
    }

    @Override
    public boolean isMine(FileObject fileObject) {
        try {
            return this.isMine(fileObject.getFileSystem());
        }
        catch (FileStateInvalidException ex) {
            RemoteLogger.getInstance().log(Level.WARNING, ex.getLocalizedMessage(), ex);
            return false;
        }
    }

    @Override
    public boolean isMine(FileSystem fileSystem) {
        if (fileSystem instanceof LocalFileSystem) {
            return true;
        }
        FileSystem rootFS = this.getRootFileSystem();
        return rootFS != null && rootFS.getClass() == fileSystem.getClass();
    }

    @Override
    public boolean isMine(String absoluteURL) {
        if (absoluteURL.length() == 0) {
            return true;
        }
        if (absoluteURL.startsWith(FILE_PROTOCOL_PREFIX)) {
            return true;
        }
        if (this.isWindows) {
            return absoluteURL.length() > 1 && absoluteURL.charAt(1) == ':';
        }
        return absoluteURL.startsWith("/");
    }

    @Override
    public boolean waitWrites(ExecutionEnvironment env, Collection<String> failedFiles) throws InterruptedException {
        return true;
    }

    @Override
    public boolean waitWrites(ExecutionEnvironment env, Collection<FileObject> filesToWait, Collection<String> failedFiles) throws InterruptedException {
        return true;
    }

    @Override
    public FileObject urlToFileObject(String absoluteURL) {
        File file;
        DLightLibsCommonLogger.assertNonUiThreadOnce((Level)Level.INFO);
        String path = absoluteURL;
        if (path.startsWith(FILE_PROTOCOL_PREFIX)) {
            try {
                URL u = new URL(path);
                file = FileUtil.normalizeFile((File)Utilities.toFile((URI)u.toURI()));
            }
            catch (IllegalArgumentException ex) {
                RemoteLogger.getInstance().log(Level.WARNING, "LocalFileSystemProvider.urlToFileObject can not convert {0}:\n{1}", new Object[]{absoluteURL, ex.getLocalizedMessage()});
                return null;
            }
            catch (URISyntaxException ex) {
                RemoteLogger.getInstance().log(Level.WARNING, "LocalFileSystemProvider.urlToFileObject can not convert {0}:\n{1}", new Object[]{absoluteURL, ex.getLocalizedMessage()});
                return null;
            }
            catch (MalformedURLException ex) {
                RemoteLogger.getInstance().log(Level.WARNING, "LocalFileSystemProvider.urlToFileObject can not convert {0}:\n{1}", new Object[]{absoluteURL, ex.getLocalizedMessage()});
                return null;
            }
        } else {
            file = new File(FileUtil.normalizePath((String)path));
        }
        try {
            return FileUtil.toFileObject((File)file);
        }
        catch (Throwable ex) {
            RemoteLogger.getInstance().log(Level.WARNING, "LocalFileSystemProvider.urlToFileObject can not convert {0}:\n{1}", new Object[]{absoluteURL, ex.getLocalizedMessage()});
            return null;
        }
    }

    @Override
    public FileSystem urlToFileSystem(String rootUrl) {
        if (rootUrl.isEmpty()) {
            return this.getRootFileSystem();
        }
        FileObject root = this.urlToFileObject(rootUrl);
        if (root != null) {
            try {
                return root.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                RemoteLogger.getInstance().log(Level.WARNING, "LocalFileSystemProvider.urlToFileSystem can not convert {0}:\n{1}", new Object[]{rootUrl, ex.getLocalizedMessage()});
                return null;
            }
        }
        return null;
    }

    @Override
    public String toURL(FileObject fileObject) {
        return fileObject.getPath();
    }

    @Override
    public String toURL(FileSystem fileSystem, String absPath) {
        return absPath;
    }

    @Override
    public FileObject fileToFileObject(File file) {
        file = FileUtil.normalizeFile((File)file);
        return FileUtil.toFileObject((File)file);
    }

    @Override
    public boolean isMine(File file) {
        return file.getClass() != FileObjectBasedFile.class;
    }

    @Override
    public boolean isMine(URI uri) {
        return uri.getScheme().equals(FILE_PROTOCOL);
    }

    @Override
    public void refresh(FileObject fileObject, boolean recursive) {
        fileObject.refresh();
    }

    @Override
    public void scheduleRefresh(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        this.scheduleRefresh(file);
    }

    @Override
    public void scheduleRefresh(ExecutionEnvironment env, Collection<String> paths) {
        RemoteLogger.assertTrue(env.isLocal());
        File[] files = new File[paths.size()];
        int pos = 0;
        for (String path : paths) {
            files[pos++] = new File(path);
        }
        this.scheduleRefresh(files);
    }

    private void scheduleRefresh(final File ... files) {
        lastRefreshTask = RP.post(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])files);
            }
        });
    }

    @Override
    public void addRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        this.addRecursiveListener(listener, fileSystem, absPath, null, null);
    }

    @Override
    public void addRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath, FileFilter recurseInto, Callable<Boolean> interrupter) {
        File file = new File(absPath);
        FileUtil.addRecursiveListener((FileChangeListener)listener, (File)file, (FileFilter)recurseInto, interrupter);
    }

    @Override
    public void removeRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        File file = new File(absPath);
        FileUtil.removeRecursiveListener((FileChangeListener)listener, (File)file);
    }

    @Override
    public boolean canExecute(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        return file == null ? false : file.canExecute();
    }

    @Override
    public void addFileChangeListener(FileChangeListener listener, FileSystem fileSystem, String path) {
        this.addFileChangeListener(path, listener);
    }

    @Override
    public void addFileChangeListener(FileChangeListener listener, ExecutionEnvironment env, String path) {
        this.addFileChangeListener(path, listener);
    }

    private void addFileChangeListener(String path, FileChangeListener listener) {
        File file = new File(path);
        file = FileUtil.normalizeFile((File)file);
        FileUtil.addFileChangeListener((FileChangeListener)listener, (File)file);
    }

    @Override
    public void addFileChangeListener(FileChangeListener listener) {
        FileUtil.addFileChangeListener((FileChangeListener)listener);
    }

    @Override
    public void removeFileChangeListener(FileChangeListener listener) {
        FileUtil.removeFileChangeListener((FileChangeListener)listener);
    }

    public static void testWaitLastRefreshFinished() {
        RequestProcessor.Task task = lastRefreshTask;
        if (task != null) {
            task.waitFinished();
        }
    }

    @Override
    public char getFileSeparatorChar() {
        return File.separatorChar;
    }

    @Override
    public void addFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener, FileSystem fileSystem) {
    }

    @Override
    public void addFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener) {
    }

    @Override
    public void removeFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener, FileSystem fileSystem) {
    }

    @Override
    public void warmup(FileSystemProvider.WarmupMode mode, ExecutionEnvironment env, Collection<String> paths, Collection<String> extensions) {
    }

    @Override
    public boolean isLink(FileSystem fileSystem, String path) {
        return LocalFileSystemProvider.isLink(path);
    }

    @Override
    public boolean isLink(ExecutionEnvironment env, String path) {
        return LocalFileSystemProvider.isLink(path);
    }

    @Override
    public boolean isLink(FileObject fo) {
        return LocalFileSystemProvider.isLink(fo.getPath());
    }

    private static boolean isLink(String path) {
        Path filePath = Paths.get(Utilities.toURI((File)new File(path)));
        return Files.isSymbolicLink(filePath);
    }

    @Override
    public String resolveLink(FileObject fo) throws IOException {
        final Path filePath = Paths.get(fo.toURI());
        if (Files.isSymbolicLink(filePath)) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws IOException {
                        Path linkPath = Files.readSymbolicLink(filePath);
                        if (!linkPath.isAbsolute()) {
                            linkPath = filePath.getParent().resolve(linkPath).normalize();
                        }
                        return linkPath.toFile().getAbsolutePath();
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return null;
    }

    @Override
    public InputStream getInputStream(FileObject fo, int maxSize) throws IOException {
        return fo.getInputStream();
    }

    @Override
    public boolean canSetAccessCheckType(ExecutionEnvironment execEnv) {
        return false;
    }

    @Override
    public void setAccessCheckType(ExecutionEnvironment execEnv, FileSystemProvider.AccessCheckType accessCheckType) {
    }

    @Override
    public FileSystemProvider.AccessCheckType getAccessCheckType(ExecutionEnvironment execEnv) {
        return null;
    }

    @Override
    public FileSystemProvider.Stat getStat(FileObject fo) {
        if (Utilities.isWindows()) {
            Adler32 cs = new Adler32();
            String path = fo.getPath();
            for (int i = 0; i < path.length(); ++i) {
                cs.update(path.charAt(i));
            }
            return FileSystemProvider.Stat.create(Long.MIN_VALUE, cs.getValue());
        }
        Path path = ROOT_PATH.resolve(fo.getPath());
        if (Files.exists(path, new LinkOption[0])) {
            try {
                long st_ino = ((Number)Files.getAttribute(path, "unix:ino", new LinkOption[0])).longValue();
                long st_dev = ((Number)Files.getAttribute(path, "unix:dev", new LinkOption[0])).longValue();
                return FileSystemProvider.Stat.create(st_dev, st_ino);
            }
            catch (IOException ex) {
                RemoteLogger.finest(ex);
            }
        }
        return FileSystemProvider.Stat.createInvalid();
    }
}

