/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.basic;

import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.basic.ArrayValueView;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class StringDetailsProvider
extends DetailsProvider.Basic {
    static final String STRING_MASK = "java.lang.String";
    static final String BUILDERS_MASK = "java.lang.AbstractStringBuilder+";

    public StringDetailsProvider() {
        super(STRING_MASK, BUILDERS_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (STRING_MASK.equals(className)) {
            int offset = DetailsUtils.getIntFieldValue(instance, "offset", 0);
            int count = DetailsUtils.getIntFieldValue(instance, "count", -1);
            return DetailsUtils.getPrimitiveArrayFieldString(instance, "value", offset, count, null, "...");
        }
        if (BUILDERS_MASK.equals(className)) {
            int count = DetailsUtils.getIntFieldValue(instance, "count", -1);
            return DetailsUtils.getPrimitiveArrayFieldString(instance, "value", 0, count, null, "...");
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String className, Instance instance, Heap heap) {
        return new ArrayValueView(className, instance, heap);
    }
}

