/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.addproperty;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.JButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.GuardedException;
import org.netbeans.modules.beans.addproperty.AddPropertyConfig;
import org.netbeans.modules.beans.addproperty.AddPropertyGenerator;
import org.netbeans.modules.beans.addproperty.AddPropertyPanel;
import org.netbeans.modules.beans.addproperty.GeneratorUtils;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AddPropertyCodeGenerator
implements CodeGenerator {
    private JTextComponent component;
    private String className;
    private List<String> existingFields;
    private String[] pcsName;
    private String[] vcsName;

    public AddPropertyCodeGenerator(JTextComponent component, String className, List<String> existingFields, String[] pcsName, String[] vcsName) {
        this.component = component;
        this.className = className;
        this.existingFields = existingFields;
        this.pcsName = pcsName;
        this.vcsName = vcsName;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AddPropertyCodeGenerator.class, (String)"DN_AddProperty");
    }

    public void invoke() {
        Object o = this.component.getDocument().getProperty("stream");
        if (o instanceof DataObject) {
            DataObject d = (DataObject)o;
            this.perform(d.getPrimaryFile(), this.component);
        }
    }

    public void perform(FileObject file, JTextComponent pane) {
        JButton ok = new JButton(NbBundle.getMessage(AddPropertyCodeGenerator.class, (String)"LBL_ButtonOK"));
        CodeStyle cs = CodeStyle.getDefault((Document)pane.getDocument());
        if (cs == null) {
            cs = CodeStyle.getDefault((FileObject)file);
        }
        AddPropertyPanel addPropertyPanel = new AddPropertyPanel(file, this.className, cs, this.existingFields, this.pcsName, this.vcsName, ok);
        String caption = NbBundle.getMessage(AddPropertyCodeGenerator.class, (String)"CAP_AddProperty");
        String cancel = NbBundle.getMessage(AddPropertyCodeGenerator.class, (String)"LBL_ButtonCancel");
        DialogDescriptor dd = new DialogDescriptor((Object)addPropertyPanel, caption, true, new Object[]{ok, cancel}, (Object)ok, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == ok) {
            AddPropertyCodeGenerator.insertCode2(file, pane, addPropertyPanel.getAddPropertyConfig(), cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void insertCode2(FileObject file, final JTextComponent pane, AddPropertyConfig config, CodeStyle cs) {
        final Document doc = pane.getDocument();
        final Reformat r = Reformat.get((Document)pane.getDocument());
        final String code = new AddPropertyGenerator().generate(config, cs);
        final Position[] bounds = new Position[2];
        final int[] offset = new int[2];
        try {
            JavaSource.forFileObject((FileObject)file).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    TreePath path;
                    parameter.toPhase(JavaSource.Phase.PARSED);
                    Trees trees = parameter.getTrees();
                    TreeUtilities treeUtils = parameter.getTreeUtilities();
                    offset[0] = pane.getCaretPosition();
                    offset[1] = -1;
                    if (path == null || path.getLeaf().getKind() == Tree.Kind.CLASS) {
                        return;
                    }
                    CompilationUnitTree cut = path.getCompilationUnit();
                    if (path.getLeaf().getKind() != Tree.Kind.ENUM) {
                        for (path = parameter.getTreeUtilities().pathFor(offset[0]); path != null && path.getParentPath() != null && path.getParentPath().getLeaf().getKind() != Tree.Kind.CLASS && path.getParentPath().getLeaf().getKind() != Tree.Kind.ENUM; path = path.getParentPath()) {
                        }
                    }
                    int enumconstantEnd = -1;
                    int otherStart = -1;
                    if (path.getLeaf().getKind() == Tree.Kind.ENUM || path.getParentPath() != null && path.getParentPath().getLeaf().getKind() == Tree.Kind.ENUM) {
                        int semicolon;
                        TreePath clazzPath = path.getLeaf().getKind() != Tree.Kind.ENUM ? path.getParentPath() : path;
                        ClassTree clazz = (ClassTree)clazzPath.getLeaf();
                        for (Tree tree : clazz.getMembers()) {
                            Element element;
                            TreePath treePath = new TreePath(clazzPath, tree);
                            if (treeUtils.isSynthetic(treePath)) continue;
                            if (tree.getKind() == Tree.Kind.VARIABLE && (element = trees.getElement(treePath)) != null && element.getKind() == ElementKind.ENUM_CONSTANT) {
                                int endPosition = (int)trees.getSourcePositions().getEndPosition(cut, tree);
                                enumconstantEnd = Math.max(enumconstantEnd, endPosition);
                                continue;
                            }
                            if (otherStart != -1) continue;
                            otherStart = (int)trees.getSourcePositions().getStartPosition(cut, tree);
                        }
                        if (enumconstantEnd == -1) {
                            enumconstantEnd = treeUtils.findBodySpan(clazz)[0] + 1;
                        }
                        if (otherStart == -1) {
                            otherStart = (int)trees.getSourcePositions().getEndPosition(cut, clazz);
                        }
                        if ((semicolon = AddPropertyCodeGenerator.scanForSemicolon(doc, offset, enumconstantEnd, otherStart)) == -1) {
                            offset[1] = enumconstantEnd;
                            if (offset[0] <= enumconstantEnd) {
                                offset[0] = enumconstantEnd + 1;
                            }
                        } else if (offset[0] <= semicolon) {
                            offset[0] = semicolon + 1;
                        } else if (path.getLeaf().getKind() != Tree.Kind.ENUM) {
                            Tree tree = path.getLeaf();
                            offset[0] = (int)trees.getSourcePositions().getEndPosition(cut, tree);
                        }
                        return;
                    }
                    Tree current = path.getLeaf();
                    offset[0] = (int)trees.getSourcePositions().getEndPosition(cut, current);
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        r.lock();
        try {
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        GuardedSectionManager manager = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)doc));
                        if (manager != null) {
                            for (GuardedSection guard : manager.getGuardedSections()) {
                                if (!guard.contains(doc.createPosition(offset[0]), true)) continue;
                                offset[0] = guard.getEndPosition().getOffset() + 1;
                                break;
                            }
                        }
                        doc.insertString(offset[0], code, null);
                        if (offset[1] != -1) {
                            doc.insertString(offset[1], ";", null);
                        }
                        Position start = doc.createPosition(offset[0]);
                        Position end = doc.createPosition(offset[0] + code.length());
                        r.reformat(start.getOffset(), end.getOffset());
                        bounds[0] = start;
                        bounds[1] = end;
                    }
                    catch (GuardedException ex) {
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            r.unlock();
        }
        if (bounds[0] != null) {
            try {
                JavaSource.forFileObject((FileObject)file).runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        Position start = bounds[0];
                        Position end = bounds[1];
                        new ImportFQNsHack(workingCopy, start.getOffset(), end.getOffset()).scan(workingCopy.getCompilationUnit(), null);
                        CompilationUnitTree cut = workingCopy.getCompilationUnit();
                        workingCopy.rewrite((Tree)cut, (Tree)workingCopy.getTreeMaker().CompilationUnit(cut.getPackageAnnotations(), cut.getPackageName(), cut.getImports(), cut.getTypeDecls(), cut.getSourceFile()));
                    }
                }).commit();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static int scanForSemicolon(Document doc, int[] offset, int start, int end) throws BadLocationException {
        int tokenOffset;
        TokenSequence seq;
        TokenHierarchy th = doc != null ? TokenHierarchy.get((Document)doc) : null;
        List embeddedSequences = th != null ? th.embeddedTokenSequences(offset[0], false) : null;
        TokenSequence tokenSequence = seq = embeddedSequences != null ? (TokenSequence)embeddedSequences.get(embeddedSequences.size() - 1) : null;
        if (seq == null) {
            return offset[0];
        }
        seq.move(start);
        int semicolon = -1;
        while (seq.moveNext() && (tokenOffset = seq.offset()) <= end) {
            Token t = seq.token();
            if (t == null || t.id() != JavaTokenId.SEMICOLON) continue;
            semicolon = tokenOffset;
            break;
        }
        return semicolon;
    }

    public static final class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            TreePath path;
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController cc = (CompilationController)context.lookup(CompilationController.class);
            for (path = (TreePath)context.lookup(TreePath.class); path != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()); path = path.getParentPath()) {
            }
            if (component == null || cc == null || path == null) {
                return Collections.emptyList();
            }
            Element e = cc.getTrees().getElement(path);
            if (e == null || !e.getKind().isClass()) {
                return Collections.emptyList();
            }
            TypeMirror pcs = Factory.resolve((CompilationInfo)cc, "java.beans.PropertyChangeSupport");
            TypeMirror vcs = Factory.resolve((CompilationInfo)cc, "java.beans.VetoableChangeSupport");
            if (pcs == null || vcs == null) {
                return Collections.emptyList();
            }
            LinkedList<String> existingFields = new LinkedList<String>();
            String[] pcsName = new String[2];
            String[] vcsName = new String[2];
            for (VariableElement field : ElementFilter.fieldsIn(e.getEnclosedElements())) {
                int i;
                existingFields.add(field.getSimpleName().toString());
                if (field.asType().equals(pcs)) {
                    i = field.getModifiers().contains((Object)Modifier.STATIC) ? 1 : 0;
                    pcsName[i] = field.getSimpleName().toString();
                }
                if (!field.asType().equals(vcs)) continue;
                i = field.getModifiers().contains((Object)Modifier.STATIC) ? 1 : 0;
                vcsName[i] = field.getSimpleName().toString();
            }
            String className = ((TypeElement)e).getQualifiedName().toString();
            return Collections.singletonList(new AddPropertyCodeGenerator(component, className, existingFields, pcsName, vcsName));
        }

        private static TypeMirror resolve(CompilationInfo info, String s) {
            TypeElement te = info.getElements().getTypeElement(s);
            if (te == null) {
                return null;
            }
            return te.asType();
        }
    }

    private static final class ImportFQNsHack
    extends TreePathScanner<Void, Void> {
        private WorkingCopy wc;
        private int start;
        private int end;

        public ImportFQNsHack(WorkingCopy wc, int start, int end) {
            this.wc = wc;
            this.start = start;
            this.end = end;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, Void p) {
            Element el;
            int s = (int)this.wc.getTrees().getSourcePositions().getStartPosition(this.wc.getCompilationUnit(), node);
            int e = (int)this.wc.getTrees().getSourcePositions().getEndPosition(this.wc.getCompilationUnit(), node);
            if (s >= this.start && e <= this.end && (el = this.wc.getTrees().getElement(this.getCurrentPath())) != null && (el.getKind().isClass() || el.getKind().isInterface()) && ((TypeElement)el).asType().getKind() != TypeKind.ERROR) {
                this.wc.rewrite((Tree)node, (Tree)this.wc.getTreeMaker().QualIdent(el));
                return null;
            }
            return (Void)super.visitMemberSelect(node, p);
        }

        @Override
        public Void visitClass(ClassTree node, Void p) {
            SourcePositions sourcePositions = this.wc.getTrees().getSourcePositions();
            TreeMaker make = this.wc.getTreeMaker();
            LinkedList<Tree> members = new LinkedList<Tree>();
            ClassTree classTree = node;
            for (Tree tree : node.getMembers()) {
                int s = (int)sourcePositions.getStartPosition(this.wc.getCompilationUnit(), tree);
                int e = (int)sourcePositions.getEndPosition(this.wc.getCompilationUnit(), tree);
                if (s < this.start || e > this.end) continue;
                classTree = make.removeClassMember(classTree, tree);
                members.add(tree);
            }
            classTree = GeneratorUtils.insertClassMembers(this.wc, classTree, members, this.start);
            this.wc.rewrite((Tree)node, (Tree)classTree);
            return (Void)super.visitClass(classTree, p);
        }
    }
}

